/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.TinyScrollButton;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class TinyScrollBarUI
extends BasicScrollBarUI {
    private static final HashMap cache = new HashMap();
    static final int ALPHA = 92;
    protected boolean isRollover = false;
    protected boolean wasRollover = false;
    private boolean freeStanding = false;
    private int scrollBarWidth;
    private boolean buttonsEnabled = true;

    public static void clearCache() {
        cache.clear();
    }

    private void calculateButtonsEnabled() {
        float f = this.scrollbar.getVisibleAmount();
        float f2 = this.scrollbar.getMaximum() - this.scrollbar.getMinimum();
        this.buttonsEnabled = f2 > f;
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        super.layoutVScrollbar(jScrollBar);
        this.calculateButtonsEnabled();
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        super.layoutHScrollbar(jScrollBar);
        this.calculateButtonsEnabled();
    }

    protected void installDefaults() {
        this.scrollBarWidth = Theme.scrollSize.getValue();
        super.installDefaults();
        this.scrollbar.setBorder(null);
        this.minimumThumbSize = new Dimension(17, 17);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyScrollBarUI();
    }

    protected JButton createDecreaseButton(int n) {
        return new TinyScrollButton(n, this);
    }

    protected JButton createIncreaseButton(int n) {
        return new TinyScrollButton(n, this);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    public void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        this.drawXpTrack(graphics, rectangle);
    }

    private void drawXpTrack(Graphics graphics, Rectangle rectangle) {
        if (this.isThumbVisible()) {
            graphics.setColor(Theme.scrollTrackColor.getColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Theme.scrollTrackBorderColor.getColor());
        } else {
            graphics.setColor(Theme.scrollTrackDisabledColor.getColor());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Theme.scrollTrackBorderDisabledColor.getColor());
        }
        if (this.scrollbar.getOrientation() == 1) {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        } else {
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        }
    }

    public void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (rectangle.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpThumbNoCache(graphics, jComponent, rectangle);
        } else {
            this.drawXpThumb(graphics, jComponent, rectangle);
        }
    }

    private void drawXpThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n;
        int n2 = Theme.scrollSpreadLight.getValue();
        int n3 = Theme.scrollSpreadDark.getValue();
        ColorUIResource colorUIResource = null;
        colorUIResource = this.isDragging && this.isRollover ? Theme.scrollThumbPressedColor.getColor() : (this.isRollover && Theme.scrollRollover.getValue() ? Theme.scrollThumbRolloverColor.getColor() : Theme.scrollThumbColor.getColor());
        ThumbKey thumbKey = new ThumbKey(colorUIResource, n2, n3, this.scrollbar.getOrientation() == 1, rectangle.getSize());
        Object v = cache.get(thumbKey);
        if (v != null) {
            graphics.drawImage((Image)v, rectangle.x, rectangle.y, jComponent);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(colorUIResource);
        int n4 = 0;
        int n5 = 0;
        int n6 = rectangle.width - 1;
        int n7 = rectangle.height - 1;
        float f = 10.0f * (float)n2 / 10.0f;
        float f2 = 10.0f * (float)n3 / 10.0f;
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                int n8;
                n = rectangle.width - 2;
                int n9 = rectangle.width * 3 / 8;
                for (int i = 1; i < n; ++i) {
                    if (i < n9) {
                        n8 = n9 - i;
                        graphics2.setColor(ColorRoutines.lighten(colorUIResource, (int)((float)n8 * f)));
                    } else if (i == n9) {
                        graphics2.setColor(colorUIResource);
                    } else {
                        n8 = i - n9;
                        graphics2.setColor(ColorRoutines.darken(colorUIResource, (int)((float)n8 * f2)));
                    }
                    graphics2.drawLine(n4 + i, n5 + 2, n4 + i, n7 - 1);
                }
                graphics2.setColor(Theme.scrollBorderLightColor.getColor());
                graphics2.drawLine(n4 + 3, n5 + 1, n4 + rectangle.width - 3, n5 + 1);
                graphics2.drawLine(n4 + rectangle.width - 2, n5 + 2, n4 + rectangle.width - 2, n7 - 2);
                graphics2.setColor(Theme.scrollBorderColor.getColor());
                graphics2.drawRect(n4 + 1, n5, n4 + rectangle.width - 2, n7 - n5);
                ColorUIResource colorUIResource2 = Theme.scrollBorderColor.getColor();
                graphics2.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics2.drawLine(n4 + 2, n5 + 1, n4 + 2, n5 + 1);
                graphics2.drawLine(n4 + rectangle.width - 2, n5 + 1, n4 + rectangle.width - 2, n5 + 1);
                graphics2.drawLine(n4 + 2, n7 - 1, n4 + 2, n7 - 1);
                graphics2.drawLine(n4 + rectangle.width - 2, n7 - 1, n4 + rectangle.width - 2, n7 - 1);
                colorUIResource2 = Theme.scrollBorderLightColor.getColor();
                graphics2.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics2.drawLine(n4 + 1, n5, n4 + 1, n5);
                graphics2.drawLine(n4 + rectangle.width - 1, n5, n4 + rectangle.width - 1, n5);
                graphics2.drawLine(n4 + 1, n7, n4 + 1, n7);
                graphics2.drawLine(n4 + rectangle.width - 1, n7, n4 + rectangle.width - 1, n7);
                break;
            }
            case 0: {
                int n8;
                n = rectangle.height - 2;
                int n9 = rectangle.height * 3 / 8;
                for (int i = 1; i < n; ++i) {
                    if (i < n9) {
                        n8 = n9 - i;
                        graphics2.setColor(ColorRoutines.lighten(colorUIResource, (int)((float)n8 * f)));
                    } else if (i == n9) {
                        graphics2.setColor(colorUIResource);
                    } else {
                        n8 = i - n9;
                        graphics2.setColor(ColorRoutines.darken(colorUIResource, (int)((float)n8 * f2)));
                    }
                    graphics2.drawLine(n4 + 1, n5 + i, n6 - 2, n5 + i);
                }
                graphics2.setColor(Theme.scrollBorderLightColor.getColor());
                graphics2.drawLine(n4 + 2, n5 + rectangle.height - 2, n6 - 2, n5 + rectangle.height - 2);
                graphics2.drawLine(n6 - 1, n5 + 3, n6 - 1, n5 + 14);
                graphics2.setColor(Theme.scrollBorderColor.getColor());
                graphics2.drawRect(n4, n5 + 1, n6 - n4, n5 + rectangle.height - 2);
                graphics2.setColor(Theme.scrollTrackBorderColor.getColor());
                graphics2.drawLine(n4, n5, n6, n5);
                ColorUIResource colorUIResource2 = Theme.scrollBorderColor.getColor();
                graphics2.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics2.drawLine(n4 + 1, n5 + 2, n4 + 1, n5 + 2);
                graphics2.drawLine(n4 + 1, n5 + rectangle.height - 2, n4 + 1, n5 + rectangle.height - 2);
                graphics2.drawLine(n6 - 1, n5 + 2, n6 - 1, n5 + 2);
                graphics2.drawLine(n6 - 1, n5 + rectangle.height - 2, n6 - 1, n5 + rectangle.height - 2);
                colorUIResource2 = Theme.scrollBorderLightColor.getColor();
                graphics2.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics2.drawLine(n4, n5 + 1, n4, n5 + 1);
                graphics2.drawLine(n4, n5 + rectangle.height - 1, n4, n5 + rectangle.height - 1);
                graphics2.drawLine(n6, n5 + 1, n6, n5 + 1);
                graphics2.drawLine(n6, n5 + rectangle.height - 1, n6, n5 + rectangle.height - 1);
            }
        }
        if (rectangle.height < 13) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            n5 = rectangle.height / 2 - 4;
            n7 = Math.min(n5 + 8, rectangle.height - 3);
            n4 = rectangle.width / 4 + 1;
            n6 = rectangle.width - rectangle.width / 4 - 2;
            graphics2.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (n = n5 + 1; n < n7; n += 2) {
                graphics2.drawLine(n4, n, n6, n);
            }
            n4 = rectangle.width / 4 + 2;
            n6 = rectangle.width - rectangle.width / 4 - 1;
            graphics2.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (n = n5; n < n7; n += 2) {
                graphics2.drawLine(n4, n, n6, n);
            }
        } else {
            n4 = rectangle.width / 2 - 4;
            n6 = Math.min(n4 + 8, rectangle.width - 3);
            n5 = rectangle.height / 4 + 1;
            n7 = rectangle.height - rectangle.height / 4 - 2;
            graphics2.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (n = n4 + 1; n < n6; n += 2) {
                graphics2.drawLine(n, n5, n, n7);
            }
            n5 = rectangle.height / 4 + 2;
            n7 = rectangle.height - rectangle.height / 4 - 1;
            graphics2.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (n = n4; n < n6; n += 2) {
                graphics2.drawLine(n, n5, n, n7);
            }
        }
        graphics2.dispose();
        graphics.drawImage(bufferedImage, rectangle.x, rectangle.y, jComponent);
        cache.put(thumbKey, bufferedImage);
    }

    private void drawXpThumbNoCache(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        ColorUIResource colorUIResource = null;
        colorUIResource = this.isDragging && this.isRollover ? Theme.scrollThumbPressedColor.getColor() : (this.isRollover && Theme.scrollRollover.getValue() ? Theme.scrollThumbRolloverColor.getColor() : Theme.scrollThumbColor.getColor());
        graphics.setColor(colorUIResource);
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        int n6 = Theme.scrollSpreadLight.getValue();
        int n7 = Theme.scrollSpreadDark.getValue();
        float f = 10.0f * (float)n6 / 10.0f;
        float f2 = 10.0f * (float)n7 / 10.0f;
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                n3 = rectangle.width - 2;
                n2 = rectangle.width * 3 / 8;
                for (int i = 1; i < n3; ++i) {
                    if (i < n2) {
                        n = n2 - i;
                        graphics.setColor(ColorRoutines.lighten(colorUIResource, (int)((float)n * f)));
                    } else if (i == n2) {
                        graphics.setColor(colorUIResource);
                    } else {
                        n = i - n2;
                        graphics.setColor(ColorRoutines.darken(colorUIResource, (int)((float)n * f2)));
                    }
                    graphics.drawLine(rectangle.x + i, rectangle.y + 2, rectangle.x + i, n5 - 1);
                }
                graphics.setColor(Theme.scrollBorderLightColor.getColor());
                graphics.drawLine(rectangle.x + 3, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
                graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, n5 - 2);
                graphics.setColor(Theme.scrollBorderColor.getColor());
                graphics.drawRect(rectangle.x + 1, rectangle.y, rectangle.x + rectangle.width - 2, n5 - rectangle.y);
                ColorUIResource colorUIResource2 = Theme.scrollBorderColor.getColor();
                graphics.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + 2, rectangle.y + 1);
                graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + 1);
                graphics.drawLine(rectangle.x + 2, n5 - 1, rectangle.x + 2, n5 - 1);
                graphics.drawLine(rectangle.x + rectangle.width - 2, n5 - 1, rectangle.x + rectangle.width - 2, n5 - 1);
                colorUIResource2 = Theme.scrollBorderLightColor.getColor();
                graphics.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y);
                graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
                graphics.drawLine(rectangle.x + 1, n5, rectangle.x + 1, n5);
                graphics.drawLine(rectangle.x + rectangle.width - 1, n5, rectangle.x + rectangle.width - 1, n5);
                break;
            }
            case 0: {
                n3 = rectangle.height - 2;
                n2 = rectangle.height * 3 / 8;
                for (int i = 1; i < n3; ++i) {
                    if (i < n2) {
                        n = n2 - i;
                        graphics.setColor(ColorRoutines.lighten(colorUIResource, (int)((float)n * f)));
                    } else if (i == n2) {
                        graphics.setColor(colorUIResource);
                    } else {
                        n = i - n2;
                        graphics.setColor(ColorRoutines.darken(colorUIResource, (int)((float)n * f2)));
                    }
                    graphics.drawLine(rectangle.x + 1, rectangle.y + i, n4 - 2, rectangle.y + i);
                }
                graphics.setColor(Theme.scrollBorderLightColor.getColor());
                graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, n4 - 2, rectangle.y + rectangle.height - 2);
                graphics.drawLine(n4 - 1, rectangle.y + 3, n4 - 1, rectangle.y + 14);
                graphics.setColor(Theme.scrollBorderColor.getColor());
                graphics.drawRect(rectangle.x, rectangle.y + 1, n4 - rectangle.x, rectangle.y + rectangle.height - 2);
                graphics.setColor(Theme.scrollTrackBorderColor.getColor());
                graphics.drawLine(rectangle.x, rectangle.y, n4, rectangle.y);
                ColorUIResource colorUIResource2 = Theme.scrollBorderColor.getColor();
                graphics.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics.drawLine(rectangle.x + 1, rectangle.y + 2, rectangle.x + 1, rectangle.y + 2);
                graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + 1, rectangle.y + rectangle.height - 2);
                graphics.drawLine(n4 - 1, rectangle.y + 2, n4 - 1, rectangle.y + 2);
                graphics.drawLine(n4 - 1, rectangle.y + rectangle.height - 2, n4 - 1, rectangle.y + rectangle.height - 2);
                colorUIResource2 = Theme.scrollBorderLightColor.getColor();
                graphics.setColor(new Color(colorUIResource2.getRed(), colorUIResource2.getGreen(), colorUIResource2.getBlue(), 92));
                graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x, rectangle.y + 1);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height - 1);
                graphics.drawLine(n4, rectangle.y + 1, n4, rectangle.y + 1);
                graphics.drawLine(n4, rectangle.y + rectangle.height - 1, n4, rectangle.y + rectangle.height - 1);
            }
        }
        if (rectangle.height < 13) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1) {
            n3 = rectangle.y + rectangle.height / 2 - 4;
            n5 = Math.min(n3 + 8, rectangle.y + rectangle.height - 3);
            n2 = rectangle.x + rectangle.width / 4 + 1;
            n4 = rectangle.x + rectangle.width - rectangle.width / 4 - 2;
            graphics.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (n = n3 + 1; n < n5; n += 2) {
                graphics.drawLine(n2, n, n4, n);
            }
            n2 = rectangle.x + rectangle.width / 4 + 2;
            n4 = rectangle.x + rectangle.width - rectangle.width / 4 - 1;
            graphics.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (n = n3; n < n5; n += 2) {
                graphics.drawLine(n2, n, n4, n);
            }
        } else {
            n3 = rectangle.x + rectangle.width / 2 - 4;
            n4 = Math.min(n3 + 8, rectangle.x + rectangle.width - 3);
            n2 = rectangle.y + rectangle.height / 4 + 1;
            n5 = rectangle.y + rectangle.height - rectangle.height / 4 - 2;
            graphics.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripLightColor.getSaturation(), Theme.scrollGripLightColor.getBrightness()));
            for (n = n3 + 1; n < n4; n += 2) {
                graphics.drawLine(n, n2, n, n5);
            }
            n2 = rectangle.y + rectangle.height / 4 + 2;
            n5 = rectangle.y + rectangle.height - rectangle.height / 4 - 1;
            graphics.setColor(ColorRoutines.getAdjustedColor(colorUIResource, Theme.scrollGripDarkColor.getSaturation(), Theme.scrollGripDarkColor.getBrightness()));
            for (n = n3; n < n4; n += 2) {
                graphics.drawLine(n, n2, n, n5);
            }
        }
    }

    public boolean isThumbVisible() {
        return this.buttonsEnabled;
    }

    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new MyTrackListener();
    }

    private static class ThumbKey {
        private Color c;
        private int spread1;
        private int spread2;
        private Dimension size;
        private boolean vertical;

        ThumbKey(Color color, int n, int n2, boolean bl, Dimension dimension) {
            this.c = color;
            this.spread1 = n;
            this.spread2 = n2;
            this.vertical = bl;
            this.size = dimension;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ThumbKey)) {
                return false;
            }
            ThumbKey thumbKey = (ThumbKey)object;
            return this.spread1 == thumbKey.spread1 && this.spread2 == thumbKey.spread2 && this.vertical == thumbKey.vertical && this.size.equals(thumbKey.size) && this.c.equals(thumbKey.c);
        }

        public int hashCode() {
            return this.c.hashCode() * this.size.hashCode() * (this.vertical ? 1 : 2) * this.spread1 * this.spread2;
        }
    }

    protected class OrientationChangeListener
    implements PropertyChangeListener {
        protected OrientationChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if (TinyScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                if (TinyScrollBarUI.this.incrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.incrButton).setDirection(n == 0 ? 3 : 5);
                }
                if (TinyScrollBarUI.this.decrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.decrButton).setDirection(n == 0 ? 7 : 1);
                }
            } else {
                if (TinyScrollBarUI.this.incrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.incrButton).setDirection(n == 0 ? 7 : 5);
                }
                if (TinyScrollBarUI.this.decrButton instanceof TinyScrollButton) {
                    ((TinyScrollButton)TinyScrollBarUI.this.decrButton).setDirection(n == 0 ? 3 : 1);
                }
            }
        }
    }

    protected class MyTrackListener
    extends BasicScrollBarUI.TrackListener {
        protected MyTrackListener() {
            super(TinyScrollBarUI.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            TinyScrollBarUI.this.scrollbar.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            TinyScrollBarUI.this.scrollbar.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TinyScrollBarUI.this.isRollover = false;
            TinyScrollBarUI.this.wasRollover = false;
            if (TinyScrollBarUI.this.getThumbBounds().contains(mouseEvent.getPoint())) {
                TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover = true;
                TinyScrollBarUI.this.scrollbar.repaint();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            TinyScrollBarUI.this.isRollover = false;
            if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                TinyScrollBarUI.this.scrollbar.repaint();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (TinyScrollBarUI.this.getThumbBounds().contains(mouseEvent.getPoint())) {
                TinyScrollBarUI.this.isDragging = true;
            }
            super.mouseDragged(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (TinyScrollBarUI.this.getThumbBounds().contains(mouseEvent.getPoint())) {
                TinyScrollBarUI.this.isRollover = true;
                if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                    TinyScrollBarUI.this.scrollbar.repaint();
                    TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                }
            } else {
                TinyScrollBarUI.this.isRollover = false;
                if (TinyScrollBarUI.this.isRollover != TinyScrollBarUI.this.wasRollover) {
                    TinyScrollBarUI.this.scrollbar.repaint();
                    TinyScrollBarUI.this.wasRollover = TinyScrollBarUI.this.isRollover;
                }
            }
        }
    }
}

