/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyCheckBoxIcon;
import de.muntjak.tinylookandfeel.TinyLookAndFeel;
import de.muntjak.tinylookandfeel.util.ColorRoutines;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.plaf.ColorUIResource;

class TinyRadioButtonIcon
extends TinyCheckBoxIcon {
    private static final HashMap cache = new HashMap();
    private static final int[][] ALPHA = new int[][]{{255, 255, 255, 242, 228, 209, 187, 165, 142, 255, 255}, {255, 255, 242, 228, 209, 187, 165, 142, 120, 104, 255}, {255, 242, 228, 209, 187, 165, 142, 120, 104, 86, 72}, {242, 228, 209, 187, 165, 142, 120, 104, 86, 72, 56}, {228, 209, 187, 165, 142, 120, 104, 86, 72, 56, 42}, {209, 187, 165, 142, 120, 104, 86, 72, 56, 42, 28}, {187, 165, 142, 120, 104, 86, 72, 56, 42, 28, 17}, {165, 142, 120, 104, 86, 72, 56, 42, 28, 17, 9}, {142, 120, 104, 86, 72, 56, 42, 28, 17, 9, 0}, {255, 104, 86, 72, 56, 42, 28, 17, 9, 0, 255}, {255, 255, 72, 56, 42, 28, 17, 9, 0, 255, 255}};

    TinyRadioButtonIcon() {
    }

    public static void clearCache() {
        cache.clear();
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        AbstractButton abstractButton = (AbstractButton)component;
        ColorUIResource colorUIResource = null;
        colorUIResource = !abstractButton.isEnabled() ? Theme.buttonDisabledColor.getColor() : (abstractButton.getModel().isPressed() ? (abstractButton.getModel().isRollover() || abstractButton.getModel().isArmed() ? Theme.buttonPressedColor.getColor() : Theme.buttonNormalColor.getColor()) : (abstractButton.getModel().isRollover() ? Theme.buttonRolloverBgColor.getColor() : Theme.buttonNormalColor.getColor()));
        graphics.setColor(colorUIResource);
        if (TinyLookAndFeel.controlPanelInstantiated) {
            this.drawXpRadioNoCache(graphics, abstractButton, colorUIResource, n, n2, this.getIconWidth(), this.getIconHeight());
        } else {
            this.drawXpRadio(graphics, abstractButton, colorUIResource, n, n2, this.getIconWidth(), this.getIconHeight());
        }
        if (!abstractButton.isSelected()) {
            return;
        }
        colorUIResource = !abstractButton.isEnabled() ? Theme.buttonCheckDisabledColor.getColor() : Theme.buttonCheckColor.getColor();
        graphics.setColor(colorUIResource);
        this.drawXpCheckMark(graphics, colorUIResource, n, n2);
    }

    private void drawXpRadio(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, int n3, int n4) {
        Object v;
        Object object;
        boolean bl = abstractButton.getModel().isPressed();
        boolean bl2 = abstractButton.getModel().isArmed();
        boolean bl3 = abstractButton.isEnabled();
        boolean bl4 = abstractButton.getModel().isRollover();
        boolean bl5 = Theme.buttonFocusBorder.getValue() && !bl4 && abstractButton.isFocusOwner();
        Color color2 = abstractButton.getBackground();
        if (!abstractButton.isOpaque()) {
            color2 = ((Component)object).getBackground();
            for (object = abstractButton.getParent(); object != null && !((Component)object).isOpaque(); object = ((Component)object).getParent()) {
                color2 = ((Component)object).getBackground();
            }
        }
        if ((v = cache.get(object = new RadioKey(color, color2, bl, bl3, bl4 || bl2, bl5))) != null) {
            graphics.drawImage((Image)v, n, n2, abstractButton);
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
        Graphics graphics2 = ((Image)bufferedImage).getGraphics();
        graphics2.setColor(color2);
        graphics2.fillRect(0, 0, n3, n4);
        int n5 = Theme.buttonSpreadLight.getValue();
        int n6 = Theme.buttonSpreadDark.getValue();
        if (!bl3) {
            n5 = Theme.buttonSpreadLightDisabled.getValue();
            n6 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int n7 = n5 * 5;
        int n8 = n6 * 4;
        if (bl && (bl4 || bl2)) {
            n8 *= 2;
        }
        color = ColorRoutines.lighten(color, n7);
        graphics2.setColor(ColorRoutines.darken(color, n8));
        graphics2.fillRect(2, 2, n3 - 4, n4 - 4);
        graphics2.fillRect(1, 5, 1, 3);
        graphics2.fillRect(11, 5, 1, 3);
        graphics2.fillRect(5, 1, 3, 1);
        graphics2.fillRect(5, 11, 3, 1);
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - ALPHA[j][i]);
                graphics2.setColor(color3);
                graphics2.drawLine(j + 1, i + 1, j + 1, i + 1);
            }
        }
        if (!bl3) {
            DrawRoutines.drawXpRadioBorder(graphics2, Theme.buttonBorderDisabledColor.getColor(), 0, 0, n3, n4);
        } else {
            if (bl4 && Theme.buttonRolloverBorder.getValue() && !bl) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics2, Theme.buttonRolloverColor.getColor(), 0, 0, n3, n4);
            } else if (bl5 && !bl) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics2, Theme.buttonDefaultColor.getColor(), 0, 0, n3, n4);
            }
            DrawRoutines.drawXpRadioBorder(graphics2, Theme.buttonBorderColor.getColor(), 0, 0, n3, n4);
        }
        graphics2.dispose();
        graphics.drawImage(bufferedImage, n, n2, abstractButton);
        cache.put(object, bufferedImage);
    }

    private void drawXpRadioNoCache(Graphics graphics, AbstractButton abstractButton, Color color, int n, int n2, int n3, int n4) {
        Color color2;
        boolean bl = abstractButton.getModel().isPressed();
        boolean bl2 = abstractButton.getModel().isArmed();
        boolean bl3 = abstractButton.isEnabled();
        boolean bl4 = abstractButton.getModel().isRollover();
        boolean bl5 = Theme.buttonFocusBorder.getValue() && !bl4 && abstractButton.isFocusOwner();
        boolean bl6 = !bl && !bl2 && !bl4 && !bl5;
        BufferedImage bufferedImage = null;
        Object object = null;
        if (bl6) {
            object = bl3 ? new EnabledRadioKey(color, Theme.buttonBorderColor.getColor()) : new DisabledRadioKey(color, Theme.buttonBorderDisabledColor.getColor());
            Object v = cache.get(object);
            if (v != null) {
                graphics.drawImage((Image)v, n, n2, abstractButton);
                return;
            }
            bufferedImage = new BufferedImage(n3, n4, 2);
        }
        int n5 = Theme.buttonSpreadLight.getValue();
        int n6 = Theme.buttonSpreadDark.getValue();
        if (!bl3) {
            n5 = Theme.buttonSpreadLightDisabled.getValue();
            n6 = Theme.buttonSpreadDarkDisabled.getValue();
        }
        int n7 = n5 * 5;
        int n8 = n6 * 4;
        if (bl && (bl4 || bl2)) {
            n8 *= 2;
        }
        color = ColorRoutines.lighten(color, n7);
        Graphics graphics2 = null;
        int n9 = n;
        int n10 = n2;
        if (bufferedImage != null) {
            graphics2 = ((Image)bufferedImage).getGraphics();
            color2 = abstractButton.getBackground();
            if (!abstractButton.isOpaque()) {
                Container container;
                color2 = container.getBackground();
                for (container = abstractButton.getParent(); container != null && !container.isOpaque(); container = container.getParent()) {
                    color2 = container.getBackground();
                }
            }
            graphics2.setColor(color2);
            graphics2.fillRect(0, 0, n3 - 1, n4 - 1);
            n9 = 0;
            n10 = 0;
        } else {
            graphics2 = graphics;
            graphics2.translate(n, n2);
        }
        graphics2.setColor(ColorRoutines.darken(color, n8));
        graphics2.fillRect(2, 2, n3 - 4, n4 - 4);
        graphics2.fillRect(1, 5, 1, 3);
        graphics2.fillRect(11, 5, 1, 3);
        graphics2.fillRect(6, 1, 1, 1);
        graphics2.fillRect(6, 11, 1, 1);
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 11; ++j) {
                color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - ALPHA[j][i]);
                graphics2.setColor(color2);
                graphics2.drawLine(j + 1, i + 1, j + 1, i + 1);
            }
        }
        if (bufferedImage == null) {
            graphics2.translate(-n, -n2);
        }
        if (!bl3) {
            DrawRoutines.drawXpRadioBorder(graphics2, Theme.buttonBorderDisabledColor.getColor(), n9, n10, n3, n4);
        } else {
            if (bl4 && Theme.buttonRolloverBorder.getValue() && !bl) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics2, Theme.buttonRolloverColor.getColor(), n9, n10, n3, n4);
            } else if (bl5 && !bl) {
                DrawRoutines.drawXpRadioRolloverBorder(graphics2, Theme.buttonDefaultColor.getColor(), n9, n10, n3, n4);
            }
            DrawRoutines.drawXpRadioBorder(graphics2, Theme.buttonBorderColor.getColor(), n9, n10, n3, n4);
        }
        if (bufferedImage != null) {
            graphics2.dispose();
            graphics.drawImage(bufferedImage, n, n2, abstractButton);
            cache.put(object, bufferedImage);
        }
    }

    private void drawXpCheckMark(Graphics graphics, Color color, int n, int n2) {
        graphics.translate(n, n2);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 224));
        graphics.fillRect(5, 5, 3, 3);
        graphics.setColor(color);
        graphics.drawLine(6, 6, 6, 6);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 192));
        graphics.drawLine(6, 4, 6, 4);
        graphics.drawLine(4, 6, 4, 6);
        graphics.drawLine(8, 6, 8, 6);
        graphics.drawLine(6, 8, 6, 8);
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
        graphics.drawLine(5, 4, 5, 4);
        graphics.drawLine(7, 4, 7, 4);
        graphics.drawLine(4, 5, 4, 5);
        graphics.drawLine(8, 5, 8, 5);
        graphics.drawLine(4, 7, 4, 7);
        graphics.drawLine(8, 7, 8, 7);
        graphics.drawLine(5, 8, 5, 8);
        graphics.drawLine(7, 8, 7, 8);
        graphics.translate(-n, -n2);
    }

    private static class RadioKey {
        private Color c;
        private Color background;
        private boolean pressed;
        private boolean enabled;
        private boolean rollover;
        private boolean focused;

        RadioKey(Color color, Color color2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.c = color;
            this.background = color2;
            this.pressed = bl;
            this.enabled = bl2;
            this.rollover = bl3;
            this.focused = bl4;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RadioKey)) {
                return false;
            }
            RadioKey radioKey = (RadioKey)object;
            return this.pressed == radioKey.pressed && this.enabled == radioKey.enabled && this.rollover == radioKey.rollover && this.focused == radioKey.focused && this.c.equals(radioKey.c) && this.background.equals(radioKey.background);
        }

        public int hashCode() {
            return this.c.hashCode() * this.background.hashCode() * (this.pressed ? 1 : 2) * (this.enabled ? 4 : 8) * (this.rollover ? 16 : 32);
        }
    }

    private static class DisabledRadioKey {
        int spread1 = Theme.buttonSpreadLightDisabled.getValue();
        int spread2 = Theme.buttonSpreadDarkDisabled.getValue();
        Color c;
        Color back;

        DisabledRadioKey(Color color, Color color2) {
            this.c = color;
            this.back = color2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof DisabledRadioKey)) {
                return false;
            }
            DisabledRadioKey disabledRadioKey = (DisabledRadioKey)object;
            return this.c.equals(disabledRadioKey.c) && this.back.equals(disabledRadioKey.back) && this.spread1 == disabledRadioKey.spread1 && this.spread2 == disabledRadioKey.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }

    private static class EnabledRadioKey {
        int spread1 = Theme.buttonSpreadLight.getValue();
        int spread2 = Theme.buttonSpreadDark.getValue();
        Color c;
        Color back;

        EnabledRadioKey(Color color, Color color2) {
            this.c = color;
            this.back = color2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof EnabledRadioKey)) {
                return false;
            }
            EnabledRadioKey enabledRadioKey = (EnabledRadioKey)object;
            return this.c.equals(enabledRadioKey.c) && this.back.equals(enabledRadioKey.back) && this.spread1 == enabledRadioKey.spread1 && this.spread2 == enabledRadioKey.spread2;
        }

        public int hashCode() {
            return this.c.hashCode() * this.back.hashCode() * this.spread1 * this.spread2;
        }
    }
}

