/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.renderers.GaugePainter;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.cq;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class BasicReadoutGaugePainter
implements GaugePainter {
    int lastWidth = 0;
    int lastHeight = 0;
    String lastDisplayVal = "";
    final String name = "Basic Readout";
    private String fontName = null;
    int maxStringWidth = 0;
    transient Font titleFont = null;
    transient Font valueFont = null;
    transient Color backColor = null;
    Image backgroundImg = null;
    int lastDigits = 0;

    @Override
    public String getName() {
        return "Basic Readout";
    }

    private void checkFontFamily(Gauge gauge) {
        if (this.fontName == null) {
            Font font = cq.a().a(gauge.getFontFamily(), 1, 12);
            this.fontName = font.canDisplayUpTo(gauge.title()) >= 0 || font.canDisplayUpTo(gauge.units()) >= 0 ? "Arial Unicode MS" : gauge.getFontFamily();
        }
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        this.checkFontFamily(gauge);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (gauge.isAntialiasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n2 = gauge.getWidth();
        int n3 = gauge.getHeight();
        if (this.backgroundImg == null || this.backgroundImg.getWidth(null) != n2 || this.backgroundImg.getHeight(null) != n3) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.backgroundImg = graphicsConfiguration.createCompatibleImage(n2, n3, 3);
            this.paintBackground(this.backgroundImg.getGraphics(), gauge);
        }
        graphics.drawImage(this.backgroundImg, 0, 0, null);
        this.paintValues(graphics, gauge);
        this.paintBorder(graphics, gauge);
    }

    private void paintBackground(Graphics graphics, Gauge gauge) {
        int n2 = gauge.getWidth();
        int n3 = gauge.getHeight();
        this.lastWidth = n2;
        this.lastHeight = n3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.backColor = this.getCurrentBackColor(gauge);
        if (this.backColor != null && this.backColor.getAlpha() > 0) {
            graphics.setColor(this.backColor);
            if (gauge.getBorderWidth() > 0) {
                graphics.fillRect(0, 0, n2, n3);
            } else {
                graphics.fillRoundRect(0, 0, n2, n3, gauge.getHeight() / 4, gauge.getHeight() / 4);
            }
        }
        if (gauge.backgroundImage() != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(gauge.backgroundImage(), 0, 0, n2, n3, null);
        }
    }

    private Color getCurrentBackColor(Gauge gauge) {
        Color color = null;
        color = gauge.getValue() > gauge.highCritical() || gauge.getValue() < gauge.lowCritical() ? gauge.getCriticalColor() : (gauge.getValue() > gauge.highWarning() || gauge.getValue() < gauge.lowWarning() ? gauge.getWarnColor() : gauge.getBackColor());
        return color;
    }

    private void paintValues(Graphics graphics, Gauge gauge) {
        String string = gauge.getDisplayValue();
        if (string.length() != this.lastDigits) {
            this.titleFont = null;
            this.valueFont = null;
            this.lastDigits = string.length();
        }
        Font font = this.getValueFont(gauge);
        Font font2 = this.getTitleFont(gauge);
        boolean bl2 = gauge.title().equals("") && gauge.units().equals("");
        int n2 = bl2 ? gauge.getBorderWidth() + (gauge.getHeight() - 2 * gauge.getBorderWidth()) / 2 + (int)((double)font.getSize() * 0.37) : gauge.getBorderWidth() + (gauge.getHeight() - 2 * gauge.getBorderWidth()) / 2 + (int)((double)font.getSize() * 0.2);
        graphics.setFont(font);
        graphics.setColor(gauge.getFontColor());
        int n3 = (gauge.getWidth() - graphics.getFontMetrics().stringWidth(string)) / 2;
        graphics.drawString(string, n3, n2);
        this.lastDisplayVal = string;
        graphics.setFont(font2);
        String string2 = gauge.title();
        if (gauge.units() != null && !gauge.units().equals("")) {
            string2 = string2 + " (" + gauge.units() + ")";
        }
        n3 = (n3 = (gauge.getWidth() - graphics.getFontMetrics().stringWidth(string2)) / 2) < gauge.getBorderWidth() ? gauge.getBorderWidth() : n3;
        graphics.drawString(string2, n3, n2 += (int)((double)graphics.getFont().getSize() * 1.1));
    }

    private Font getValueFont(Gauge gauge) {
        if (this.valueFont == null) {
            this.setFonts(gauge);
        }
        return this.valueFont;
    }

    private Font getTitleFont(Gauge gauge) {
        if (this.titleFont == null) {
            this.setFonts(gauge);
        }
        return this.titleFont;
    }

    private void setFonts(Gauge gauge) {
        int n2;
        int n3 = gauge.getHeight();
        double d2 = 0.79;
        if (gauge.getHeight() > gauge.getWidth()) {
            d2 = Math.pow(d2, 2.0) * ((double)gauge.getWidth() / (double)gauge.getHeight());
        }
        if (gauge.title().equals("") && gauge.units().equals("")) {
            d2 += 0.19;
        }
        int n4 = n3 - gauge.getBorderWidth() * 2;
        int n5 = (int)((double)n4 * d2) + gauge.getFontSizeAdjustment() * n4 / 30;
        int n6 = n4 / 4;
        int n7 = 10;
        if (n5 < 0) {
            n5 = 1;
            n6 = 1;
        } else if (n6 < n7) {
            n2 = n5 + n6;
            if (n2 > n7 * 2) {
                n6 = n7;
                n5 = n2 - n7;
            } else {
                n6 = n2 / 2;
                n5 = n2 / 2;
            }
        } else {
            n6 = n4 / 4;
        }
        n2 = gauge.isItalicFont() ? 3 : 1;
        String string = gauge.getDisplayValue();
        int n8 = (int)((double)(gauge.getWidth() - 2 * gauge.getBorderWidth()) * 0.98);
        do {
            this.valueFont = cq.a().a(gauge.getFontFamily(), n2, n5--);
        } while (gauge.getFontMetrics(this.valueFont).stringWidth(string) > n8);
        String string2 = gauge.title();
        if (gauge.units() != null && !gauge.units().equals("")) {
            string2 = string2 + " (" + gauge.units() + ")";
        }
        do {
            this.titleFont = cq.a().a(this.fontName, n2, n6--);
        } while (gauge.getFontMetrics(this.titleFont).stringWidth(string2) > n8);
    }

    private void paintBorder(Graphics graphics, Gauge gauge) {
        int n2 = gauge.getWidth();
        int n3 = gauge.getHeight();
        graphics.setColor(gauge.getTrimColor());
        for (int i2 = 0; i2 < gauge.getBorderWidth(); ++i2) {
            graphics.draw3DRect(i2, i2, n2 - 2 * i2 - 1, n3 - 2 * i2 - 1, i2 < gauge.getBorderWidth() / 2);
        }
    }

    @Override
    public void invalidate() {
        this.fontName = null;
        this.titleFont = null;
        this.valueFont = null;
        this.backgroundImg = null;
    }

    @Override
    public void initialize(Gauge gauge) {
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        return s2.getWidth() != this.lastWidth || s2.getHeight() != this.lastHeight || this.backColor == null || !this.backColor.equals(this.getCurrentBackColor((Gauge)s2));
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
        if (s2.isAntialiasingOn()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintValues(graphics, (Gauge)s2);
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        this.paintBackground(graphics, (Gauge)s2);
        this.paintBorder(graphics, (Gauge)s2);
    }

    @Override
    public Area areaPainted(s s2) {
        Area area;
        Gauge gauge = (Gauge)s2;
        if (gauge.getBackColor().getAlpha() > 50) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, gauge.getWidth(), gauge.getHeight());
            area = new Area(double_);
        } else {
            area = new Area();
        }
        return area;
    }
}

