/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import bH.X;
import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.aR;
import com.efiAnalytics.apps.ts.dashboard.renderers.GaugePainter;
import com.efiAnalytics.apps.ts.dashboard.renderers.b;
import com.efiAnalytics.apps.ts.dashboard.renderers.c;
import com.efiAnalytics.apps.ts.dashboard.renderers.g;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.cq;
import com.efiAnalytics.ui.dL;
import com.efiAnalytics.ui.eJ;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AsymetricSweepRenderer
implements aR,
GaugePainter {
    int barThickness = eJ.a(10);
    private GradientPaint outerGradient = null;
    double lastValue = 0.0;
    transient Image bottomOffImage = null;
    transient Image topOffImage = null;
    transient List numberPositions = null;
    g tickStroke = new g(eJ.a(4), 1, 1);
    private b barShape = null;
    HashMap darkColorCache = new HashMap();

    @Override
    public void initialize(Gauge gauge) {
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    @Override
    public String getName() {
        return "Asymetric Sweep Gauge";
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Image image = this.getBottomOffImage(gauge);
        Graphics2D graphics2D2 = (Graphics2D)image.getGraphics();
        graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(image, 0, 0, null);
        this.paintNeedle(graphics2D, gauge, false);
        boolean bl2 = true;
        if (bl2) {
            graphics.drawImage(this.getTopOffImage(gauge), 0, 0, null);
        } else {
            this.paintNumbers(graphics2D, gauge);
            this.paintBorder(graphics2D, gauge);
        }
    }

    private void paintNumbers(Graphics2D graphics2D, Gauge gauge) {
        if (gauge.getFontColor().getAlpha() > 0) {
            List list = this.getNumberPositions(gauge);
            float f2 = (float)this.getBarShape((Gauge)gauge).j * 0.08f;
            int n2 = Math.round((float)(this.getBarShape((Gauge)gauge).j - gauge.getBorderWidth()) * 0.38f) + gauge.getFontSizeAdjustment();
            n2 = n2 < 1 ? 1 : n2;
            int n3 = gauge.isItalicFont() ? 2 : 0;
            Font font = cq.a().a(gauge.getFontFamily(), n3, n2);
            graphics2D.setFont(font);
            graphics2D.setColor(gauge.getFontColor());
            Color color = gauge.getTrimColor().darker();
            float[] fArray = new float[4];
            float[] fArray2 = new float[4];
            for (c c2 : list) {
                float f3 = (float)this.getBarShape(gauge).b(c2.a()) + (float)(gauge.getBorderWidth() / 2);
                float f4 = this.getBarShape(gauge).d(this.getBarShape((Gauge)gauge).c, f3) - (float)(gauge.getBorderWidth() / 2);
                fArray[0] = f3;
                fArray2[0] = f4 - f2;
                fArray[1] = f3 - f2 / 3.0f;
                fArray2[1] = f4;
                fArray[2] = f3 + f2 / 3.0f;
                fArray2[2] = f4;
                fArray[3] = f3;
                fArray2[3] = f4 - f2;
                dL dL2 = new dL(fArray, fArray2, fArray.length);
                graphics2D.setColor(color);
                graphics2D.setStroke(this.tickStroke);
                graphics2D.draw(dL2);
                graphics2D.fill(dL2);
                String string = X.a(c2.b(), gauge.getLabelDigits());
                int n4 = graphics2D.getFontMetrics(font).stringWidth(string);
                float f5 = f3 - (float)n4 / 2.0f;
                float f6 = f4 - (float)((this.getBarShape((Gauge)gauge).j - n2) / 2);
                TextLayout textLayout = new TextLayout(string, font, graphics2D.getFontRenderContext());
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(f5, f6);
                Shape shape = textLayout.getOutline(affineTransform);
                graphics2D.setColor(gauge.getFontColor());
                graphics2D.drawString(string, f5, f6);
                graphics2D.setColor(gauge.getTrimColor());
                graphics2D.setStroke(new BasicStroke((float)n2 / 30.0f));
                graphics2D.draw(shape);
            }
        }
    }

    private void paintNeedle(Graphics2D graphics2D, Gauge gauge, boolean bl2) {
        double d2 = bl2 ? gauge.min() : gauge.getSmoothedValue();
        double d3 = (d2 - gauge.min()) / (gauge.max() - gauge.min());
        this.lastValue = d2;
        float[] fArray = new float[]{0.0f, 0.8f};
        Color[] colorArray = new Color[]{gauge.getNeedleColor().darker(), this.getBrighter(gauge.getNeedleColor())};
        float f2 = eJ.a(450);
        int n2 = (float)gauge.getWidth() > f2 ? 20 + Math.round(((float)gauge.getWidth() - f2) / 22.4f) : 20;
        float f3 = 0.065f;
        float f4 = ((float)gauge.getWidth() - 2.5f * (float)gauge.getBorderWidth()) / (float)n2;
        float[] fArray2 = new float[5];
        float[] fArray3 = new float[5];
        boolean bl3 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f5;
            float f6 = (float)i2 / (float)n2;
            float f7 = ((float)i2 + 1.0f) / (float)n2;
            float f8 = gauge.isCounterClockwise() ? (float)(gauge.getWidth() - gauge.getBorderWidth()) - (float)i2 * f4 - f4 * f3 : (float)gauge.getBorderWidth() + (float)i2 * f4 + f4 * f3;
            float f9 = gauge.isCounterClockwise() ? (float)(gauge.getWidth() - gauge.getBorderWidth()) - (float)(i2 + 1) * f4 + f4 * f3 : (float)gauge.getBorderWidth() + (float)(i2 + 1) * f4 - f4 * f3;
            float f10 = this.getBarShape(gauge).d(this.barShape.b, f8);
            float f11 = this.getBarShape(gauge).d(this.barShape.b, f9);
            float f12 = this.getBarShape(gauge).d(this.barShape.c, f8);
            float f13 = this.getBarShape(gauge).d(this.barShape.c, f9);
            fArray2[0] = f8;
            fArray3[0] = f10;
            fArray2[1] = f9;
            fArray3[1] = f11;
            fArray2[2] = f9;
            fArray3[2] = f13;
            fArray2[3] = f8;
            fArray3[3] = f12;
            fArray2[4] = f8;
            fArray3[4] = f10;
            dL dL2 = new dL(fArray2, fArray3, fArray2.length);
            if ((double)f7 < d3) {
                if (bl3) {
                    Point2D.Float float_ = new Point2D.Float((f9 + f8) / 2.0f, 2.0f * (f12 + f10) / 3.0f);
                    RadialGradientPaint radialGradientPaint = new RadialGradientPaint(float_, f9 - f8, float_, fArray, colorArray, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                    graphics2D.setPaint(radialGradientPaint);
                } else {
                    graphics2D.setColor(this.getNeedleColor(gauge, f7));
                }
                graphics2D.fill(dL2);
                continue;
            }
            if (bl2) {
                graphics2D.setColor(this.getDarker(this.getDarker(this.getDarker(this.getDarker(this.getNeedleColor(gauge, f7))))));
                graphics2D.fill(dL2);
            }
            if (d3 > (double)(f5 = (f8 - (float)gauge.getBorderWidth()) / ((float)gauge.getWidth() - 2.0f * (float)gauge.getBorderWidth()))) {
                float f14 = (float)gauge.getBorderWidth() + (float)d3 * ((float)gauge.getWidth() - 2.0f * (float)gauge.getBorderWidth());
                fArray2[1] = f9 = f14 < f9 ? f14 : f9;
                fArray3[1] = this.getBarShape(gauge).d(this.barShape.b, f9);
                fArray2[2] = f9;
                fArray3[2] = this.getBarShape(gauge).d(this.barShape.c, f9);
                graphics2D.setColor(this.getNeedleColor(gauge, f7));
                dL2 = new dL(fArray2, fArray3, fArray2.length);
                graphics2D.fill(dL2);
            }
            if (!bl2) break;
        }
    }

    private Color getNeedleColor(Gauge gauge, double d2) {
        double d3 = gauge.min() + d2 * (gauge.max() - gauge.min());
        if (d3 < gauge.lowCritical() && gauge.getValue() < gauge.lowCritical() || d3 > gauge.highCritical()) {
            return gauge.getCriticalColor();
        }
        if (d3 < gauge.lowWarning() && gauge.getValue() < gauge.lowWarning() || d3 > gauge.highWarning()) {
            return gauge.getWarnColor();
        }
        return gauge.getNeedleColor();
    }

    protected Image getBottomOffImage(Gauge gauge) {
        if (this.bottomOffImage == null || this.bottomOffImage.getWidth(null) != gauge.getWidth() || this.bottomOffImage.getHeight(null) != gauge.getHeight()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.bottomOffImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 3);
            Graphics2D graphics2D = (Graphics2D)this.bottomOffImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintBackground((Graphics)graphics2D, gauge);
        }
        return this.bottomOffImage;
    }

    protected Image getTopOffImage(Gauge gauge) {
        if (this.topOffImage == null || this.topOffImage.getWidth(null) != gauge.getWidth() || this.topOffImage.getHeight(null) != gauge.getHeight()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.topOffImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 3);
            Graphics2D graphics2D = (Graphics2D)this.topOffImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.paintNumbers(graphics2D, gauge);
            this.paintBorder(graphics2D, gauge);
        }
        return this.topOffImage;
    }

    protected Image paintBackground(Graphics graphics, Gauge gauge) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = new Color(0, 0, 0, 0);
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
        if (gauge.getBackColor() != null && gauge.getBackColor().getAlpha() > 0) {
            graphics2D.setColor(gauge.getBackColor());
            graphics2D.fill(this.getBarShape(gauge));
        }
        this.paintNeedle(graphics2D, gauge, true);
        return this.bottomOffImage;
    }

    private void paintBorder(Graphics2D graphics2D, Gauge gauge) {
        Color color = gauge.getTrimColor();
        if (gauge.getBorderWidth() > 0 && color.getAlpha() > 0) {
            if (this.outerGradient == null) {
                Color color2 = this.getDarker(color);
                float f2 = (float)this.getBarShape(gauge).c(this.getBarShape((Gauge)gauge).c, 0.25);
                this.outerGradient = new GradientPaint(gauge.getWidth() / 4, 0.0f, this.getBrighter(color), gauge.getWidth() / 2, 40.0f, color2, true);
            }
            graphics2D.setPaint(this.outerGradient);
            graphics2D.setStroke(new BasicStroke(gauge.getBorderWidth(), 1, 1, 10.0f, null, 0.0f));
            graphics2D.draw(this.getBarShape(gauge));
        }
    }

    protected Color getBrighter(Color color) {
        int n2 = color.getBlue() + color.getRed() + color.getGreen();
        if (n2 < 180) {
            return new Color((n2 += 250) / 3, n2 / 3, n2 / 3);
        }
        return color.brighter();
    }

    protected Color getDarker(Color color) {
        Color color2 = (Color)this.darkColorCache.get(color);
        if (color2 == null) {
            color2 = color.getBlue() + color.getRed() + color.getGreen() > 650 ? color.darker().darker() : color.darker();
            this.darkColorCache.put(color, color2);
        }
        return color2;
    }

    private List getNumberPositions(Gauge gauge) {
        if (this.numberPositions == null) {
            float f2 = (float)this.getBarShape((Gauge)gauge).j * 0.65f;
            this.numberPositions = new ArrayList();
            int n2 = gauge.getWidth() / this.getBarShape((Gauge)gauge).j;
            float f3 = gauge.max() > 3000.0 ? 1000.0f : (gauge.max() > 500.0 ? 100.0f : 1.0f);
            int n3 = (int)(Math.round(Math.log10(gauge.max() - gauge.min())) - 1L);
            double d2 = Math.pow(10.0, n3);
            int n4 = (int)Math.round((gauge.max() - gauge.min()) / d2);
            while (n4 > 0 && (float)(gauge.getWidth() / n4) < f2) {
                n4 = (int)((gauge.max() - gauge.min()) / (d2 *= 2.0));
            }
            for (int i2 = 1; i2 < n4; ++i2) {
                float f4 = (float)(gauge.min() + (double)i2 * d2);
                float f5 = (f4 - (float)gauge.getMin()) / (float)(gauge.max() - gauge.min());
                this.numberPositions.add(new c(this, f4 / f3, f5));
            }
        }
        return this.numberPositions;
    }

    @Override
    public void invalidate() {
        this.barShape = null;
        this.outerGradient = null;
        this.bottomOffImage = null;
        this.topOffImage = null;
        this.numberPositions = null;
    }

    private b getBarShape(Gauge gauge) {
        if (this.barShape == null) {
            this.barShape = new b(this, gauge);
            this.barShape.a(gauge.getWidth(), gauge.getHeight());
        }
        return this.barShape;
    }

    @Override
    public boolean isComponentPaintedAt(int n2, int n3) {
        if (this.barShape != null) {
            return this.barShape.contains(n2, n3);
        }
        return true;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        return this.topOffImage == null || s2.getWidth() != this.topOffImage.getWidth(null) || s2.getHeight() != this.topOffImage.getHeight(null);
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (gauge.isAntialiasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.paintNeedle(graphics2D, gauge, false);
        boolean bl2 = true;
        if (bl2) {
            graphics.drawImage(this.getTopOffImage(gauge), 0, 0, null);
        } else {
            this.paintNumbers(graphics2D, gauge);
            this.paintBorder(graphics2D, gauge);
        }
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl2 = false;
        if (bl2) {
            Image image = this.getBottomOffImage(gauge);
            Graphics2D graphics2D2 = (Graphics2D)image.getGraphics();
            graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(image, 0, 0, null);
        } else {
            this.paintBackground(graphics, (Gauge)s2);
        }
        this.paintBorder(graphics2D, gauge);
    }

    @Override
    public Area areaPainted(s s2) {
        Gauge gauge = (Gauge)s2;
        Area area = new Area(this.getBarShape(gauge));
        return area;
    }
}

