/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.RasterOps;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import org.icepdf.core.util.Defs;

public class CMYKRasterOp
implements RasterOp {
    private static float blackRatio;
    private RenderingHints hints = null;

    public CMYKRasterOp(RenderingHints hints) {
        this.hints = hints;
        blackRatio = Defs.intProperty("org.icepdf.core.cmyk.image.black", 255);
    }

    public static void setBlackRatio(float blackRatio) {
        CMYKRasterOp.blackRatio = blackRatio;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        byte[] srcPixels = ((DataBufferByte)src.getDataBuffer()).getData();
        int[] destPixels = ((DataBufferInt)dest.getDataBuffer()).getData();
        float lastCyan = -1.0f;
        float lastMagenta = -1.0f;
        float lastYellow = -1.0f;
        float lastBlack = -1.0f;
        int rValue = 0;
        int gValue = 0;
        int bValue = 0;
        int alpha = 0;
        int bands = src.getNumBands();
        int pixel = 0;
        int intPixels = 0;
        while (pixel < srcPixels.length) {
            float inCyan = (float)(srcPixels[pixel] & 0xFF) / 255.0f;
            float inMagenta = (float)(srcPixels[pixel + 1] & 0xFF) / 255.0f;
            float inYellow = (float)(srcPixels[pixel + 2] & 0xFF) / 255.0f;
            float inBlack = (float)(srcPixels[pixel + 3] & 0xFF) / blackRatio;
            if (inCyan != lastCyan || inMagenta != lastMagenta || inYellow != lastYellow || inBlack != lastBlack) {
                double c = CMYKRasterOp.clip(0.0, 1.0, inCyan + inBlack);
                double m = CMYKRasterOp.clip(0.0, 1.0, inMagenta + inBlack);
                double y2 = CMYKRasterOp.clip(0.0, 1.0, inYellow + inBlack);
                double aw = (1.0 - c) * (1.0 - m) * (1.0 - y2);
                double ac = c * (1.0 - m) * (1.0 - y2);
                double am = (1.0 - c) * m * (1.0 - y2);
                double ay = (1.0 - c) * (1.0 - m) * y2;
                double ar = (1.0 - c) * m * y2;
                double ag = c * (1.0 - m) * y2;
                double ab = c * m * (1.0 - y2);
                float outRed = (float)CMYKRasterOp.clip(0.0, 1.0, aw + 0.9137 * am + 0.9961 * ay + 0.9882 * ar);
                float outGreen = (float)CMYKRasterOp.clip(0.0, 1.0, aw + 0.6196 * ac + ay + 0.5176 * ag);
                float outBlue = (float)CMYKRasterOp.clip(0.0, 1.0, aw + 0.7804 * ac + 0.5412 * am + 0.0667 * ar + 0.2118 * ag + 0.4863 * ab);
                rValue = (int)(outRed * 255.0f);
                gValue = (int)(outGreen * 255.0f);
                bValue = (int)(outBlue * 255.0f);
                alpha = 255;
            }
            lastCyan = inCyan;
            lastMagenta = inMagenta;
            lastYellow = inYellow;
            lastBlack = inBlack;
            destPixels[intPixels] = (alpha & 0xFF) << 24 | (rValue & 0xFF) << 16 | (gValue & 0xFF) << 8 | bValue & 0xFF;
            pixel += bands;
            ++intPixels;
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private static double clip(double floor, double ceiling, double value) {
        if (value < floor) {
            value = floor;
        }
        if (value > ceiling) {
            value = ceiling;
        }
        return value;
    }
}

