/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.SearchServicesRunnable;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.UtilsJavaSE;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;

class SearchServicesThread
extends Thread {
    private static int transIDGenerator = 0;
    private static Hashtable threads = new Hashtable();
    private BluetoothStack stack;
    private SearchServicesRunnable serachRunnable;
    private int transID;
    private int[] attrSet;
    private Vector servicesRecords = new Vector();
    UUID[] uuidSet;
    private RemoteDevice device;
    private DiscoveryListener listener;
    private BluetoothStateException startException;
    private boolean started = false;
    private boolean finished = false;
    private boolean terminated = false;
    private Object serviceSearchStartedEvent = new Object();

    private static synchronized int nextThreadNum() {
        return ++transIDGenerator;
    }

    private SearchServicesThread(int transID, BluetoothStack stack, SearchServicesRunnable serachRunnable, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) {
        super("SearchServicesThread-" + transID);
        this.stack = stack;
        this.serachRunnable = serachRunnable;
        this.transID = transID;
        this.attrSet = attrSet;
        this.listener = listener;
        this.uuidSet = uuidSet;
        this.device = RemoteDeviceHelper.getStackBoundDevice(stack, device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int startSearchServices(BluetoothStack stack, SearchServicesRunnable searchRunnable, int[] attrSet, UUID[] uuidSet, RemoteDevice device, DiscoveryListener listener) throws BluetoothStateException {
        SearchServicesThread t;
        Object object = threads;
        synchronized (object) {
            int runningCount = SearchServicesThread.countRunningSearchServicesThreads(stack);
            int concurrentAllow = Integer.valueOf(stack.getLocalDeviceProperty("bluetooth.sd.trans.max"));
            if (runningCount >= concurrentAllow) {
                throw new BluetoothStateException("Already running " + runningCount + " service discovery transactions");
            }
            t = new SearchServicesThread(SearchServicesThread.nextThreadNum(), stack, searchRunnable, attrSet, uuidSet, device, listener);
            threads.put(new Integer(t.getTransID()), t);
        }
        UtilsJavaSE.threadSetDaemon(t);
        object = t.serviceSearchStartedEvent;
        synchronized (object) {
            t.start();
            while (!t.started && !t.finished) {
                try {
                    t.serviceSearchStartedEvent.wait();
                }
                catch (InterruptedException e) {
                    return 0;
                }
                if (t.startException == null) continue;
                throw t.startException;
            }
        }
        if (t.started) {
            return t.getTransID();
        }
        throw new BluetoothStateException();
    }

    private static int countRunningSearchServicesThreads(BluetoothStack stack) {
        int count = 0;
        Enumeration en = threads.elements();
        while (en.hasMoreElements()) {
            SearchServicesThread t = (SearchServicesThread)en.nextElement();
            if (t.stack != stack) continue;
            ++count;
        }
        return count;
    }

    static SearchServicesThread getServiceSearchThread(int transID) {
        return (SearchServicesThread)threads.get(new Integer(transID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int respCode = 3;
        try {
            BlueCoveImpl.setThreadBluetoothStack(this.stack);
            respCode = this.serachRunnable.runSearchServices(this, this.attrSet, this.uuidSet, this.device, this.listener);
        }
        catch (BluetoothStateException e) {
            this.startException = e;
            return;
        }
        finally {
            this.finished = true;
            this.unregisterThread();
            Object object = this.serviceSearchStartedEvent;
            synchronized (object) {
                this.serviceSearchStartedEvent.notifyAll();
            }
            DebugLog.debug("runSearchServices ends", this.getTransID());
            if (this.started) {
                Utils.j2meUsagePatternDellay();
                this.listener.serviceSearchCompleted(this.getTransID(), respCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterThread() {
        Hashtable hashtable = threads;
        synchronized (hashtable) {
            threads.remove(new Integer(this.getTransID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchServicesStartedCallback() {
        DebugLog.debug("searchServicesStartedCallback", this.getTransID());
        this.started = true;
        Object object = this.serviceSearchStartedEvent;
        synchronized (object) {
            this.serviceSearchStartedEvent.notifyAll();
        }
    }

    int getTransID() {
        return this.transID;
    }

    boolean setTerminated() {
        if (this.isTerminated()) {
            return false;
        }
        this.terminated = true;
        this.unregisterThread();
        return true;
    }

    boolean isTerminated() {
        return this.terminated;
    }

    RemoteDevice getDevice() {
        return this.device;
    }

    DiscoveryListener getListener() {
        return this.listener;
    }

    void addServicesRecords(ServiceRecord servRecord) {
        this.servicesRecords.addElement(servRecord);
    }

    Vector getServicesRecords() {
        return this.servicesRecords;
    }

    public int[] getAttrSet() {
        int[] requiredAttrIDs = new int[]{0, 1, 2, 3, 4};
        if (this.attrSet == null) {
            return requiredAttrIDs;
        }
        int len = requiredAttrIDs.length + this.attrSet.length;
        block0: for (int i = 0; i < this.attrSet.length; ++i) {
            for (int k = 0; k < requiredAttrIDs.length; ++k) {
                if (requiredAttrIDs[k] != this.attrSet[i]) continue;
                --len;
                continue block0;
            }
        }
        int[] allIDs = new int[len];
        System.arraycopy(requiredAttrIDs, 0, allIDs, 0, requiredAttrIDs.length);
        int appendPosition = requiredAttrIDs.length;
        block2: for (int i = 0; i < this.attrSet.length; ++i) {
            for (int k = 0; k < requiredAttrIDs.length; ++k) {
                if (requiredAttrIDs[k] == this.attrSet[i]) continue block2;
            }
            allIDs[appendPosition] = this.attrSet[i];
            ++appendPosition;
        }
        return allIDs;
    }
}

