/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.TinyTableModel;
import de.muntjak.tinylookandfeel.table.SortableTableData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TinyTableHeaderUI
extends BasicTableHeaderUI {
    private static final String ROLLOVER_COLUMN_KEY = "rolloverColumn";
    private static final String SORTED_COLUMN_KEY = "sortedColumn";
    private static final String SORTING_DIRECTION_KEY = "sortingDirection";
    private static final int ADD_COLUMN = 0;
    private static final int REMOVE_COLUMN = 1;
    private static final int REPLACE_COLUMN = 2;
    private static final int MINIMUM_DRAG_DISTANCE = 5;
    private static final HashMap sortingCache = new HashMap();
    private static final String DEFAULT_RENDERER_KEY = "defaultRenderer";
    protected SortableTableHandler handler;
    protected TinyTableHeaderRenderer headerRenderer;
    protected boolean rendererInstalled = false;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyTableHeaderUI();
    }

    protected void installListeners() {
        SortingInformation sortingInformation;
        super.installListeners();
        this.handler = new SortableTableHandler();
        this.header.addMouseListener(this.handler);
        this.header.addMouseMotionListener(this.handler);
        this.header.getColumnModel().addColumnModelListener(this.handler);
        if (this.header.getTable() != null) {
            this.handler.getTableModel(this.header);
            this.header.getTable().addPropertyChangeListener("model", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (TinyTableHeaderUI.this.header == null) {
                        return;
                    }
                    TableModel tableModel = (TableModel)propertyChangeEvent.getNewValue();
                    if (TinyTableHeaderUI.this.rendererInstalled && (tableModel == null || !(tableModel instanceof SortableTableData))) {
                        TinyTableHeaderUI.this.rendererInstalled = false;
                        TableCellRenderer tableCellRenderer = (TableCellRenderer)TinyTableHeaderUI.this.header.getClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY);
                        TinyTableHeaderUI.this.header.setDefaultRenderer(tableCellRenderer);
                    } else if (!TinyTableHeaderUI.this.rendererInstalled && tableModel != null && tableModel instanceof SortableTableData) {
                        TinyTableHeaderUI.this.rendererInstalled = true;
                        TableCellRenderer tableCellRenderer = (TableCellRenderer)TinyTableHeaderUI.this.header.getClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY);
                        if (tableCellRenderer == null) {
                            tableCellRenderer = TinyTableHeaderUI.this.header.getDefaultRenderer();
                            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY, tableCellRenderer);
                        }
                        if (TinyTableHeaderUI.this.headerRenderer == null) {
                            TinyTableHeaderUI.this.headerRenderer = new TinyTableHeaderRenderer();
                        }
                        TinyTableHeaderUI.this.header.setDefaultRenderer(TinyTableHeaderUI.this.headerRenderer);
                    }
                }
            });
        }
        if ((sortingInformation = (SortingInformation)sortingCache.get(this.header)) != null) {
            this.handler.restoreSortingInformation(this.header, sortingInformation);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.handler.removeSortingInformation();
        this.header.removeMouseListener(this.handler);
        this.header.removeMouseMotionListener(this.handler);
        this.header.getColumnModel().removeColumnModelListener(this.handler);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        dimension.height = Math.max(16, dimension.height);
        return dimension;
    }

    public void sortColumns(int[] nArray, int[] nArray2, JTable jTable) {
        if (this.handler == null) {
            return;
        }
        this.handler.sortColumns(nArray, nArray2, jTable);
    }

    public void setHorizontalAlignments(int[] nArray) {
        if (this.headerRenderer == null || !this.rendererInstalled) {
            return;
        }
        if (this.handler != null) {
            if (nArray == null) {
                SortableTableHandler.access$902(this.handler, null);
            } else {
                SortableTableHandler.access$902(this.handler, new int[nArray.length]);
                System.arraycopy(nArray, 0, this.handler.alignments, 0, nArray.length);
            }
        }
        this.headerRenderer.setHorizontalAlignments(nArray);
    }

    static class TinyTableHeaderRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private static final Icon arrowNo = new Arrow(true, -1);
        private static final Icon[][] arrows = new Icon[2][4];
        private int[] horizontalAlignments;

        public TinyTableHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
        }

        public void setHorizontalAlignments(int[] nArray) {
            this.horizontalAlignments = nArray;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (lookAndFeel == null || !"TinyLookAndFeel".equals(lookAndFeel.getName())) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setBackground(jTableHeader.getBackground());
                    this.setForeground(jTableHeader.getForeground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setIcon(null);
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
            boolean bl3 = false;
            Icon icon = arrowNo;
            int n3 = 1;
            int n4 = -1;
            boolean bl4 = false;
            if (jTable != null) {
                int n5;
                Object object2;
                JTableHeader jTableHeader = jTable.getTableHeader();
                if (jTableHeader != null) {
                    object2 = jTableHeader.getClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY);
                    if (object2 != null && (n5 = ((Integer)object2).intValue()) == n2) {
                        bl3 = true;
                    }
                    if ((object2 = jTableHeader.getClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY)) != null) {
                        int[] nArray = (int[])object2;
                        n4 = -1;
                        for (int i = 0; i < nArray.length; ++i) {
                            if (nArray[i] != n2) continue;
                            n4 = i;
                        }
                        if (n4 > -1) {
                            bl4 = true;
                            object2 = jTableHeader.getClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY);
                            if (object2 != null) {
                                int[] nArray2 = (int[])object2;
                                n3 = nArray2[n4];
                            }
                        }
                    }
                    if (bl3) {
                        this.setBackground(Theme.tableHeaderRolloverBackColor.getColor());
                    } else {
                        this.setBackground(jTableHeader.getBackground());
                    }
                    this.setForeground(jTableHeader.getForeground());
                    this.setFont(jTableHeader.getFont());
                }
                if ((object2 = jTable.getModel()) instanceof SortableTableData) {
                    if (bl4) {
                        n5 = Math.min(3, n4);
                        if (n3 == 1) {
                            if (arrows[0][n5] == null) {
                                TinyTableHeaderRenderer.arrows[0][n5] = new Arrow(false, n4);
                            }
                            icon = arrows[0][n5];
                        } else {
                            if (arrows[1][n5] == null) {
                                TinyTableHeaderRenderer.arrows[1][n5] = new Arrow(true, n4);
                            }
                            icon = arrows[1][n5];
                        }
                    } else if (n2 >= 0 && !((SortableTableData)object2).isColumnSortable(n5 = jTable.getColumnModel().getColumn(n2).getModelIndex())) {
                        icon = null;
                    }
                } else {
                    icon = null;
                    this.setToolTipText(null);
                }
                if (n2 >= 0) {
                    n5 = jTable.getColumnModel().getColumn(n2).getModelIndex();
                    if (this.horizontalAlignments != null && this.horizontalAlignments.length > n5) {
                        this.setHorizontalAlignment(this.horizontalAlignments[n5]);
                    }
                }
            }
            this.setIcon(icon);
            this.setText(object == null ? "" : object.toString());
            if (bl3) {
                this.setBorder(UIManager.getBorder("TableHeader.cellRolloverBorder"));
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            return this;
        }

        private static class Arrow
        implements Icon {
            private static final int height = 11;
            private boolean descending;
            private int priority;

            public Arrow(boolean bl, int n) {
                this.descending = bl;
                this.priority = Math.min(3, n);
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                if (this.priority == -1) {
                    return;
                }
                int n3 = this.priority;
                int n4 = (6 + this.priority) / 2;
                graphics.translate(n + n3, n2 + n4);
                graphics.setColor(Theme.tableHeaderArrowColor.getColor());
                if (this.descending) {
                    switch (this.priority) {
                        case 0: {
                            graphics.drawLine(4, 4, 4, 4);
                            graphics.drawLine(3, 3, 5, 3);
                            graphics.drawLine(2, 2, 6, 2);
                            graphics.drawLine(1, 1, 7, 1);
                            graphics.drawLine(0, 0, 8, 0);
                            break;
                        }
                        case 1: {
                            graphics.drawLine(3, 3, 3, 3);
                            graphics.drawLine(2, 2, 4, 2);
                            graphics.drawLine(1, 1, 5, 1);
                            graphics.drawLine(0, 0, 6, 0);
                            break;
                        }
                        case 2: {
                            graphics.drawLine(2, 2, 2, 2);
                            graphics.drawLine(1, 1, 3, 1);
                            graphics.drawLine(0, 0, 4, 0);
                            break;
                        }
                        default: {
                            graphics.drawLine(1, 1, 1, 1);
                            graphics.drawLine(0, 0, 2, 0);
                            break;
                        }
                    }
                } else {
                    switch (this.priority) {
                        case 0: {
                            graphics.drawLine(4, 0, 4, 0);
                            graphics.drawLine(3, 1, 5, 1);
                            graphics.drawLine(2, 2, 6, 2);
                            graphics.drawLine(1, 3, 7, 3);
                            graphics.drawLine(0, 4, 8, 4);
                            break;
                        }
                        case 1: {
                            graphics.drawLine(3, 0, 3, 0);
                            graphics.drawLine(2, 1, 4, 1);
                            graphics.drawLine(1, 2, 5, 2);
                            graphics.drawLine(0, 3, 6, 3);
                            break;
                        }
                        case 2: {
                            graphics.drawLine(2, 0, 2, 0);
                            graphics.drawLine(1, 1, 3, 1);
                            graphics.drawLine(0, 2, 4, 2);
                            break;
                        }
                        default: {
                            graphics.drawLine(1, 0, 1, 0);
                            graphics.drawLine(0, 1, 2, 1);
                        }
                    }
                }
                graphics.translate(-(n + n3), -(n2 + n4));
            }

            public int getIconWidth() {
                return 9;
            }

            public int getIconHeight() {
                return 11;
            }
        }
    }

    private class SortableTableHandler
    implements MouseListener,
    MouseMotionListener,
    TableColumnModelListener {
        private int[] alignments;
        private int rolloverColumn = -1;
        private int pressedColumn = -1;
        private Vector sortedViewColumns = new Vector();
        private Vector sortedModelColumns = new Vector();
        private Vector sortingDirections = new Vector();
        private boolean mouseInside = false;
        private boolean mouseDragged = false;
        private boolean inDrag = false;
        private Point pressedPoint;

        private SortableTableHandler() {
        }

        void sortColumns(int[] nArray, int[] nArray2, JTable jTable) {
            if (nArray == null) {
                throw new IllegalArgumentException("columns argument may not be null");
            }
            if (nArray2 == null) {
                throw new IllegalArgumentException("directions argument may not be null");
            }
            if (jTable == null) {
                throw new IllegalArgumentException("table argument may not be null");
            }
            if (nArray.length != nArray2.length) {
                throw new IllegalArgumentException("columns argument and directions argument must be of equal length");
            }
            JTableHeader jTableHeader = jTable.getTableHeader();
            SortableTableData sortableTableData = this.getTableModel(jTableHeader);
            if (sortableTableData == null) {
                return;
            }
            this.sortedViewColumns.clear();
            this.sortedModelColumns.clear();
            this.sortingDirections.clear();
            for (int i = 0; i < nArray.length; ++i) {
                this.sortedViewColumns.add(new Integer(nArray[i]));
                this.sortedModelColumns.add(new Integer(this.getModelColumn(jTableHeader, nArray[i])));
                this.sortingDirections.add(new Integer(nArray2[i]));
            }
            jTableHeader.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            jTableHeader.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, this.vectorToIntArray(this.sortingDirections));
            sortableTableData.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), jTable);
            jTableHeader.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseInside = true;
            if (this.mouseDragged) {
                return;
            }
            SortableTableData sortableTableData = this.getTableModel(mouseEvent.getSource());
            if (sortableTableData == null) {
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.getModelColumnAt(mouseEvent);
            if (!sortableTableData.isColumnSortable(n2)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                }
            } else {
                this.rolloverColumn = n;
                jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            jTableHeader.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseInside = false;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            if (this.inDrag && jTableHeader.getReorderingAllowed()) {
                return;
            }
            SortableTableData sortableTableData = this.getTableModel(mouseEvent.getSource());
            if (sortableTableData == null) {
                return;
            }
            if (this.rolloverColumn != -1) {
                this.rolloverColumn = -1;
                jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                jTableHeader.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.inDrag = false;
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            if (!this.mouseInside) {
                this.mouseDragged = false;
                return;
            }
            SortableTableData sortableTableData = this.getTableModel(mouseEvent.getSource());
            if (sortableTableData == null) {
                this.mouseDragged = false;
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                this.mouseDragged = false;
                return;
            }
            int n2 = this.getModelColumnAt(mouseEvent);
            if (!sortableTableData.isColumnSortable(n2)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                }
            } else {
                this.rolloverColumn = n;
                jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            if (this.mouseDragged) {
                this.mouseDragged = false;
                return;
            }
            if (!sortableTableData.isColumnSortable(n2)) {
                return;
            }
            if (this.pressedColumn != n) {
                return;
            }
            Integer n3 = new Integer(n);
            if (this.sortedViewColumns.contains(n3)) {
                int n4 = this.sortedViewColumns.indexOf(n3);
                if (mouseEvent.isAltDown()) {
                    this.sortedViewColumns.remove(n4);
                    this.sortedModelColumns.remove(n4);
                    this.sortingDirections.remove(n4);
                } else if (mouseEvent.isControlDown() && sortableTableData.supportsMultiColumnSort() || this.sortedModelColumns.size() == 1) {
                    int n5 = (Integer)this.sortingDirections.get(n4);
                    n5 = n5 != 2 ? 2 : 1;
                    this.sortingDirections.remove(n4);
                    this.sortingDirections.add(n4, new Integer(n5));
                } else {
                    int n6 = (Integer)this.sortingDirections.get(n4);
                    n6 = n6 != 2 ? 2 : 1;
                    this.sortedViewColumns.clear();
                    this.sortedModelColumns.clear();
                    this.sortingDirections.clear();
                    this.sortedViewColumns.add(n3);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(mouseEvent, n)));
                    this.sortingDirections.add(new Integer(n6));
                }
            } else {
                if (mouseEvent.isAltDown()) {
                    return;
                }
                if (mouseEvent.isControlDown() && sortableTableData.supportsMultiColumnSort()) {
                    this.sortedViewColumns.add(n3);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(mouseEvent, n)));
                    this.sortingDirections.add(new Integer(1));
                } else {
                    this.sortedViewColumns.clear();
                    this.sortedModelColumns.clear();
                    this.sortingDirections.clear();
                    this.sortedViewColumns.add(n3);
                    this.sortedModelColumns.add(new Integer(this.getModelColumn(mouseEvent, n)));
                    this.sortingDirections.add(new Integer(1));
                }
            }
            jTableHeader.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            jTableHeader.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, this.vectorToIntArray(this.sortingDirections));
            sortableTableData.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), jTableHeader.getTable());
            jTableHeader.repaint();
        }

        private int[] vectorToIntArray(Vector vector) {
            int[] nArray = new int[vector.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)vector.get(i);
            }
            return nArray;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            this.pressedPoint = mouseEvent.getPoint();
            this.pressedColumn = jTableHeader.columnAtPoint(this.pressedPoint);
            this.mouseDragged = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            SortableTableData sortableTableData = this.getTableModel(mouseEvent.getSource());
            if (sortableTableData == null) {
                return;
            }
            this.inDrag = true;
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            if (jTableHeader.getResizingColumn() != null && !this.mouseDragged) {
                this.mouseDragged = true;
            }
            if (!jTableHeader.getReorderingAllowed() && !sortableTableData.isColumnSortable(n = this.getModelColumnAt(mouseEvent))) {
                jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                jTableHeader.repaint();
                return;
            }
            if (!this.mouseDragged && this.isMouseDragged(mouseEvent.getPoint(), this.pressedPoint)) {
                this.mouseDragged = true;
            }
            if (!this.mouseInside) {
                jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
            } else {
                if (!jTableHeader.getReorderingAllowed() && (n = jTableHeader.columnAtPoint(mouseEvent.getPoint())) != this.rolloverColumn) {
                    this.rolloverColumn = n;
                }
                if (this.rolloverColumn != -1) {
                    jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                }
            }
            jTableHeader.repaint();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.mouseInside) {
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            SortableTableData sortableTableData = this.getTableModel(mouseEvent.getSource());
            if (sortableTableData == null) {
                return;
            }
            int n2 = this.getModelColumnAt(mouseEvent);
            if (!sortableTableData.isColumnSortable(n2)) {
                if (this.rolloverColumn != -1) {
                    this.rolloverColumn = -1;
                    jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, null);
                    jTableHeader.repaint();
                }
                return;
            }
            if (n != this.rolloverColumn) {
                this.rolloverColumn = n;
                jTableHeader.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                jTableHeader.repaint();
            }
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.removeSorting();
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            int n;
            if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
                return;
            }
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            if (this.rolloverColumn == tableColumnModelEvent.getFromIndex()) {
                this.rolloverColumn = tableColumnModelEvent.getToIndex();
                if (this.mouseInside) {
                    TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
                }
            }
            int[] nArray = this.vectorToIntArray(this.sortedViewColumns);
            boolean bl = false;
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == tableColumnModelEvent.getFromIndex()) {
                    nArray[n] = tableColumnModelEvent.getToIndex();
                    bl = true;
                    continue;
                }
                if (nArray[n] != tableColumnModelEvent.getToIndex()) continue;
                nArray[n] = tableColumnModelEvent.getFromIndex();
                bl = true;
            }
            if (bl) {
                this.sortedViewColumns.clear();
                for (n = 0; n < nArray.length; ++n) {
                    this.sortedViewColumns.add(new Integer(nArray[n]));
                }
                TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, this.vectorToIntArray(this.sortedViewColumns));
            }
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.removeSorting();
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        private void removeSorting() {
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            if (this.rolloverColumn != -1) {
                this.rolloverColumn = -1;
                TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.ROLLOVER_COLUMN_KEY, new Integer(this.rolloverColumn));
            }
            this.sortedModelColumns.clear();
            this.sortedViewColumns.clear();
            this.sortingDirections.clear();
            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTING_DIRECTION_KEY, null);
            TinyTableHeaderUI.this.header.putClientProperty(TinyTableHeaderUI.SORTED_COLUMN_KEY, null);
            TinyTableHeaderUI.this.header.repaint();
        }

        void removeSortingInformation() {
            if (TinyTableHeaderUI.this.header == null) {
                return;
            }
            SortableTableData sortableTableData = this.getTableModel(TinyTableHeaderUI.this.header);
            if (sortableTableData == null) {
                return;
            }
            sortingCache.put(TinyTableHeaderUI.this.header, new SortingInformation(this.sortedViewColumns, this.sortedModelColumns, this.sortingDirections, this.alignments));
            sortableTableData.sortColumns(new int[0], new int[0], TinyTableHeaderUI.this.header.getTable());
            TinyTableHeaderUI.this.header.repaint();
        }

        void restoreSortingInformation(JTableHeader jTableHeader, SortingInformation sortingInformation) {
            if (jTableHeader == null) {
                return;
            }
            SortableTableData sortableTableData = this.getTableModel(jTableHeader);
            if (sortableTableData == null) {
                return;
            }
            this.sortedViewColumns = sortingInformation.sortedViewColumns;
            this.sortedModelColumns = sortingInformation.sortedModelColumns;
            this.sortingDirections = sortingInformation.sortingDirections;
            this.alignments = sortingInformation.alignments;
            if (this.alignments != null && this.alignments.length > 0) {
                TinyTableHeaderUI.this.setHorizontalAlignments(this.alignments);
            }
            sortableTableData.sortColumns(this.vectorToIntArray(this.sortedModelColumns), this.vectorToIntArray(this.sortingDirections), jTableHeader.getTable());
            jTableHeader.repaint();
        }

        private SortableTableData getTableModel(Object object) {
            return this.getTableModel((JTableHeader)object);
        }

        private SortableTableData getTableModel(JTableHeader jTableHeader) {
            JTable jTable = jTableHeader.getTable();
            if (jTable == null) {
                return null;
            }
            TableModel tableModel = jTable.getModel();
            if (tableModel == null || !(tableModel instanceof SortableTableData)) {
                return null;
            }
            if (!TinyTableHeaderUI.this.rendererInstalled) {
                TinyTableHeaderUI.this.rendererInstalled = true;
                TableCellRenderer tableCellRenderer = (TableCellRenderer)jTableHeader.getClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY);
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                    jTableHeader.putClientProperty(TinyTableHeaderUI.DEFAULT_RENDERER_KEY, tableCellRenderer);
                }
                if (TinyTableHeaderUI.this.headerRenderer == null) {
                    TinyTableHeaderUI.this.headerRenderer = new TinyTableHeaderRenderer();
                }
                jTableHeader.setDefaultRenderer(TinyTableHeaderUI.this.headerRenderer);
            }
            return (SortableTableData)((Object)tableModel);
        }

        private int getModelColumnAt(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n == -1) {
                return -1;
            }
            return jTableHeader.getColumnModel().getColumn(n).getModelIndex();
        }

        private int getModelColumn(MouseEvent mouseEvent, int n) {
            if (n == -1) {
                return -1;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            return this.getModelColumn(jTableHeader, n);
        }

        private int getModelColumn(JTableHeader jTableHeader, int n) {
            return jTableHeader.getColumnModel().getColumn(n).getModelIndex();
        }

        private boolean isMouseDragged(Point point, Point point2) {
            return Math.abs(point.x - point2.x) >= 5;
        }

        private void showHeaderPopup(MouseEvent mouseEvent) {
            final SortableTableData sortableTableData = this.getTableModel(mouseEvent.getSource());
            if (sortableTableData == null) {
                return;
            }
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            final int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            JPopupMenu jPopupMenu = new JPopupMenu();
            JMenu jMenu = new JMenu("Add");
            JMenuItem jMenuItem = new JMenuItem("Double Column");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).addColumn(class$java$lang$Double == null ? (class$java$lang$Double = TinyTableHeaderUI.class$("java.lang.Double")) : class$java$lang$Double, n);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Icon Column");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).addColumn(class$javax$swing$Icon == null ? (class$javax$swing$Icon = TinyTableHeaderUI.class$("javax.swing.Icon")) : class$javax$swing$Icon, n);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Integer Column");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).addColumn(class$java$lang$Integer == null ? (class$java$lang$Integer = TinyTableHeaderUI.class$("java.lang.Integer")) : class$java$lang$Integer, n);
                }
            });
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("String Column");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).addColumn(class$java$lang$String == null ? (class$java$lang$String = TinyTableHeaderUI.class$("java.lang.String")) : class$java$lang$String, n);
                }
            });
            jMenu.add(jMenuItem);
            jPopupMenu.add(jMenu);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Remove Column");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).removeColumn(n);
                }
            });
            if (((TinyTableModel)sortableTableData).getColumnCount() < 2) {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Remove all Rows");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).removeAllRows();
                }
            });
            if (((TinyTableModel)sortableTableData).getRowCount() == 0) {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Create new Data");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((TinyTableModel)sortableTableData).createNewData();
                }
            });
            if (((TinyTableModel)sortableTableData).getRowCount() > 0) {
                jMenuItem.setEnabled(false);
            }
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(jTableHeader, mouseEvent.getX(), 0);
        }

        static /* synthetic */ int[] access$902(SortableTableHandler sortableTableHandler, int[] nArray) {
            sortableTableHandler.alignments = nArray;
            return nArray;
        }
    }

    private class SortingInformation {
        private Vector sortedViewColumns;
        private Vector sortedModelColumns;
        private Vector sortingDirections;
        private int[] alignments;

        SortingInformation(Vector vector, Vector vector2, Vector vector3, int[] nArray) {
            this.sortedViewColumns = vector;
            this.sortedModelColumns = vector2;
            this.sortingDirections = vector3;
            this.alignments = nArray;
        }
    }
}

