/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

class TinySplitPaneDivider
extends BasicSplitPaneDivider {
    private int inset = 2;
    private Color controlColor = MetalLookAndFeel.getControl();

    public TinySplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setLayout(new MetalDividerLayout());
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.controlColor);
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getInsets();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Dimension dimension = this.getSize();
        dimension.width -= this.inset * 2;
        dimension.height -= this.inset * 2;
        int n = this.inset;
        int n2 = this.inset;
        if (insets != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            n += insets.left;
            n2 += insets.top;
        }
        super.paint(graphics);
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                JSplitPane jSplitPane = TinySplitPaneDivider.this.getSplitPaneFromSuper();
                if (jSplitPane != null) {
                    int n = TinySplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int n2 = TinySplitPaneDivider.this.getOrientationFromSuper();
                    graphics.setColor(Theme.backColor.getColor());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics.setColor(Theme.splitPaneButtonColor.getColor());
                    if (n2 == 0) {
                        graphics.drawLine(2, 1, 3, 1);
                        graphics.drawLine(1, 2, 4, 2);
                        graphics.drawLine(0, 3, 5, 3);
                    } else {
                        graphics.drawLine(1, 2, 1, 3);
                        graphics.drawLine(2, 1, 2, 4);
                        graphics.drawLine(3, 0, 3, 5);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                JSplitPane jSplitPane = TinySplitPaneDivider.this.getSplitPaneFromSuper();
                if (jSplitPane != null) {
                    int n = TinySplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int n2 = TinySplitPaneDivider.this.getOrientationFromSuper();
                    graphics.setColor(Theme.backColor.getColor());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics.setColor(Theme.splitPaneButtonColor.getColor());
                    if (n2 == 0) {
                        graphics.drawLine(2, 3, 3, 3);
                        graphics.drawLine(1, 2, 4, 2);
                        graphics.drawLine(0, 1, 5, 1);
                    } else {
                        graphics.drawLine(3, 2, 3, 3);
                        graphics.drawLine(2, 1, 2, 4);
                        graphics.drawLine(1, 0, 1, 5);
                    }
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    public class MetalDividerLayout
    implements LayoutManager {
        public void layoutContainer(Container container) {
            JButton jButton = TinySplitPaneDivider.this.getLeftButtonFromSuper();
            JButton jButton2 = TinySplitPaneDivider.this.getRightButtonFromSuper();
            JSplitPane jSplitPane = TinySplitPaneDivider.this.getSplitPaneFromSuper();
            int n = TinySplitPaneDivider.this.getOrientationFromSuper();
            int n2 = TinySplitPaneDivider.this.getOneTouchSizeFromSuper();
            int n3 = TinySplitPaneDivider.this.getOneTouchOffsetFromSuper();
            Insets insets = TinySplitPaneDivider.this.getInsets();
            if (jButton != null && jButton2 != null && container == TinySplitPaneDivider.this) {
                if (jSplitPane.isOneTouchExpandable()) {
                    if (n == 0) {
                        int n4 = insets != null ? insets.top : 0;
                        int n5 = TinySplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            n5 -= insets.top + insets.bottom;
                        }
                        n5 = Math.min(n5, n2);
                        jButton.setBounds(n3, n4, n5 * 2, n5);
                        jButton2.setBounds(n3 + n2 * 2, n4, n5 * 2, n5);
                    } else {
                        int n6;
                        int n7 = TinySplitPaneDivider.this.getDividerSize();
                        int n8 = n6 = insets != null ? insets.left : 0;
                        if (insets != null) {
                            n7 -= insets.left + insets.right;
                        }
                        n7 = Math.min(n7, n2);
                        jButton.setBounds(n6, n3, n7, n7 * 2);
                        jButton2.setBounds(n6, n3 + n2 * 2, n7, n7 * 2);
                    }
                } else {
                    jButton.setBounds(-5, -5, 1, 1);
                    jButton2.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }
}

