/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyRadioButtonIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalRadioButtonUI;

public class TinyRadioButtonUI
extends MetalRadioButtonUI {
    private static final TinyRadioButtonUI radioButtonUI = new TinyRadioButtonUI();
    private static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    private static TinyRadioButtonIcon radioButton;

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)jComponent;
            jRadioButton.setRolloverEnabled(true);
        }
        return radioButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.icon = this.getRadioButton();
        if (!Theme.buttonEnter.getValue()) {
            return;
        }
        if (!jComponent.isFocusable()) {
            return;
        }
        InputMap inputMap = (InputMap)UIManager.get(this.getPropertyPrefix() + "focusInputMap");
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        }
    }

    protected TinyRadioButtonIcon getRadioButton() {
        if (radioButton == null) {
            radioButton = new TinyRadioButtonIcon();
        }
        return radioButton;
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        if (!Theme.buttonFocus.getValue()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(focusStroke);
        int n = rectangle.x - 1;
        int n2 = rectangle.y - 1;
        int n3 = n + rectangle.width + 1;
        int n4 = n2 + rectangle.height + 1;
        graphics2D.drawLine(n, n2, n3, n2);
        graphics2D.drawLine(n, n2, n, n4);
        graphics2D.drawLine(n, n4, n3, n4);
        graphics2D.drawLine(n3, n2, n3, n4);
    }
}

