/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyCheckBoxIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;

public class TinyCheckBoxUI
extends MetalCheckBoxUI {
    private static final TinyCheckBoxUI SHARED_INSTANCE = new TinyCheckBoxUI();
    private static final TinyCheckBoxIcon checkIcon = new TinyCheckBoxIcon();
    private static final BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 1.0f);

    public static ComponentUI createUI(JComponent jComponent) {
        return SHARED_INSTANCE;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.icon = checkIcon;
        abstractButton.setRolloverEnabled(true);
        if (!Theme.buttonEnter.getValue()) {
            return;
        }
        if (!abstractButton.isFocusable()) {
            return;
        }
        InputMap inputMap = (InputMap)UIManager.get(this.getPropertyPrefix() + "focusInputMap");
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), "released");
        }
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        if (!Theme.buttonFocus.getValue()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(focusStroke);
        int n = rectangle.x - 1;
        int n2 = rectangle.y - 1;
        int n3 = n + rectangle.width + 1;
        int n4 = n2 + rectangle.height + 1;
        graphics2D.drawLine(n, n2, n3, n2);
        graphics2D.drawLine(n, n2, n, n4);
        graphics2D.drawLine(n, n4, n3, n4);
        graphics2D.drawLine(n3, n2, n3, n4);
    }
}

