/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.aH;
import com.efiAnalytics.apps.ts.dashboard.renderers.GaugePainter;
import com.efiAnalytics.apps.ts.dashboard.renderers.g;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.cm;
import com.efiAnalytics.ui.eG;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class HistogramPainter
implements GaugePainter {
    private transient Image backImage = null;
    aH historicalData = null;
    int scaleMultiplier = 2;
    g lineStroke = new g(2.0f);
    g gridLineStroke = new g(1.0f);
    g dashedLineStroke = new g(1.0f, 0, 2, 0.0f, new float[]{6.0f, 4.0f}, 0.0f);

    @Override
    public String getName() {
        return "Line Graph";
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        graphics.drawImage(this.getOffImage(graphics, gauge), 0, 0, null);
        this.drawHistogramLine(graphics, gauge);
    }

    @Override
    public void invalidate() {
        this.backImage = null;
    }

    @Override
    public void initialize(Gauge gauge) {
        this.historicalData = gauge.setCaptureHistoricalData(true);
    }

    private Image getOffImage(Graphics graphics, Gauge gauge) {
        if (this.backImage == null) {
            this.backImage = this.paintBackground(graphics, gauge);
            this.historicalData.b(2 + gauge.getWidth() / this.scaleMultiplier);
        }
        return this.backImage;
    }

    private Image paintBackground(Graphics graphics, Gauge gauge) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = null;
        Graphics graphics2 = null;
        if (gauge.getWidth() <= 0 || gauge.getHeight() <= 0) {
            return null;
        }
        if (gauge.isAntialiasingOn()) {
            bufferedImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 3);
            graphics2 = ((Image)bufferedImage).getGraphics();
            Graphics2D graphics2D = (Graphics2D)graphics2;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            bufferedImage = graphicsConfiguration.createCompatibleImage(gauge.getWidth(), gauge.getHeight(), 2);
            graphics2 = ((Image)bufferedImage).getGraphics();
        }
        graphics2.setColor(gauge.getBackColor());
        graphics2.fillRect(0, 0, gauge.getWidth(), gauge.getHeight());
        if (gauge.backgroundImage() != null) {
            graphics2.drawImage(gauge.backgroundImage(), 0, 0, gauge.getWidth(), gauge.getHeight(), null);
        }
        this.drawBorder(graphics2, gauge);
        this.drawGridLines(graphics2, gauge);
        this.drawTitle(graphics2, gauge);
        return bufferedImage;
    }

    private void drawTitle(Graphics graphics, Gauge gauge) {
        Font font = this.getLineFont(gauge);
        graphics.setFont(font);
        String string = gauge.title();
        if (!gauge.units().equals("")) {
            string = string + "(" + gauge.units() + ")";
        }
        if (string.length() > 0) {
            int n2 = (gauge.getWidth() - gauge.getFontMetrics(font).stringWidth(string)) / 2;
            graphics.drawString(string, n2, font.getSize());
        }
    }

    private void drawHistogramLine(Graphics graphics, Gauge gauge) {
        double[] dArray = this.getLineValues(gauge);
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray.length];
        int n2 = gauge.getWidth();
        int n3 = gauge.getHeight() - 2 * gauge.getBorderWidth();
        if (gauge.isAntialiasingOn()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            nArray[i2] = n2 - gauge.getBorderWidth() - i2 * this.scaleMultiplier;
            double d2 = (dArray[i2] - gauge.min()) / (gauge.max() - gauge.min());
            nArray2[i2] = d2 > 1.0 ? gauge.getBorderWidth() : (d2 < 0.0 ? gauge.getHeight() - gauge.getBorderWidth() : gauge.getHeight() - (int)((double)n3 * d2) - gauge.getBorderWidth());
        }
        graphics.setColor(gauge.getNeedleColor());
        ((Graphics2D)graphics).setStroke(this.lineStroke);
        graphics.drawPolyline(nArray, nArray2, nArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getLineValues(Gauge gauge) {
        int n2 = 1 + (gauge.getWidth() - 2 * gauge.getBorderWidth()) / this.scaleMultiplier;
        double[] dArray = null;
        int n3 = 0;
        aH aH2 = this.historicalData;
        synchronized (aH2) {
            n3 = this.historicalData.size() > n2 && n2 > 0 ? n2 : this.historicalData.size();
            dArray = new double[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray[i2] = this.historicalData.a(i2);
            }
        }
        if (dArray.length == 0) {
            dArray = new double[]{0.0};
        }
        return dArray;
    }

    private void drawBorder(Graphics graphics, Gauge gauge) {
        int n2 = gauge.getWidth();
        int n3 = gauge.getHeight();
        graphics.setColor(gauge.getTrimColor());
        for (int i2 = 0; i2 < gauge.getBorderWidth(); ++i2) {
            graphics.draw3DRect(i2, i2, n2 - 2 * i2 - 1, n3 - 2 * i2 - 1, i2 < gauge.getBorderWidth() / 2);
        }
    }

    private void drawGridLines(Graphics graphics, Gauge gauge) {
        int n2 = 40;
        double d2 = 1.0;
        boolean bl2 = false;
        if (gauge.getHeight() < 150) {
            n2 = 20;
            bl2 = true;
        }
        int n3 = 2;
        while (gauge.getHeight() / n3 > n2) {
            d2 = (double)gauge.getHeight() / (double)n3 / (double)gauge.getHeight();
            n3 *= 2;
        }
        boolean bl3 = true;
        for (double d3 = d2; d3 <= 1.0; d3 += d2) {
            bl3 = bl2 ? !bl3 : true;
            this.drawAGridLine(graphics, gauge, d3, bl3);
        }
        Font font = this.getLineFont(gauge);
        String string = gauge.formatDouble(gauge.max(), gauge.getLabelDigits());
        graphics.drawString(string, 3 + gauge.getBorderWidth(), font.getSize() + gauge.getBorderWidth());
    }

    private void drawAGridLine(Graphics graphics, Gauge gauge, double d2, boolean bl2) {
        int n2 = gauge.getBorderWidth();
        int n3 = gauge.getWidth() - 2 * n2;
        int n4 = (int)Math.round((double)(gauge.getHeight() - gauge.getBorderWidth() * 2) * d2) + gauge.getBorderWidth();
        graphics.setColor(Color.LIGHT_GRAY);
        ((Graphics2D)graphics).setStroke(bl2 ? this.gridLineStroke : this.dashedLineStroke);
        graphics.drawLine(n2, n4, n3 + n2, n4);
        graphics.setColor(gauge.getFontColor());
        if (bl2) {
            String string = gauge.formatDouble(gauge.max() - d2 * (gauge.max() - gauge.min()), gauge.getLabelDigits());
            Font font = this.getLineFont(gauge);
            graphics.setFont(font);
            graphics.drawString(string, 3 + gauge.getBorderWidth(), n4 - 2);
        }
    }

    private Font getLineFont(Gauge gauge) {
        int n2 = gauge.getHeight() < eG.a(168) ? eG.a(12) : gauge.getHeight() / 14;
        int n3 = gauge.isItalicFont() ? 3 : 1;
        return cm.a().a(gauge.getFontFamily(), n3, n2 += gauge.getFontSizeAdjustment());
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        return this.backImage == null || s2.getWidth() != this.backImage.getWidth(null) || s2.getHeight() != this.backImage.getHeight(null);
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
        this.drawHistogramLine(graphics, (Gauge)s2);
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        graphics.drawImage(this.getOffImage(graphics, (Gauge)s2), 0, 0, null);
    }

    @Override
    public Area areaPainted(s s2) {
        Area area;
        Gauge gauge = (Gauge)s2;
        if (gauge.getBackColor().getAlpha() > 40) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, gauge.getWidth(), gauge.getHeight());
            area = new Area(double_);
        } else {
            area = new Area();
        }
        return area;
    }
}

