/*
 * Decompiled with CFR 0.152.
 */
package org.bluez.dbus;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import org.bluez.Error;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBusProperties {
    public static String getStringValue(PropertiesAccess dBusInterface, PropertyEnum propertyEnum) {
        return DBusProperties.getStringValue(dBusInterface.GetProperties(), propertyEnum);
    }

    public static String getStringValue(Map<String, Variant<?>> properties, PropertyEnum propertyEnum) {
        if (properties == null) {
            return null;
        }
        Variant<?> value = properties.get(DBusProperties.getPropertyName(propertyEnum));
        if (value == null) {
            return null;
        }
        return (String)value.getValue();
    }

    public static boolean getBooleanValue(PropertiesAccess dBusInterface, PropertyEnum propertyEnum) {
        return DBusProperties.getBooleanValue(dBusInterface.GetProperties(), propertyEnum);
    }

    public static boolean getBooleanValue(Map<String, Variant<?>> properties, PropertyEnum propertyEnum) {
        return (Boolean)properties.get(DBusProperties.getPropertyName(propertyEnum)).getValue();
    }

    public static boolean getBooleanValue(Map<String, Variant<?>> properties, PropertyEnum propertyEnum, boolean defaultValue) {
        Variant<?> value = properties.get(DBusProperties.getPropertyName(propertyEnum));
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value.getValue();
    }

    public static Integer getIntValue(PropertiesAccess dBusInterface, PropertyEnum propertyEnum) {
        return DBusProperties.getIntValue(dBusInterface.GetProperties(), propertyEnum);
    }

    public static Integer getIntValue(Map<String, Variant<?>> properties, PropertyEnum propertyEnum) {
        if (properties == null) {
            return null;
        }
        Variant<?> value = properties.get(DBusProperties.getPropertyName(propertyEnum));
        if (value == null) {
            return null;
        }
        return ((UInt32)value.getValue()).intValue();
    }

    public static String getPropertyName(PropertyEnum propertyEnum) {
        return propertyEnum.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertiesAccess
    extends DBusInterface {
        public Map<String, Variant<?>> GetProperties() throws Error.DoesNotExist, Error.InvalidArguments;

        public void SetProperty(String var1, Variant<?> var2) throws Error.DoesNotExist, Error.InvalidArguments;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DBusProperty {
        public String name() default "";

        public Class<?> type() default void.class;

        public DBusPropertyAccessType access() default DBusPropertyAccessType.READWRITE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DBusPropertyAccessType {
        READWRITE,
        READONLY;

    }

    public static interface PropertyEnum {
    }
}

