/*
 * Decompiled with CFR 0.152.
 */
package org.bluecove.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.bluecove.socket.LocalSocket;
import org.bluecove.socket.LocalSocketAddress;
import org.bluecove.socket.LocalSocketImpl;

public class LocalServerSocket
extends ServerSocket {
    private LocalSocketImpl impl = new LocalSocketImpl();

    public LocalServerSocket() throws IOException {
        this.impl.create(true);
    }

    public LocalServerSocket(SocketAddress endpoint) throws IOException {
        this();
        this.bind(endpoint);
    }

    public LocalServerSocket(SocketAddress endpoint, int backlog) throws IOException {
        this();
        this.bind(endpoint, backlog);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.impl.bind(endpoint);
        this.impl.listen(backlog);
    }

    public Socket accept() throws IOException {
        LocalSocketImpl clientImpl = new LocalSocketImpl();
        this.impl.accept(clientImpl);
        return new LocalSocket(clientImpl);
    }

    public SocketAddress getLocalSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public void close() throws IOException {
        SocketAddress endpoint = this.getLocalSocketAddress();
        this.impl.close();
        if (endpoint != null && !((LocalSocketAddress)endpoint).isAbstractNamespace()) {
            this.impl.unlink(((LocalSocketAddress)endpoint).getName());
        }
    }

    public boolean isBound() {
        return this.impl.isBound();
    }

    public boolean isClosed() {
        return this.impl.isClosed();
    }

    public String toString() {
        if (this.isBound()) {
            return "LocalServerSocket[" + this.getLocalSocketAddress() + "]";
        }
        return "LocalServerSocket[unbound]";
    }

    public void setReceiveCredentials(boolean on) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        this.impl.setOption(2, (Object)(on ? 1 : 0));
    }

    public boolean getReceiveCredentials() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is already closed");
        }
        Object value = this.impl.getOption(2);
        if (value instanceof Integer) {
            return (Integer)value > 0;
        }
        return false;
    }
}

