/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Indicator;
import com.efiAnalytics.apps.ts.dashboard.renderers.IndicatorPainter;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.bT;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class RectangleIndicatorPainter
implements IndicatorPainter {
    static String NAME = "Basic Rectangle Indicator";
    transient Font textFont = null;
    transient Image offImage = null;
    int lastWidth = -1;
    int lastHeight = -1;
    double lastValue = Double.NaN;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Indicator indicator = (Indicator)s2;
        this.lastWidth = s2.getWidth();
        this.lastHeight = s2.getHeight();
        this.lastValue = indicator.getValue();
        if (indicator.getValue() == 0.0) {
            Color color = indicator.getOffBackgroundColor();
            this.drawBackground(graphics, indicator, color);
            if (indicator.offImage() != null) {
                Image image = indicator.offImage();
                float f2 = this.getImageScaleRatio(indicator, image);
                int n2 = (int)((float)image.getWidth(null) * f2);
                int n3 = (int)((float)image.getHeight(null) * f2);
                graphics.drawImage(image, (indicator.getWidth() - n2) / 2, (indicator.getHeight() - n3) / 2, n2, n3, null);
            }
            this.drawText(graphics, indicator.offText(), indicator, indicator.getOffTextColor());
        } else {
            Color color = indicator.getOnBackgroundColor();
            this.drawBackground(graphics, indicator, color);
            if (indicator.onImage() != null) {
                Image image = indicator.onImage();
                float f3 = this.getImageScaleRatio(indicator, image);
                int n4 = (int)((float)image.getWidth(null) * f3);
                int n5 = (int)((float)image.getHeight(null) * f3);
                graphics.drawImage(image, (indicator.getWidth() - n4) / 2, (indicator.getHeight() - n5) / 2, n4, n5, null);
            }
            this.drawText(graphics, indicator.onText(), indicator, indicator.getOnTextColor());
        }
    }

    private float getImageScaleRatio(Indicator indicator, Image image) {
        if (image != null) {
            float f2;
            float f3 = (float)indicator.getWidth() / (float)image.getWidth(null);
            return f3 < (f2 = (float)indicator.getHeight() / (float)image.getHeight(null)) ? f3 : f2;
        }
        return 1.0f;
    }

    private void drawBackground(Graphics graphics, Indicator indicator, Color color) {
        if (color != null && color.getAlpha() > 0) {
            graphics.setColor(color);
            graphics.fill3DRect(0, 0, indicator.getWidth(), indicator.getHeight(), true);
            graphics.draw3DRect(1, 1, indicator.getWidth() - 3, indicator.getHeight() - 3, true);
        }
    }

    private void drawText(Graphics graphics, String string, Indicator indicator, Color color) {
        Object object;
        if (indicator.isAntialiasingOn()) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics.setColor(color);
        object = this.getTextFont(indicator);
        graphics.setFont((Font)object);
        int n2 = (indicator.getWidth() - indicator.getFontMetrics((Font)object).stringWidth(string)) / 2;
        int n3 = (int)((double)(indicator.getHeight() / 2) + (double)((Font)object).getSize() * 0.36);
        graphics.drawString(string, n2, n3);
    }

    protected Font getTextFont(Indicator indicator) {
        if (this.textFont != null) {
            return this.textFont;
        }
        int n2 = (int)((double)(indicator.getHeight() - indicator.insets().top - indicator.insets().bottom) * 0.98);
        int n3 = indicator.getWidth() - indicator.insets().left - indicator.insets().right;
        String string = indicator.getFontFamily();
        int n4 = indicator.isItalicFont() ? 2 : 0;
        Font font = bT.a().a(string, n4, n2);
        if (font.canDisplayUpTo(indicator.onText()) >= 0 && font.canDisplayUpTo(indicator.offText()) >= 0) {
            font = bT.a().a("", n4, n2);
        }
        while (true) {
            FontMetrics fontMetrics;
            if ((fontMetrics = indicator.getFontMetrics(font)).stringWidth(indicator.onText()) < n3 && fontMetrics.stringWidth(indicator.offText()) < n3 || n2 < 1) {
                this.textFont = font;
                return this.textFont;
            }
            font = bT.a().a(string, n4, --n2);
        }
    }

    @Override
    public void invalidate() {
        this.textFont = null;
        this.offImage = null;
    }

    @Override
    public boolean isMustPaint() {
        return false;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        Indicator indicator = (Indicator)s2;
        return s2.getWidth() != this.lastWidth || s2.getHeight() != this.lastHeight || indicator.getValue() != this.lastValue || this.textFont == null;
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        this.paintGauge(graphics, s2);
    }

    @Override
    public Area areaPainted(s s2) {
        Area area;
        Color color;
        Indicator indicator = (Indicator)s2;
        Color color2 = color = indicator.getValue() == 0.0 ? indicator.getOffBackgroundColor() : indicator.getOnBackgroundColor();
        if (color != null && color.getAlpha() > 50) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, s2.getWidth(), s2.getHeight());
            area = new Area(double_);
        } else {
            area = new Area();
        }
        return area;
    }
}

