/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Indicator;
import com.efiAnalytics.apps.ts.dashboard.renderers.IndicatorPainter;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.cq;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;

public class BulbIndicatorPainter
implements IndicatorPainter {
    Font textFont = null;
    int minimumBulbSize = 14;
    int lastWidth = -1;
    int lastHeight = -1;
    double lastValue = Double.NaN;

    @Override
    public String getName() {
        return "Bulb Indicator";
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Indicator indicator = (Indicator)s2;
        this.lastWidth = s2.getWidth();
        this.lastHeight = s2.getHeight();
        this.lastValue = indicator.getValue();
        if (indicator.getValue() == 0.0) {
            Color color = indicator.getOffBackgroundColor();
            this.drawBulb(graphics, indicator, color);
            this.drawText(graphics, indicator.offText(), indicator, indicator.getOffTextColor());
        } else {
            Color color = indicator.getOnBackgroundColor();
            this.drawBulb(graphics, indicator, color);
            this.drawText(graphics, indicator.onText(), indicator, indicator.getOnTextColor());
        }
    }

    private void drawBulb(Graphics graphics, Indicator indicator, Color color) {
        if (color != null && color.getAlpha() > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n2 = indicator.getHeight() - this.getTextFont(indicator).getSize();
            int n3 = (indicator.getWidth() - n2) / 2;
            graphics.setColor(color.darker());
            graphics.fillOval(n3, 0, n2, n2);
            graphics.setColor(color.darker());
            graphics.fillOval(n3 + 1, 1, n2 - 2, n2 - 2);
            graphics.setColor(color);
            graphics.fillOval(n3 + 2, 2, n2 - 4, n2 - 4);
        }
    }

    private void drawText(Graphics graphics, String string, Indicator indicator, Color color) {
        if (color != null && string != null) {
            graphics.setColor(color);
            Font font = this.getTextFont(indicator);
            graphics.setFont(font);
            int n2 = (indicator.getWidth() - indicator.getFontMetrics(font).stringWidth(string)) / 2;
            graphics.drawString(string, n2, indicator.getHeight() - (int)((double)font.getSize() * 0.1));
        }
    }

    protected Font getTextFont(Indicator indicator) {
        if (this.textFont != null) {
            return this.textFont;
        }
        int n2 = indicator.getHeight() - indicator.getInsets().top - indicator.getInsets().bottom - this.minimumBulbSize;
        n2 = n2 > 20 ? 20 : n2;
        int n3 = indicator.getWidth() - indicator.getInsets().left - indicator.getInsets().right;
        String string = indicator.getFontFamily();
        int n4 = indicator.isItalicFont() ? 2 : 0;
        Font font = cq.a().a(string, n4, n2);
        if (font.canDisplayUpTo(indicator.onText()) >= 0 && font.canDisplayUpTo(indicator.offText()) >= 0) {
            font = cq.a().a("", n4, n2);
        }
        while (true) {
            FontMetrics fontMetrics;
            if ((fontMetrics = indicator.getFontMetrics(font)).stringWidth(indicator.onText()) < n3 && fontMetrics.stringWidth(indicator.offText()) < n3 || n2 < 1) {
                this.textFont = font;
                return this.textFont;
            }
            font = cq.a().a(string, n4, --n2);
        }
    }

    @Override
    public void invalidate() {
        this.textFont = null;
    }

    @Override
    public boolean isMustPaint() {
        return true;
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        Indicator indicator = (Indicator)s2;
        return s2.getWidth() != this.lastWidth || s2.getHeight() != this.lastHeight || indicator.getValue() != this.lastValue;
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        this.paintGauge(graphics, s2);
    }

    @Override
    public Area areaPainted(s s2) {
        Indicator indicator = (Indicator)s2;
        Area area = new Area();
        if (indicator.getOffBackgroundColor() != null && indicator.getOffBackgroundColor().getAlpha() > 0 || indicator.getOnBackgroundColor() != null && indicator.getOnBackgroundColor().getAlpha() > 0) {
            int n2 = indicator.getHeight() - this.getTextFont(indicator).getSize();
            int n3 = (indicator.getWidth() - n2) / 2;
            Arc2D.Double double_ = new Arc2D.Double(n3, 0.0, n2, n2, 0.0, 360.0, 2);
            area.add(new Area(double_));
        }
        return area;
    }
}

