/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.renderers.RoundAnalogGaugePainter;
import com.efiAnalytics.apps.ts.dashboard.renderers.g;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class AnalogMovingBarGaugePainter
extends RoundAnalogGaugePainter {
    static String NAME = "Analog Moving Bar Gauge";
    private g needleStroke = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected Image paintBackground(Graphics graphics, Gauge gauge, int n2) {
        Image image = super.paintBackground(graphics, gauge, this.currentState(gauge));
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        if (this.parentGauge() == null) {
            this.setParentGauge(gauge);
        }
        double d2 = gauge.getSweepAngle();
        int n3 = Math.round(this.getNeedleWidth(gauge));
        int n4 = gauge.getBorderWidth() + n3 / 2;
        int n5 = gauge.getBorderWidth() + n3 / 2;
        if (gauge.isAntialiasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setStroke(this.getNeedleStroke(gauge));
        graphics2D.setColor(gauge.getTrimColor());
        if (gauge.isCounterClockwise()) {
            graphics2D.drawArc(n4, n5, this.getGaugeWidth(gauge) - n3 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n3 - 2 * gauge.getBorderWidth(), 180 - gauge.getSweepBeginDegree() - gauge.getSweepAngle(), (int)Math.round(d2));
        } else {
            graphics2D.drawArc(n4, n5, this.getGaugeWidth(gauge) - n3 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n3 - 2 * gauge.getBorderWidth(), gauge.getSweepBeginDegree() + gauge.getSweepAngle(), 0 - (int)Math.round(d2));
        }
        return image;
    }

    @Override
    protected void drawWarningIndicator(Graphics graphics, Gauge gauge) {
    }

    @Override
    protected void drawWarningBars(Graphics2D graphics2D, Gauge gauge) {
    }

    protected Color getNeedleColor(Gauge gauge) {
        return this.getNeedleColor(gauge, gauge.getValue());
    }

    protected Color getNeedleColor(Gauge gauge, double d2) {
        if (d2 > gauge.lowWarning() && d2 < gauge.highWarning()) {
            return gauge.getNeedleColor();
        }
        if (d2 > gauge.highCritical()) {
            return gauge.getCriticalColor();
        }
        return gauge.getWarnColor();
    }

    @Override
    protected void drawStrings(Graphics graphics, Gauge gauge) {
    }

    @Override
    protected double getOuterEdge(Gauge gauge) {
        if (gauge.getWidth() > gauge.getHeight()) {
            return 0.95 - (double)this.getNeedleWidthPercent() - 2.0 * (double)gauge.getBorderWidth() / (double)this.getGaugeHeight(gauge);
        }
        return 0.95 - (double)this.getNeedleWidthPercent() - 2.0 * (double)gauge.getBorderWidth() / (double)this.getGaugeWidth(gauge);
    }

    @Override
    protected double getNumberOfMinorTickPerMajor(Gauge gauge) {
        return 1.0;
    }

    @Override
    protected void drawNeedle(Graphics graphics, Gauge gauge, double d2) {
        double d3 = (this.getSmoothedValue(gauge) - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = (double)gauge.getSweepAngle() * d3;
        double d5 = (gauge.getHistoricalPeakValue() - gauge.min()) / (gauge.max() - gauge.min());
        double d6 = (double)gauge.getSweepAngle() * d5;
        if (d4 < 1.0) {
            d4 = 1.0;
        }
        int n2 = Math.round(this.getNeedleWidth(gauge));
        int n3 = (gauge.getWidth() - this.getGaugeWidth(gauge)) / 2 + gauge.getBorderWidth() + n2 / 2;
        int n4 = (gauge.getHeight() - this.getGaugeHeight(gauge)) / 2 + gauge.getBorderWidth() + n2 / 2;
        ((Graphics2D)graphics).setStroke(this.getNeedleStroke(gauge));
        graphics.setColor(this.getNeedleColor(gauge));
        if (gauge.isCounterClockwise()) {
            graphics.drawArc(n3, n4, this.getGaugeWidth(gauge) - n2 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n2 - 2 * gauge.getBorderWidth(), 180 - gauge.getSweepBeginDegree() - gauge.getSweepAngle(), (int)Math.round(d4));
            if (d5 - d3 > 0.01) {
                graphics.setColor(this.getNeedleColor(gauge, gauge.getHistoricalPeakValue()));
                graphics.drawArc(n3, n4, this.getGaugeWidth(gauge) - n2 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n2 - 2 * gauge.getBorderWidth(), 180 - gauge.getSweepBeginDegree() - gauge.getSweepAngle() + (int)Math.round(d6), 1);
            }
        } else {
            graphics.drawArc(n3, n4, this.getGaugeWidth(gauge) - n2 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n2 - 2 * gauge.getBorderWidth(), gauge.getSweepBeginDegree() + gauge.getSweepAngle(), 0 - (int)Math.round(d4));
            if (d5 - d3 > 0.01) {
                graphics.setColor(this.getNeedleColor(gauge, gauge.getHistoricalPeakValue()));
                graphics.drawArc(n3, n4, this.getGaugeWidth(gauge) - n2 - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - n2 - 2 * gauge.getBorderWidth(), gauge.getSweepBeginDegree() + gauge.getSweepAngle() - (int)Math.round(d6), 1);
            }
        }
    }

    public float getNeedleWidthPercent() {
        return 0.07f;
    }

    public float getNeedleWidth(Gauge gauge) {
        return (float)this.getGaugeSize(gauge) * this.getNeedleWidthPercent();
    }

    public Stroke getNeedleStroke(Gauge gauge) {
        if (this.needleStroke == null) {
            float f2 = this.getNeedleWidth(gauge);
            this.needleStroke = new g(f2, 0, 2);
        }
        return this.needleStroke;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.needleStroke = null;
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return true;
    }
}

