/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import bH.X;
import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.aR;
import com.efiAnalytics.apps.ts.dashboard.renderers.GaugePainter;
import com.efiAnalytics.apps.ts.dashboard.renderers.g;
import com.efiAnalytics.apps.ts.dashboard.s;
import com.efiAnalytics.ui.cq;
import com.efiAnalytics.ui.eJ;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class AnalogGaugePainter
implements aR,
GaugePainter {
    private final String name = "Analog Gauge";
    transient Polygon needleShape = null;
    transient Polygon historyNeedleShape = null;
    int lastWidth = 0;
    int lastHeight = 0;
    double lastValue = 0.0;
    double lastHistoryValue = 0.0;
    int counter = 0;
    int maxMajorTicks = 12;
    int maxFaceNumber = 999;
    int digitsTrimmed = 0;
    transient Image normalOffImage = null;
    transient Image criticalOffImage = null;
    transient Image warnOffImage = null;
    transient long lastPaintTime = System.nanoTime();
    boolean lastPaintColored = false;
    private Gauge parentGauge = null;
    private transient GradientPaint outerGradient = null;
    private transient GradientPaint innerGradient = null;
    private int limitRattle = 0;
    int lastBgState = -1;
    g needleStroke = new g(eJ.a(3), 1, 1);
    g historyNeedleStroke = new g(eJ.a(1), 1, 1);

    private Image getOffImage(Graphics graphics, Gauge gauge) {
        int n2;
        this.lastBgState = n2 = this.currentState(gauge);
        if (n2 == 0) {
            if (this.normalOffImage == null) {
                this.normalOffImage = this.paintBackground(graphics, gauge, n2);
            }
            return this.normalOffImage;
        }
        if (n2 == 2) {
            if (this.criticalOffImage == null) {
                this.criticalOffImage = this.paintBackground(graphics, gauge, n2);
            }
            return this.criticalOffImage;
        }
        if (this.warnOffImage == null) {
            this.warnOffImage = this.paintBackground(graphics, gauge, n2);
        }
        return this.warnOffImage;
    }

    @Override
    public void paintGauge(Graphics graphics, s s2) {
        Object object;
        Gauge gauge = (Gauge)s2;
        if (this.parentGauge() == null) {
            this.setParentGauge(gauge);
        }
        this.lastPaintTime = System.nanoTime();
        if (gauge.isAntialiasingOn()) {
            object = (Graphics2D)graphics;
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        object = this.getOffImage(graphics, gauge);
        graphics.drawImage((Image)object, this.getXOffset(gauge), this.getYOffset(gauge), null);
        this.drawStrings(graphics, gauge);
        this.drawWarningIndicator(graphics, gauge);
        double d2 = (this.getSmoothedValue(gauge) - gauge.min()) / (gauge.max() - gauge.min());
        if (gauge.isPegLimits() && d2 > 1.02) {
            d2 = this.limitRattle++ % 2 == 0 ? 1.02 : 1.015;
        } else if (gauge.isPegLimits() && d2 < -0.02) {
            d2 = this.limitRattle++ % 2 == 0 ? -0.02 : -0.015;
        }
        double d3 = (double)(gauge.getSweepBeginDegree() + gauge.getSweepAngle()) - (double)gauge.getSweepAngle() * d2;
        graphics.setColor(gauge.getNeedleColor());
        if (gauge.max() > gauge.min()) {
            this.drawNeedle(graphics, gauge, d3);
        }
        this.lastWidth = this.getGaugeWidth(gauge);
        this.lastHeight = this.getGaugeHeight(gauge);
    }

    protected double getSmoothedValue(Gauge gauge) {
        return gauge.getSmoothedValue();
    }

    protected Color getFaceColor(Gauge gauge, int n2) {
        if (n2 == 2) {
            return gauge.getCriticalColor();
        }
        return gauge.getBackColor();
    }

    protected double getMajorTickSpacing(Gauge gauge) {
        int n2;
        int n3 = 18;
        double d2 = gauge.getMajorTicks();
        if (d2 <= 0.0) {
            n2 = (int)(Math.round(Math.log10(gauge.max() - gauge.min())) - 1L);
            d2 = Math.pow(10.0, n2);
        }
        n2 = (int)((gauge.max() - gauge.min()) / d2);
        while (n2 > 0 && gauge.getSweepAngle() / n2 < n3) {
            n2 = (int)((gauge.max() - gauge.min()) / (d2 *= 2.0));
        }
        return d2;
    }

    protected void drawStrings(Graphics graphics, Gauge gauge) {
        int n2 = (this.getGaugeHeight(gauge) - 2 * gauge.getBorderWidth()) / 12 + gauge.getFontSizeAdjustment();
        String string = gauge.getFontFamily();
        if (!gauge.isDisplayValueAt180()) {
            int n3 = gauge.isItalicFont() ? 2 : 0;
            Font font = cq.a().a(string, n3, n2);
            if (font.canDisplayUpTo(gauge.title()) >= 0) {
                n3 = gauge.isItalicFont() ? 3 : 1;
                font = cq.a().a("", n3, n2);
                string = "";
            }
            boolean bl2 = false;
            int n4 = n3 = gauge.isItalicFont() ? 2 : 0;
            while ((double)graphics.getFontMetrics(font).stringWidth(gauge.title()) > (double)this.getGaugeWidth(gauge) * 0.5) {
                n2 = (int)((double)n2 * 0.8);
                font = cq.a().a(string, n3, n2);
                bl2 = true;
            }
            Font font2 = bl2 ? font : cq.a().a(string, n3, (int)((double)n2 * 0.85));
            graphics.setFont(font2);
            graphics.setColor(gauge.getFontColor());
            String string2 = gauge.units().equals("") ? gauge.getDisplayValue() : gauge.getDisplayValue() + "(" + gauge.units() + ")";
            double d2 = Double.isNaN(gauge.getRelativeBorderWidth2()) ? 0.0 : gauge.getRelativeBorderWidth2();
            Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), gauge.getSweepBeginDegree() + gauge.getSweepAngle() / 2, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, this.getOuterEdge(gauge) - 0.6 + d2, gauge.isCounterClockwise());
            int n5 = point.x - graphics.getFontMetrics().stringWidth(string2) / 2;
            int n6 = point.y;
            graphics.drawString(string2, n5 + this.getXOffset(gauge), n6 + this.getYOffset(gauge));
            graphics.setFont(font);
            n5 = point.x - graphics.getFontMetrics().stringWidth(gauge.title()) / 2;
            graphics.drawString(gauge.title(), n5 + this.getXOffset(gauge), (n6 += (int)(1.2 * (double)font.getSize())) + this.getYOffset(gauge));
            graphics.setFont(font2);
            if (this.digitsTrimmed > 0 && gauge.max() > (double)this.maxFaceNumber) {
                String string3 = "x1";
                for (int i2 = 0; i2 < this.digitsTrimmed; ++i2) {
                    string3 = string3 + "0";
                }
                n3 = gauge.isItalicFont() ? 2 : 0;
                graphics.setFont(cq.a().a(string, n3, (int)((double)n2 * 0.6)));
                n5 = point.x - graphics.getFontMetrics().stringWidth(string3) / 2;
                n6 = point.y - (int)((double)font2.getSize() * 1.3);
                graphics.drawString(string3, n5 + this.getXOffset(gauge), n6 + this.getYOffset(gauge));
            }
        } else {
            int n7 = gauge.isItalicFont() ? 2 : 0;
            Font font = cq.a().a(string, n7, (int)((double)n2 * 0.85));
            if (font.canDisplayUpTo(gauge.title()) >= 0) {
                n7 = gauge.isItalicFont() ? 3 : 1;
                font = cq.a().a("", n7, n2);
                string = "";
            }
            boolean bl3 = false;
            String string4 = gauge.title();
            String string5 = null;
            int n8 = (gauge.getSweepBeginDegree() + gauge.getSweepAngle() / 2 + 180) % 360;
            int n9 = 13;
            if (string4.length() > n9 && string4.indexOf(" ", string4.length() / 3) != -1) {
                string5 = string4.substring(string4.indexOf(" ", string4.length() / 3) + 1);
                string4 = string4.substring(0, string4.indexOf(" ", string4.length() / 3));
            }
            while ((double)graphics.getFontMetrics(font).stringWidth(string4) > (double)this.getGaugeWidth(gauge) * 0.5) {
                n2 = (int)((double)n2 * 0.9);
                font = cq.a().a(string, n7, n2);
                bl3 = true;
            }
            Font font3 = bl3 ? font : cq.a().a(string, n7, (int)((double)n2 * 0.85));
            graphics.setFont(font3);
            graphics.setColor(gauge.getFontColor());
            int n10 = (this.getGaugeHeight(gauge) - 2 * gauge.getBorderWidth()) / 14 + gauge.getFontSizeAdjustment();
            Font font4 = cq.a().a(string, n7, n10);
            graphics.setFont(font4);
            String string6 = gauge.getDisplayValue();
            double d3 = Double.isNaN(gauge.getRelativeBorderWidth2()) ? 0.0 : gauge.getRelativeBorderWidth2();
            Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), n8, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, this.getOuterEdge(gauge) - 0.55 + d3, gauge.isCounterClockwise());
            int n11 = point.x - graphics.getFontMetrics().stringWidth(string6) / 2;
            int n12 = point.y;
            graphics.drawString(string6, n11 + this.getXOffset(gauge), n12 + this.getYOffset(gauge));
            if (gauge.units() != null && !gauge.units().equals("")) {
                n11 = point.x - graphics.getFontMetrics().stringWidth(gauge.units()) / 2;
                graphics.drawString(gauge.units(), n11 + this.getXOffset(gauge), (n12 += (int)((double)font4.getSize() * 1.1)) + this.getYOffset(gauge));
            }
            if (string5 == null) {
                Point point2 = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), gauge.getSweepBeginDegree() + gauge.getSweepAngle() / 2, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, this.getOuterEdge(gauge) - 0.66 + d3, gauge.isCounterClockwise());
                graphics.setFont(font);
                int n13 = point2.x - graphics.getFontMetrics().stringWidth(gauge.title()) / 2;
                int n14 = point2.y;
                graphics.drawString(gauge.title(), n13 + this.getXOffset(gauge), n14 + this.getYOffset(gauge));
                graphics.setFont(font3);
                if (this.digitsTrimmed > 0 && gauge.max() > (double)this.maxFaceNumber) {
                    String string7 = "x1";
                    for (int i3 = 0; i3 < this.digitsTrimmed; ++i3) {
                        string7 = string7 + "0";
                    }
                    graphics.setFont(cq.a().a(string, n7, (int)((double)n2 * 0.6)));
                    n13 = point2.x - graphics.getFontMetrics().stringWidth(string7) / 2;
                    n14 = point2.y - (int)((double)font3.getSize() * 1.3);
                    graphics.drawString(string7, n13 + this.getXOffset(gauge), n14 + this.getYOffset(gauge));
                }
            } else {
                int n15 = this.getGaugeHeight(gauge);
                Point point3 = this.getPoint(this.getGaugeWidth(gauge), n15, gauge.getSweepBeginDegree() + gauge.getSweepAngle() / 2, n15 / 2, n15 / 2, this.getOuterEdge(gauge) - 0.6 + d3, gauge.isCounterClockwise());
                graphics.setFont(font);
                int n16 = point3.x - graphics.getFontMetrics().stringWidth(string4) / 2;
                int n17 = point3.y;
                graphics.drawString(string4, n16 + this.getXOffset(gauge), n17 + this.getYOffset(gauge));
                n16 = point3.x - graphics.getFontMetrics().stringWidth(string5) / 2;
                graphics.drawString(string5, n16 + this.getXOffset(gauge), n17 + (int)((double)font.getSize() * 1.1) + this.getYOffset(gauge));
                graphics.setFont(font3);
                if (this.digitsTrimmed > 0 && gauge.max() > (double)this.maxFaceNumber) {
                    String string8 = "x1";
                    for (int i4 = 0; i4 < this.digitsTrimmed; ++i4) {
                        string8 = string8 + "0";
                    }
                    graphics.setFont(cq.a().a(string, n7, (int)((double)n2 * 0.6)));
                    n16 = point3.x - graphics.getFontMetrics().stringWidth(string8) / 2;
                    n17 = point3.y - (int)((double)font3.getSize() * 1.3);
                    graphics.drawString(string8, n16 + this.getXOffset(gauge), n17 + this.getYOffset(gauge));
                }
            }
        }
    }

    protected int getXOffset(Gauge gauge) {
        return 0;
    }

    protected int getYOffset(Gauge gauge) {
        return 0;
    }

    protected double getAngleOffsetToMajorTick(Gauge gauge) {
        double d2 = this.getMinMajorTickValue(gauge);
        double d3 = (d2 - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = -((double)gauge.getSweepAngle() * d3);
        return d4;
    }

    protected double getMinMajorTickValue(Gauge gauge) {
        if (gauge.max() > 2.0) {
            return Math.round(gauge.min());
        }
        return (double)Math.round(gauge.min() * 10.0) / 10.0;
    }

    protected void drawNumbers(Graphics graphics, Gauge gauge) {
        double d2 = this.getAngleOffsetToMajorTick(gauge);
        double d3 = this.getOuterEdge(gauge);
        double d4 = this.getMajorTickSpacing(gauge);
        double d5 = (gauge.max() - gauge.min()) / d4;
        double d6 = (double)gauge.getSweepAngle() / d5;
        if (d2 < 0.0) {
            d5 -= 1.0;
        }
        graphics.setColor(gauge.getFontColor());
        int n2 = gauge.isItalicFont() ? 2 : 0;
        graphics.setFont(cq.a().a(gauge.getFontFamily(), n2, (this.getGaugeHeight(gauge) - 2 * gauge.getBorderWidth()) / 14 + gauge.getFontSizeAdjustment()));
        this.digitsTrimmed = 10;
        int n3 = 0;
        while ((double)n3 <= d5) {
            double d7 = d2 + (double)gauge.getSweepBeginDegree() + (double)gauge.getSweepAngle() - d6 * (double)n3;
            String string = null;
            string = gauge.max() > 2.0 ? X.b(gauge.min() + (double)n3 * d4, 0) : X.b(gauge.min() + (double)n3 * d4, 1);
            if (gauge.max() > (double)this.maxFaceNumber) {
                if (n3 == 1) {
                    int n4 = string.length();
                    string = this.trimRightZeros(string, this.digitsTrimmed);
                    this.digitsTrimmed = n4 - string.length();
                } else if (n3 > 1 && this.digitsTrimmed > 0) {
                    string = this.trimRightZeros(string, this.digitsTrimmed);
                }
            }
            Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d7, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d3 - (0.14 + (double)string.length() * 0.02), gauge.isCounterClockwise());
            int n5 = point.x - graphics.getFontMetrics().stringWidth(string) / 2;
            int n6 = point.y + graphics.getFont().getSize() / 2;
            graphics.drawString(string, n5, n6);
            ++n3;
        }
    }

    protected int getGaugeWidth(Gauge gauge) {
        return gauge.getWidth();
    }

    protected int getGaugeHeight(Gauge gauge) {
        return gauge.getHeight();
    }

    private String trimRightZeros(String string, int n2) {
        for (int i2 = 0; i2 < n2 && string.endsWith("0"); ++i2) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected double getOuterEdge(Gauge gauge) {
        return 0.983 - 2.0 * (double)gauge.getBorderWidth() / (double)this.getGaugeWidth(gauge);
    }

    protected double getNumberOfMinorTickPerMajor(Gauge gauge) {
        if (gauge.getHeight() > 450 || gauge.getWidth() > 450) {
            return 5.0;
        }
        if (gauge.getHeight() > 325) {
            return 4.0;
        }
        if (gauge.getHeight() > 175 || gauge.getWidth() > 175) {
            return 2.0;
        }
        return 1.0;
    }

    protected void drawTickMarks(Graphics graphics, Gauge gauge) {
        double d2 = this.getAngleOffsetToMajorTick(gauge);
        double d3 = this.getNumberOfMinorTickPerMajor(gauge);
        double d4 = this.getOuterEdge(gauge);
        double d5 = this.getMajorTickSpacing(gauge);
        double d6 = (gauge.max() - gauge.min()) / d5;
        double d7 = (double)gauge.getSweepAngle() / d6;
        if (d2 < 0.0) {
            d6 -= 1.0;
        }
        double d8 = d6 * d3;
        double d9 = d7 / d3;
        graphics.setColor(gauge.getFontColor());
        ((Graphics2D)graphics).setStroke(new BasicStroke(2.0f));
        int n2 = 0;
        while ((double)n2 <= d8) {
            if ((double)n2 % d3 > 0.0) {
                double d10 = d2 + (double)gauge.getSweepBeginDegree() + (double)gauge.getSweepAngle() - d9 * (double)n2;
                Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d10, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d4 - 0.01, gauge.isCounterClockwise());
                Point point2 = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d10, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d4 - 0.04, gauge.isCounterClockwise());
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            ++n2;
        }
        double d11 = d4 - 0.07;
        double d12 = 0.6;
        graphics.setColor(gauge.getFontColor());
        ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f));
        int n3 = 0;
        while ((double)n3 <= d6) {
            double d13 = d2 + (double)gauge.getSweepBeginDegree() + (double)gauge.getSweepAngle() - d7 * (double)n3;
            Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d13 - d12, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d4, gauge.isCounterClockwise());
            Point point3 = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d13 - d12, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d11, gauge.isCounterClockwise());
            Point point4 = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d13 + d12, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d4, gauge.isCounterClockwise());
            Point point5 = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d13 + d12, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, d11, gauge.isCounterClockwise());
            Polygon polygon = new Polygon();
            polygon.addPoint(point3.x, point3.y);
            polygon.addPoint(point.x, point.y);
            polygon.addPoint(point4.x, point4.y);
            polygon.addPoint(point5.x, point5.y);
            graphics.fillPolygon(polygon);
            ++n3;
        }
    }

    protected void drawWarningBars(Graphics2D graphics2D, Gauge gauge) {
    }

    protected double getAngleFromValue(Gauge gauge, double d2) {
        double d3 = (d2 - gauge.min()) / (gauge.max() - gauge.min());
        double d4 = (double)(gauge.getSweepBeginDegree() + gauge.getSweepAngle()) - (double)gauge.getSweepAngle() * d3;
        return gauge.isCounterClockwise() ? 180.0 - d4 : d4;
    }

    protected void drawWarningIndicator(Graphics graphics, Gauge gauge) {
        if (gauge.getValue() > gauge.lowWarning() && gauge.getValue() < gauge.highWarning()) {
            return;
        }
        float f2 = ((float)this.getGaugeHeight(gauge) - 2.0f * (float)gauge.getBorderWidth() + 1.0f) / 8.0f;
        graphics.setColor(gauge.getWarnColor());
        graphics.fillArc(Math.round(((float)this.getGaugeWidth(gauge) - f2) / 2.0f + (float)this.getXOffset(gauge)), Math.round(((float)this.getGaugeHeight(gauge) - f2) / 2.0f + (float)this.getYOffset(gauge)) - 1, Math.round(f2), Math.round(f2), gauge.getStartAngle(), gauge.getFaceAngle());
    }

    private Polygon getNeedleShape(Gauge gauge, double d2) {
        double d3 = this.getOuterEdge(gauge);
        double d4 = gauge.isCounterClockwise() ? 180.0 - d2 : d2;
        int n2 = this.getGaugeWidth(gauge) / 2;
        int n3 = this.getGaugeHeight(gauge) / 2;
        int n4 = this.getGaugeWidth(gauge) > this.getGaugeHeight(gauge) ? n3 - 2 * gauge.getBorderWidth() : n2 - 2 * gauge.getBorderWidth();
        Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d2 - 0.25, n2, n3, d3 - 0.07, gauge.isCounterClockwise());
        Point point2 = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d2 + 0.25, n2, n3, d3 - 0.07, gauge.isCounterClockwise());
        Point point3 = this.getPoint(n4 / 7 + 1, (d4 + 164.0) % 360.0, n2, n3);
        Point point4 = this.getPoint(n4 / 5, (d4 - 180.0) % 360.0, n2, n3);
        Point point5 = this.getPoint(n4 / 7 + 1, (d4 - 164.0) % 360.0, n2, n3);
        if (gauge.isCounterClockwise()) {
            Point point6 = point5;
            point5 = point3;
            point3 = point6;
        }
        this.needleShape = new Polygon();
        this.needleShape.addPoint(point.x + this.getXOffset(gauge), point.y + this.getYOffset(gauge));
        this.needleShape.addPoint(point2.x + this.getXOffset(gauge), point2.y + this.getYOffset(gauge));
        this.needleShape.addPoint(point3.x + this.getXOffset(gauge), point3.y + this.getYOffset(gauge));
        this.needleShape.addPoint(point4.x + this.getXOffset(gauge), point4.y + this.getYOffset(gauge));
        this.needleShape.addPoint(point5.x + this.getXOffset(gauge), point5.y + this.getYOffset(gauge));
        return this.needleShape;
    }

    protected void drawNeedle(Graphics graphics, Gauge gauge, double d2) {
        int n2 = this.getGaugeWidth(gauge) / 2;
        int n3 = this.getGaugeHeight(gauge) / 2;
        int n4 = Math.round((float)(gauge.getShortestSize() - 2 * gauge.getBorderWidth()) * 0.955f);
        if (gauge.needleImage(n4) != null && n4 > 0) {
            Image image = gauge.needleImage(n4);
            double d3 = gauge.isCounterClockwise() ? 180.0 - d2 : d2;
            double d4 = gauge.isCounterClockwise() ? (-90.0 + d3) * 2.0 * Math.PI / 360.0 : (d3 - 90.0) * 2.0 * Math.PI / 360.0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (gauge.isShowHistory()) {
                double d5;
                if (this.lastHistoryValue != gauge.getHistoricalPeakValue() || this.historyNeedleShape == null) {
                    d5 = this.getAngleFromValue(gauge, gauge.getHistoricalPeakValue());
                    double d6 = gauge.isCounterClockwise() ? 180.0 - d5 : d5;
                    this.historyNeedleShape = this.getNeedleShape(gauge, d6);
                    this.lastHistoryValue = gauge.getHistoricalPeakValue();
                }
                if ((d5 = (gauge.getHistoricalPeakValue() - gauge.getValue()) / (gauge.max() - gauge.min())) > 0.008 && this.historyNeedleStroke != null) {
                    graphics.setColor(gauge.getNeedleColor());
                    graphics2D.setStroke(this.historyNeedleStroke);
                    graphics.drawPolygon(this.historyNeedleShape);
                    graphics2D.setStroke(this.needleStroke);
                }
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform2.rotate(-d4, gauge.getWidth() / 2, gauge.getHeight() / 2);
            float f2 = (float)(gauge.getWidth() - image.getWidth(null)) / 2.0f;
            float f3 = (float)(gauge.getHeight() - image.getHeight(null)) / 2.0f;
            affineTransform2.translate(f2, f3);
            graphics2D.setTransform(affineTransform2);
            graphics2D.drawImage(image, 0, 0, gauge);
            graphics2D.setTransform(affineTransform);
        } else {
            double d7;
            this.needleShape = this.getNeedleShape(gauge, d2);
            graphics.fillPolygon(this.needleShape);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(this.needleStroke);
            if (gauge.isShowHistory()) {
                double d8;
                if (this.lastHistoryValue != gauge.getHistoricalPeakValue() || this.historyNeedleShape == null) {
                    d8 = this.getAngleFromValue(gauge, gauge.getHistoricalPeakValue());
                    d7 = gauge.isCounterClockwise() ? 180.0 - d8 : d8;
                    this.historyNeedleShape = this.getNeedleShape(gauge, d7);
                    this.lastHistoryValue = gauge.getHistoricalPeakValue();
                }
                if ((d8 = (gauge.getHistoricalPeakValue() - gauge.getValue()) / (gauge.max() - gauge.min())) > 0.008) {
                    graphics.setColor(gauge.getNeedleColor());
                    graphics2D.setStroke(this.historyNeedleStroke);
                    graphics.drawPolygon(this.historyNeedleShape);
                    graphics2D.setStroke(this.needleStroke);
                }
            }
            Color color = gauge.getNeedleColor();
            Color color2 = null;
            color2 = color.getRed() + color.getGreen() + color.getBlue() > 384 ? color.darker() : color.brighter().brighter();
            graphics.setColor(color2);
            d7 = this.getOuterEdge(gauge);
            Point point = this.getPoint(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), d2, n2, n3, d7 - 0.05, gauge.isCounterClockwise());
            graphics.drawLine(n2 + this.getXOffset(gauge), n3 + this.getYOffset(gauge), point.x + this.getXOffset(gauge), point.y + this.getYOffset(gauge));
        }
    }

    protected Image paintBackground(Graphics graphics, Gauge gauge, int n2) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = null;
        Graphics graphics2 = null;
        bufferedImage = graphicsConfiguration.createCompatibleImage(this.getGaugeWidth(gauge), this.getGaugeHeight(gauge), 3);
        graphics2 = ((Image)bufferedImage).getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics2;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D = (Graphics2D)graphics2;
        Color color = new Color(0, 0, 0, 0);
        graphics2.setColor(color);
        graphics2.fillRect(0, 0, this.getGaugeWidth(gauge), this.getGaugeHeight(gauge));
        this.lastPaintTime = System.nanoTime();
        if (n2 == 2) {
            this.paintBgImage(graphics2D, gauge);
        }
        graphics2.setColor(gauge.getBackColor());
        graphics2.setColor(this.getFaceColor(gauge, n2));
        graphics2.fillArc(gauge.getBorderWidth(), gauge.getBorderWidth(), this.getGaugeWidth(gauge) - 2 * gauge.getBorderWidth(), this.getGaugeHeight(gauge) - 2 * gauge.getBorderWidth(), gauge.getStartAngle(), gauge.getFaceAngle());
        if (n2 != 2) {
            this.paintBgImage(graphics2D, gauge);
        }
        this.drawWarningBars((Graphics2D)graphics2, gauge);
        this.drawTickMarks(graphics2, gauge);
        this.drawBorder(graphics2, gauge);
        if (gauge.max() > gauge.min()) {
            this.drawNumbers(graphics2, gauge);
        }
        return bufferedImage;
    }

    protected Color getBrighter(Color color) {
        int n2 = color.getBlue() + color.getRed() + color.getGreen();
        if (n2 < 180) {
            return new Color((n2 += 250) / 3, n2 / 3, n2 / 3);
        }
        return color.brighter();
    }

    protected Color getDarker(Color color) {
        if (color.getBlue() + color.getRed() + color.getGreen() > 650) {
            return color.darker().darker();
        }
        return color.darker();
    }

    protected void drawBorder(Graphics graphics, Gauge gauge) {
        Color color = gauge.getTrimColor();
        if (gauge.getBorderWidth() > 0 && color.getAlpha() > 0) {
            Color color2 = this.getDarker(color);
            color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), color.getAlpha());
            color = this.getBrighter(color);
            if (this.outerGradient == null) {
                this.outerGradient = new GradientPaint(0.0f, 92.0f, color2, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, color, true);
            }
            ((Graphics2D)graphics).setPaint(this.outerGradient);
            ((Graphics2D)graphics).setStroke(new BasicStroke(gauge.getBorderWidth() / 2));
            graphics.drawArc(gauge.getBorderWidth() / 4, gauge.getBorderWidth() / 4, this.getGaugeWidth(gauge) - gauge.getBorderWidth() / 2, this.getGaugeHeight(gauge) - gauge.getBorderWidth() / 2, gauge.getStartAngle(), gauge.getFaceAngle());
            if (this.innerGradient == null) {
                this.innerGradient = new GradientPaint(92.0f, 0.0f, color, this.getGaugeWidth(gauge) / 2, this.getGaugeHeight(gauge) / 2, color2, true);
            }
            ((Graphics2D)graphics).setPaint(this.innerGradient);
            ((Graphics2D)graphics).setStroke(new BasicStroke((gauge.getBorderWidth() + 4) / 2));
            graphics.drawArc(3 * gauge.getBorderWidth() / 4, 3 * gauge.getBorderWidth() / 4, this.getGaugeWidth(gauge) - gauge.getBorderWidth() - gauge.getBorderWidth() / 2, this.getGaugeHeight(gauge) - gauge.getBorderWidth() - gauge.getBorderWidth() / 2, gauge.getStartAngle(), gauge.getFaceAngle());
        }
    }

    protected Point getPoint(int n2, double d2, int n3, int n4) {
        double d3 = d2 * 2.0 * Math.PI / 360.0;
        int n5 = (int)((double)n3 + (double)n2 * Math.cos(d3));
        int n6 = (int)((double)n4 - (double)n2 * Math.sin(d3));
        return new Point(n5, n6);
    }

    protected Point getPoint(int n2, int n3, double d2, int n4, int n5, double d3, boolean bl2) {
        double d4 = bl2 ? (180.0 - d2) * 2.0 * Math.PI / 360.0 : d2 * 2.0 * Math.PI / 360.0;
        float f2 = (float)(Math.sqrt(Math.pow((double)n2 / 2.0, 2.0) * Math.pow((double)n3 / 2.0, 2.0) / (Math.pow((double)n2 / 2.0 * Math.sin(d4), 2.0) + Math.pow((double)n3 / 2.0 * Math.cos(d4), 2.0))) * d3);
        int n6 = n4 + Math.round((float)((double)f2 * Math.cos(d4)));
        int n7 = n5 - Math.round((float)((double)f2 * Math.sin(d4)));
        return new Point(n6, n7);
    }

    @Override
    public boolean requiresBackgroundRepaint(s s2) {
        int n2 = this.currentState((Gauge)s2);
        return this.lastBgState != n2 || s2.getWidth() != this.lastWidth || s2.getHeight() != this.lastHeight;
    }

    @Override
    public void updateGauge(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        if (gauge.isAntialiasingOn()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.drawStrings(graphics, gauge);
        this.drawWarningIndicator(graphics, gauge);
        double d2 = (this.getSmoothedValue(gauge) - gauge.min()) / (gauge.max() - gauge.min());
        if (gauge.isPegLimits() && d2 > 1.02) {
            d2 = this.limitRattle++ % 2 == 0 ? 1.02 : 1.015;
        } else if (gauge.isPegLimits() && d2 < -0.02) {
            d2 = this.limitRattle++ % 2 == 0 ? -0.02 : -0.015;
        }
        double d3 = (double)(gauge.getSweepBeginDegree() + gauge.getSweepAngle()) - (double)gauge.getSweepAngle() * d2;
        graphics.setColor(gauge.getNeedleColor());
        if (gauge.max() > gauge.min()) {
            this.drawNeedle(graphics, gauge, d3);
        }
        this.lastWidth = gauge.getWidth();
        this.lastHeight = gauge.getHeight();
    }

    @Override
    public void paintBackground(Graphics graphics, s s2) {
        Gauge gauge = (Gauge)s2;
        if (this.parentGauge() == null) {
            this.setParentGauge(gauge);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.lastPaintTime = System.nanoTime();
        if (this.getGaugeWidth(gauge) > 0) {
            Image image = this.getOffImage(graphics, gauge);
            graphics.drawImage(image, this.getXOffset(gauge), this.getYOffset(gauge), null);
        }
    }

    @Override
    public String getName() {
        return "Analog Gauge";
    }

    @Override
    public void invalidate() {
        this.normalOffImage = null;
        this.criticalOffImage = null;
        this.warnOffImage = null;
        this.historyNeedleShape = null;
        this.outerGradient = null;
        this.innerGradient = null;
    }

    @Override
    public void initialize(Gauge gauge) {
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return false;
    }

    @Override
    public boolean isComponentPaintedAt(int n2, int n3) {
        if (this.parentGauge() == null) {
            return true;
        }
        double d2 = (this.parentGauge().getWidth() - this.getGaugeWidth(this.parentGauge())) / 2;
        double d3 = (this.parentGauge().getHeight() - this.getGaugeHeight(this.parentGauge())) / 2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, this.getGaugeWidth(this.parentGauge()), this.getGaugeHeight(this.parentGauge()));
        Arc2D.Double double_2 = new Arc2D.Double(double_, this.parentGauge().getStartAngle(), this.parentGauge().getFaceAngle(), 2);
        return double_2.contains(n2, n3);
    }

    public Gauge parentGauge() {
        return this.parentGauge;
    }

    public void setParentGauge(Gauge gauge) {
        this.parentGauge = gauge;
    }

    public int currentState(Gauge gauge) {
        if (gauge.getValue() > gauge.lowWarning() && gauge.getValue() < gauge.highWarning()) {
            return 0;
        }
        if (gauge.getValue() > gauge.highCritical()) {
            return 2;
        }
        return 1;
    }

    private void paintBgImage(Graphics2D graphics2D, Gauge gauge) {
        if (gauge.backgroundImage() != null) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.getGaugeWidth(this.parentGauge()), this.getGaugeHeight(this.parentGauge()));
            Arc2D.Double double_2 = new Arc2D.Double(double_, gauge.getStartAngle(), gauge.getFaceAngle(), 2);
            graphics2D.clip(double_2);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(gauge.backgroundImage(), 1, 1, this.getGaugeWidth(gauge) - 2, this.getGaugeHeight(gauge) - 2, null);
            graphics2D.setClip(0, 0, gauge.getWidth(), gauge.getHeight());
        }
    }

    @Override
    public Area areaPainted(s s2) {
        Gauge gauge = (Gauge)s2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getXOffset(gauge), this.getYOffset(gauge), this.getGaugeWidth(gauge), this.getGaugeHeight(gauge));
        Arc2D.Double double_2 = new Arc2D.Double(double_, gauge.getStartAngle(), gauge.getFaceAngle(), 2);
        Area area = new Area();
        if (gauge.getBackColor().getAlpha() > 50) {
            area.add(new Area(double_2));
            int n2 = this.getGaugeWidth(gauge) / 2;
            int n3 = this.getGaugeHeight(gauge) / 2;
            int n4 = (n2 - 2 * gauge.getBorderWidth()) / 5;
            int n5 = (n3 - 2 * gauge.getBorderWidth()) / 5;
            Arc2D.Double double_3 = new Arc2D.Double(n2 - n4, n3 - n5, 2 * n4, 2 * n5, 0.0, 360.0, 2);
            area.add(new Area(double_3));
        }
        return area;
    }
}

