/*
 * Decompiled with CFR 0.152.
 */
package org.bluecove.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownServiceException;
import org.bluecove.socket.Credentials;
import org.bluecove.socket.LocalSocketAddress;

class LocalSocketImpl
extends SocketImpl {
    private int socket = -1;
    private boolean bound;
    private boolean connected;
    private boolean closed;
    private SocketAddress endpoint;
    private InputStream in;
    private OutputStream out;

    LocalSocketImpl() {
    }

    protected void accept(SocketImpl s) throws IOException {
        if (!(s instanceof LocalSocketImpl)) {
            throw new UnknownServiceException();
        }
        ((LocalSocketImpl)s).socket = this.nativeAccept(this.socket);
        ((LocalSocketImpl)s).connected = true;
        ((LocalSocketImpl)s).endpoint = this.endpoint;
    }

    protected int available() throws IOException {
        return this.nativeAvailable(this.socket);
    }

    protected void bind(InetAddress host, int port) throws IOException {
        throw new UnknownServiceException();
    }

    protected void bind(SocketAddress endpoint) throws IOException {
        if (!(endpoint instanceof LocalSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.nativeBind(this.socket, ((LocalSocketAddress)endpoint).getName(), ((LocalSocketAddress)endpoint).isAbstractNamespace());
        this.bound = true;
        this.endpoint = endpoint;
    }

    protected void listen(int backlog) throws IOException {
        this.nativeListen(this.socket, backlog);
    }

    protected void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.nativeClose(this.socket);
        }
        this.bound = false;
        this.endpoint = null;
    }

    void unlink(String path) {
        this.nativeUnlink(path);
    }

    protected void connect(String host, int port) throws IOException {
        throw new UnknownServiceException();
    }

    protected void connect(InetAddress address, int port) throws IOException {
        throw new UnknownServiceException();
    }

    protected void connect(SocketAddress address, int timeout) throws IOException {
        if (!(address instanceof LocalSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        this.nativeConnect(this.socket, ((LocalSocketAddress)address).getName(), ((LocalSocketAddress)address).isAbstractNamespace(), timeout);
        this.connected = true;
        this.bound = true;
    }

    public SocketAddress getSocketAddress() {
        return this.endpoint;
    }

    protected void create(boolean stream) throws IOException {
        this.socket = this.nativeCreate(stream);
    }

    protected InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = new LocalSocketInputStream();
        }
        return this.in;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            this.out = new LocalSocketOutputStream();
        }
        return this.out;
    }

    protected void shutdownInput() throws IOException {
        this.nativeShutdown(this.socket, true);
    }

    protected void shutdownOutput() throws IOException {
        this.nativeShutdown(this.socket, false);
    }

    protected void sendUrgentData(int data) throws IOException {
    }

    public Object getOption(int optID) throws SocketException {
        int rc = this.nativeGetOption(this.socket, optID);
        return rc;
    }

    public void setOption(int optID, Object value) throws SocketException {
        int nativeValue;
        if (value instanceof Boolean) {
            nativeValue = (Boolean)value != false ? 1 : -1;
        } else if (value instanceof Integer) {
            nativeValue = (Integer)value;
        } else {
            throw new IllegalArgumentException();
        }
        this.nativeSetOption(this.socket, optID, nativeValue);
    }

    protected void finalize() throws IOException {
        if (this.socket > 0) {
            this.close();
        }
    }

    public boolean isCurrentThreadInterruptedCallback() {
        return Thread.interrupted();
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean isConnected() {
        return this.connected;
    }

    boolean isBound() {
        return this.bound;
    }

    Credentials readPeerCredentials() throws IOException {
        int[] ucred = new int[3];
        this.nativeReadCredentials(this.socket, ucred);
        return new Credentials(ucred[0], ucred[2], ucred[2]);
    }

    static Credentials readProcessCredentials() {
        int[] ucred = new int[3];
        LocalSocketImpl.nativeReadProcessCredentials(ucred);
        return new Credentials(ucred[0], ucred[2], ucred[2]);
    }

    private native int nativeCreate(boolean var1) throws IOException;

    private native void nativeConnect(int var1, String var2, boolean var3, int var4);

    private native void nativeBind(int var1, String var2, boolean var3);

    private native void nativeListen(int var1, int var2);

    private native int nativeAccept(int var1) throws IOException;

    private native void nativeClose(int var1) throws IOException;

    private native void nativeShutdown(int var1, boolean var2) throws IOException;

    private native void nativeUnlink(String var1);

    private native int nativeAvailable(int var1) throws IOException;

    private native int nativeRead(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native void nativeWrite(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native void nativeReadCredentials(int var1, int[] var2) throws IOException;

    private static native void nativeReadProcessCredentials(int[] var0);

    private native void nativeSetOption(int var1, int var2, int var3) throws SocketException;

    private native int nativeGetOption(int var1, int var2) throws SocketException;

    private class LocalSocketOutputStream
    extends OutputStream {
        private LocalSocketOutputStream() {
        }

        public void write(int b) throws IOException {
            byte[] buf = new byte[]{(byte)(b & 0xFF)};
            LocalSocketImpl.this.nativeWrite(LocalSocketImpl.this.socket, buf, 0, 1);
        }

        public void write(byte[] buf) throws IOException {
            if (buf == null) {
                throw new NullPointerException();
            }
            LocalSocketImpl.this.nativeWrite(LocalSocketImpl.this.socket, buf, 0, buf.length);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > buf.length) {
                throw new IndexOutOfBoundsException();
            }
            LocalSocketImpl.this.nativeWrite(LocalSocketImpl.this.socket, buf, off, len);
        }
    }

    private class LocalSocketInputStream
    extends InputStream {
        private LocalSocketInputStream() {
        }

        public int available() throws IOException {
            return LocalSocketImpl.this.nativeAvailable(LocalSocketImpl.this.socket);
        }

        public int read() throws IOException {
            byte[] data = new byte[1];
            int size = LocalSocketImpl.this.nativeRead(LocalSocketImpl.this.socket, data, 0, 1);
            if (size == -1) {
                return -1;
            }
            return 0xFF & data[0];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            return LocalSocketImpl.this.nativeRead(LocalSocketImpl.this.socket, b, off, len);
        }
    }

    public static interface LocalSocketOptions {
        public static final int SO_LINGER = 1;
        public static final int SO_PASSCRED = 2;
        public static final int SO_SNDBUF = 3;
        public static final int SO_RCVBUF = 4;
        public static final int SO_RCVTIMEO = 5;
        public static final int SO_SNDTIMEO = 6;
    }
}

