/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.graphics.text.AbstractText;

public class GlyphText
extends AbstractText {
    private static final Logger logger = Logger.getLogger(GlyphText.class.toString());
    private float x;
    private float y;
    private String cid;
    private String unicode;

    public GlyphText(float x, float y, Rectangle2D.Float bounds, String cid, String unicode) {
        this.x = x;
        this.y = y;
        this.bounds = bounds;
        this.cid = cid;
        this.unicode = unicode;
    }

    public void normalizeToUserSpace(AffineTransform af) {
        GeneralPath generalPath = new GeneralPath(this.bounds);
        generalPath.transform(af);
        this.bounds = (Rectangle2D.Float)generalPath.getBounds2D();
    }

    public String getCid() {
        return this.cid;
    }

    public String getUnicode() {
        return this.unicode;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Rectangle2D.Float getBounds() {
        return this.bounds;
    }
}

