/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.actions;

import java.util.HashMap;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.actions.Action;
import org.icepdf.core.pobjects.actions.FileSpecification;
import org.icepdf.core.util.Library;

public class LaunchAction
extends Action {
    public static final Name FILE_KEY = new Name("F");
    public static final Name WIN_KEY = new Name("Win");
    public static final Name MAC_KEY = new Name("Mac");
    public static final Name UNIX_KEY = new Name("Unix");
    public static final Name NEW_WINDOW_KEY = new Name("NewWindow");
    private String externalFile;
    private FileSpecification fileSpecification;
    private Boolean isNewWindow;
    private WindowsLaunchParameters winLaunchParameters = new WindowsLaunchParameters();

    public LaunchAction(Library l, HashMap h) {
        super(l, h);
    }

    public String getExternalFile() {
        Object value = this.getObject(FILE_KEY);
        if (value instanceof StringObject) {
            this.externalFile = ((StringObject)value).getDecryptedLiteralString(this.library.getSecurityManager());
        } else if (this.getFileSpecification() != null) {
            this.externalFile = this.getFileSpecification().getFileSpecification();
        }
        return this.externalFile;
    }

    public void setExternalFile(String externalFile) {
        LiteralStringObject tmp = new LiteralStringObject(externalFile, this.getPObjectReference(), this.library.securityManager);
        this.entries.put(FILE_KEY, tmp);
        this.externalFile = externalFile;
    }

    public boolean getNewWindow() {
        Object value = this.getObject(NEW_WINDOW_KEY);
        if (value instanceof Boolean) {
            this.isNewWindow = (Boolean)value;
        }
        return this.isNewWindow;
    }

    public WindowsLaunchParameters getWinLaunchParameters() {
        return this.winLaunchParameters;
    }

    public FileSpecification getFileSpecification() {
        Object value = this.getObject(FILE_KEY);
        if (value instanceof HashMap) {
            this.fileSpecification = new FileSpecification(this.library, (HashMap)value);
        }
        return this.fileSpecification;
    }

    public class WindowsLaunchParameters {
        private final Name FILE_KEY = new Name("F");
        private final Name DIRECTORY_KEY = new Name("D");
        private final Name OPEN_KEY = new Name("O");
        private final Name PARAMETER_KEY = new Name("P");
        private FileSpecification launchFileSpecification;
        private String launchFile;
        private String defaultDirectory;
        private String operation;
        private String parameters;

        public WindowsLaunchParameters() {
            Object value = LaunchAction.this.getObject(this.FILE_KEY);
            if (value instanceof HashMap) {
                this.launchFileSpecification = new FileSpecification(LaunchAction.this.library, (HashMap)value);
            } else if (value instanceof StringObject) {
                this.launchFile = ((StringObject)value).getDecryptedLiteralString(LaunchAction.this.library.getSecurityManager());
            }
            value = LaunchAction.this.getObject(this.DIRECTORY_KEY);
            if (value instanceof StringObject) {
                this.defaultDirectory = ((StringObject)value).getDecryptedLiteralString(LaunchAction.this.library.getSecurityManager());
            }
            if ((value = LaunchAction.this.getObject(this.OPEN_KEY)) instanceof StringObject) {
                this.operation = ((StringObject)value).getDecryptedLiteralString(LaunchAction.this.library.getSecurityManager());
            }
            if ((value = LaunchAction.this.getObject(this.PARAMETER_KEY)) instanceof StringObject) {
                this.parameters = ((StringObject)value).getLiteralString();
            }
        }

        public String getLaunchFile() {
            return this.launchFile;
        }

        public String getDefaultDirectory() {
            return this.defaultDirectory;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getParameters() {
            return this.parameters;
        }

        public FileSpecification getLaunchFileSpecification() {
            return this.launchFileSpecification;
        }
    }
}

