/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.HashMap;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Library;

public class FieldDictionary
extends Dictionary {
    private static final Logger logger = Logger.getLogger(FieldDictionary.class.toString());
    public static final Name FT_KEY = new Name("FT");
    public static final Name KIDS_KEY = new Name("Kids");
    public static final Name PARENT_KEY = new Name("Parent");
    public static final Name T_KEY = new Name("T");
    public static final Name TU_KEY = new Name("TU");
    public static final Name TM_KEY = new Name("TM");
    public static final Name Ff_KEY = new Name("Ff");
    public static final Name V_KEY = new Name("V");
    public static final Name DV_KEY = new Name("DV");
    public static final Name AA_KEY = new Name("AA");
    private SecurityManager securityManager;
    protected Name fieldType;
    protected String partialFieldName;
    protected String alternativeFieldName;
    protected String exportMappingName;
    protected int flags;
    protected String fieldValue;

    public FieldDictionary(Library library, HashMap entries) {
        super(library, entries);
        StringObject text;
        this.securityManager = library.getSecurityManager();
        Object value = library.getName(entries, FT_KEY);
        if (value != null) {
            this.fieldType = value;
        }
        if ((value = library.getObject(entries, T_KEY)) != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.partialFieldName = text.getDecryptedLiteralString(this.securityManager);
        } else if (value instanceof String) {
            this.partialFieldName = (String)value;
        }
        value = library.getObject(entries, TU_KEY);
        if (value != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.alternativeFieldName = text.getDecryptedLiteralString(this.securityManager);
        } else if (value instanceof String) {
            this.alternativeFieldName = (String)value;
        }
        value = library.getObject(entries, V_KEY);
        if (value != null && value instanceof StringObject) {
            text = (StringObject)value;
            this.fieldValue = text.getDecryptedLiteralString(this.securityManager);
        } else if (value instanceof String) {
            this.fieldValue = (String)value;
        }
    }
}

