/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.ConservativeSizingByteArrayOutputStream;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.filters.ASCII85Decode;
import org.icepdf.core.pobjects.filters.ASCIIHexDecode;
import org.icepdf.core.pobjects.filters.FlateDecode;
import org.icepdf.core.pobjects.filters.LZWDecode;
import org.icepdf.core.pobjects.filters.PredictorDecode;
import org.icepdf.core.pobjects.filters.RunLengthDecode;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream
extends Dictionary {
    private static final Logger logger = Logger.getLogger(Stream.class.toString());
    public static final Name WIDTH_KEY = new Name("Width");
    public static final Name W_KEY = new Name("W");
    public static final Name HEIGHT_KEY = new Name("Height");
    public static final Name H_KEY = new Name("H");
    public static final Name IMAGEMASK_KEY = new Name("ImageMask");
    public static final Name IM_KEY = new Name("IM");
    public static final Name COLORSPACE_KEY = new Name("ColorSpace");
    public static final Name CS_KEY = new Name("CS");
    public static final Name DECODEPARAM_KEY = new Name("DecodeParms");
    public static final Name FILTER_KEY = new Name("Filter");
    public static final Name F_KEY = new Name("F");
    public static final Name INDEXED_KEY = new Name("Indexed");
    public static final Name I_KEY = new Name("I");
    protected byte[] rawBytes;
    protected boolean compressed = true;
    protected Reference pObjectReference = null;

    public Stream(Library l, HashMap h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h);
        if (streamInputWrapper != null) {
            this.rawBytes = this.getRawStreamBytes(streamInputWrapper);
        }
    }

    public Stream(Library l, HashMap h, byte[] rawBytes) {
        super(l, h);
        this.rawBytes = rawBytes;
    }

    @Override
    public void setPObjectReference(Reference reference) {
        this.pObjectReference = reference;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public void setRawBytes(byte[] rawBytes) {
        this.rawBytes = rawBytes;
        this.compressed = false;
    }

    public boolean isRawBytesCompressed() {
        return this.compressed;
    }

    @Override
    public Reference getPObjectReference() {
        return this.pObjectReference;
    }

    protected boolean isImageSubtype() {
        Object subtype = this.library.getObject(this.entries, SUBTYPE_KEY);
        return subtype != null && subtype.equals("Image");
    }

    private byte[] getRawStreamBytes(SeekableInputConstrainedWrapper streamInputWrapper) {
        int length = (int)streamInputWrapper.getLength();
        byte[] rawBytes = new byte[length];
        try {
            streamInputWrapper.read(rawBytes, 0, length);
        }
        catch (IOException e) {
            logger.warning("IO Error getting stream bytes");
        }
        return rawBytes;
    }

    public ByteArrayInputStream getDecodedByteArrayInputStream() {
        return new ByteArrayInputStream(this.getDecodedStreamBytes(0));
    }

    public byte[] getDecodedStreamBytes() {
        return this.getDecodedStreamBytes(8192);
    }

    public byte[] getDecodedStreamBytes(int presize) {
        if (this.compressed) {
            try {
                int read;
                ByteArrayInputStream streamInput = new ByteArrayInputStream(this.rawBytes);
                long rawStreamLength = this.rawBytes.length;
                InputStream input = this.getDecodedInputStream(streamInput, rawStreamLength);
                if (input == null) {
                    return null;
                }
                int outLength = presize > 0 ? presize : Math.max(4096, (int)rawStreamLength);
                ConservativeSizingByteArrayOutputStream out = new ConservativeSizingByteArrayOutputStream(outLength);
                byte[] buffer = new byte[outLength > 4096 ? 4096 : 8192];
                while ((read = input.read(buffer)) > 0) {
                    out.write(buffer, 0, read);
                }
                out.flush();
                out.close();
                input.close();
                out.trim();
                return out.relinquishByteArray();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Problem decoding stream bytes: ", e);
            }
        } else {
            return this.rawBytes;
        }
        return null;
    }

    private InputStream getDecodedInputStream(InputStream streamInput, long streamLength) {
        List<String> filterNames;
        if (streamInput == null || streamLength < 1L) {
            return null;
        }
        InputStream input = streamInput;
        int bufferSize = Math.min(Math.max((int)streamLength, 64), 16384);
        input = new BufferedInputStream(input, bufferSize);
        if (this.library.securityManager != null) {
            HashMap decodeParams = this.library.getDictionary(this.entries, DECODEPARAM_KEY);
            input = this.library.getSecurityManager().getEncryptionInputStream(this.getPObjectReference(), this.library.getSecurityManager().getDecryptionKey(), decodeParams, input, true);
        }
        if ((filterNames = this.getFilterNames()) == null) {
            return input;
        }
        for (String filterName1 : filterNames) {
            String filterName = filterName1.toString();
            if (filterName.equals("FlateDecode") || filterName.equals("/Fl") || filterName.equals("Fl")) {
                input = new FlateDecode(this.library, this.entries, input);
                continue;
            }
            if (filterName.equals("LZWDecode") || filterName.equals("/LZW") || filterName.equals("LZW")) {
                input = new LZWDecode(new BitStream(input), this.library, this.entries);
                continue;
            }
            if (filterName.equals("ASCII85Decode") || filterName.equals("/A85") || filterName.equals("A85")) {
                input = new ASCII85Decode(input);
                continue;
            }
            if (filterName.equals("ASCIIHexDecode") || filterName.equals("/AHx") || filterName.equals("AHx")) {
                input = new ASCIIHexDecode(input);
                continue;
            }
            if (filterName.equals("RunLengthDecode") || filterName.equals("/RL") || filterName.equals("RL")) {
                input = new RunLengthDecode(input);
                continue;
            }
            if (filterName.equals("CCITTFaxDecode") || filterName.equals("/CCF") || filterName.equals("CCF") || filterName.equals("DCTDecode") || filterName.equals("/DCT") || filterName.equals("DCT") || filterName.equals("JBIG2Decode") || filterName.equals("JPXDecode") || !logger.isLoggable(Level.FINE)) continue;
            logger.fine("UNSUPPORTED:" + filterName + " " + this.entries);
        }
        if (PredictorDecode.isPredictor(this.library, this.entries)) {
            input = new PredictorDecode(input, this.library, this.entries);
        }
        return input;
    }

    protected List<String> getFilterNames() {
        List<String> filterNames = null;
        Object o = this.library.getObject(this.entries, FILTER_KEY);
        if (o instanceof Name) {
            filterNames = new ArrayList<String>(1);
            filterNames.add(o.toString());
        } else if (o instanceof List) {
            filterNames = (List)o;
        }
        return filterNames;
    }

    protected List<String> getNormalisedFilterNames() {
        List<String> filterNames = this.getFilterNames();
        if (filterNames == null) {
            return null;
        }
        for (int i = 0; i < filterNames.size(); ++i) {
            String filterName = filterNames.get(i);
            if (filterName.equals("FlateDecode") || filterName.equals("/Fl") || filterName.equals("Fl")) {
                filterName = "FlateDecode";
            } else if (filterName.equals("LZWDecode") || filterName.equals("/LZW") || filterName.equals("LZW")) {
                filterName = "LZWDecode";
            } else if (filterName.equals("ASCII85Decode") || filterName.equals("/A85") || filterName.equals("A85")) {
                filterName = "ASCII85Decode";
            } else if (filterName.equals("ASCIIHexDecode") || filterName.equals("/AHx") || filterName.equals("AHx")) {
                filterName = "ASCIIHexDecode";
            } else if (filterName.equals("RunLengthDecode") || filterName.equals("/RL") || filterName.equals("RL")) {
                filterName = "RunLengthDecode";
            } else if (filterName.equals("CCITTFaxDecode") || filterName.equals("/CCF") || filterName.equals("CCF")) {
                filterName = "CCITTFaxDecode";
            } else if (filterName.equals("DCTDecode") || filterName.equals("/DCT") || filterName.equals("DCT")) {
                filterName = "DCTDecode";
            }
            filterNames.set(i, filterName);
        }
        return filterNames;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("STREAM= ");
        sb.append(this.entries);
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        return sb.toString();
    }
}

