/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.obex.OBEXHeaderSetImpl;
import com.intel.bluetooth.obex.OBEXOperationDelivery;
import com.intel.bluetooth.obex.OBEXOperationInputStream;
import com.intel.bluetooth.obex.OBEXOperationOutputStream;
import com.intel.bluetooth.obex.OBEXOperationReceive;
import com.intel.bluetooth.obex.OBEXServerOperation;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.OBEXSessionBase;
import com.intel.bluetooth.obex.OBEXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class OBEXServerOperationGet
extends OBEXServerOperation
implements OBEXOperationDelivery,
OBEXOperationReceive {
    protected OBEXServerOperationGet(OBEXServerSessionImpl session, OBEXHeaderSetImpl receivedHeaders, boolean finalPacket) throws IOException {
        super(session, receivedHeaders);
        if (finalPacket) {
            this.requestEnded = true;
            this.finalPacketReceived = true;
        }
        this.inputStream = new OBEXOperationInputStream(this);
        this.processIncommingData(receivedHeaders, finalPacket);
    }

    public InputStream openInputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.inputStreamOpened) {
            throw new IOException("input stream already open");
        }
        this.inputStreamOpened = true;
        return this.inputStream;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.isClosed) {
            throw new IOException("operation closed");
        }
        if (this.outputStream != null) {
            throw new IOException("output stream already open");
        }
        this.requestEnded = true;
        this.outputStream = new OBEXOperationOutputStream(this.session.mtu, this);
        this.session.writePacket(144, this.sendHeaders);
        this.sendHeaders = null;
        return this.outputStream;
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.close();
            this.outputStream = null;
        }
        this.inputStream.close();
        super.close();
    }

    protected boolean readRequestPacket() throws IOException {
        boolean finalPacket;
        byte[] b = this.session.readPacket();
        int opcode = b[0] & 0xFF;
        boolean bl = finalPacket = (opcode & 0x80) != 0;
        if (finalPacket) {
            DebugLog.debug("server operation got final packet");
            this.finalPacketReceived = true;
        }
        switch (opcode) {
            case 3: 
            case 131: {
                if (finalPacket) {
                    this.requestEnded = true;
                }
                OBEXHeaderSetImpl requestHeaders = OBEXHeaderSetImpl.readHeaders(b[0], b, 3);
                OBEXHeaderSetImpl.appendHeaders(this.receivedHeaders, requestHeaders);
                this.processIncommingData(requestHeaders, finalPacket);
                break;
            }
            case 255: {
                this.processAbort();
                break;
            }
            default: {
                this.errorReceived = true;
                DebugLog.debug0x("server operation invalid request", OBEXUtils.toStringObexResponseCodes(opcode), opcode);
                this.session.writePacket(192, null);
            }
        }
        return finalPacket;
    }

    public void receiveData(OBEXOperationInputStream is) throws IOException {
        if (this.requestEnded || this.errorReceived) {
            this.inputStream.appendData(null, true);
            return;
        }
        DebugLog.debug("server operation reply continue");
        this.session.writePacket(144, this.sendHeaders);
        this.sendHeaders = null;
        this.readRequestPacket();
    }

    public void deliverPacket(boolean finalPacket, byte[] buffer) throws IOException {
        if (this.session.requestSent) {
            this.readRequestPacket();
            if (this.session.requestSent) {
                throw new IOException("Client not requesting data");
            }
        }
        OBEXHeaderSetImpl dataHeaders = OBEXSessionBase.createOBEXHeaderSetImpl();
        int opcode = 144;
        int dataHeaderID = 72;
        if (finalPacket) {
            dataHeaderID = 73;
        }
        dataHeaders.setHeader(dataHeaderID, buffer);
        if (this.sendHeaders != null) {
            OBEXHeaderSetImpl.appendHeaders(dataHeaders, this.sendHeaders);
            this.sendHeaders = null;
        }
        this.session.writePacket(opcode, dataHeaders);
        this.readRequestPacket();
    }

    private void processAbort() throws IOException {
        this.finalPacketReceived = true;
        this.requestEnded = true;
        this.isAborted = true;
        this.session.writePacket(160, null);
        throw new IOException("Operation aborted");
    }
}

