/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.WeakHashMap;

class WeakVectorFactory {
    WeakVectorFactory() {
    }

    public static WeakVector createWeakVector() {
        try {
            return new WeakVectorOnWeakHashMapImpl();
        }
        catch (Throwable e) {
            return new WeakVectorOnVectorImpl();
        }
    }

    private static class WeakVectorOnWeakHashMapImpl
    implements WeakVector {
        private WeakHashMap mapImpl = new WeakHashMap();

        private WeakVectorOnWeakHashMapImpl() {
        }

        public void addElement(Object obj) {
            this.mapImpl.put(obj, new Object());
        }

        public boolean contains(Object elem) {
            return this.mapImpl.containsKey(elem);
        }

        public Object firstElement() {
            return this.mapImpl.keySet().iterator().next();
        }

        public Enumeration elements() {
            return new EnumerationAdapter(this.mapImpl.keySet().iterator());
        }

        public boolean removeElement(Object obj) {
            return this.mapImpl.remove(obj) != null;
        }

        public int size() {
            return this.mapImpl.size();
        }

        public void removeAllElements() {
            this.mapImpl.clear();
        }

        private static class EnumerationAdapter
        implements Enumeration {
            Iterator iterator;

            public EnumerationAdapter(Iterator iterator) {
                this.iterator = iterator;
            }

            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }

    private static class WeakVectorOnVectorImpl
    implements WeakVector {
        private Vector vectorImpl = new Vector();

        private WeakVectorOnVectorImpl() {
        }

        public void addElement(Object obj) {
            this.vectorImpl.addElement(obj);
        }

        public boolean contains(Object elem) {
            return this.vectorImpl.contains(elem);
        }

        public Object firstElement() {
            return this.vectorImpl.firstElement();
        }

        public Enumeration elements() {
            return this.vectorImpl.elements();
        }

        public boolean removeElement(Object obj) {
            return this.vectorImpl.removeElement(obj);
        }

        public int size() {
            return this.vectorImpl.size();
        }

        public void removeAllElements() {
            this.vectorImpl.removeAllElements();
        }
    }

    public static interface WeakVector {
        public void addElement(Object var1);

        public int size();

        public boolean removeElement(Object var1);

        public boolean contains(Object var1);

        public Object firstElement();

        public Enumeration elements();

        public void removeAllElements();
    }
}

