/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;

public class TinyUtils {
    private static final String OS_NAME = TinyUtils.getSystemPropertyPrivileged("os.name");
    private static final RenderingHints SAVED_HINTS = new RenderingHints(null);
    private static Map osSettings;
    private static boolean is1dot4;
    private static boolean is1dot5;
    private static boolean is1dot6;
    private static String javaVersion;
    public static final Object AA_TEXT_PROPERTY_KEY;

    public static String getSystemPropertyPrivileged(final String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string);
                }
            });
        }
    }

    public static boolean isOSLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isOSMac() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean is1dot4() {
        return is1dot4;
    }

    public static boolean is1dot5() {
        return is1dot5;
    }

    public static boolean is1dot6() {
        return is1dot6;
    }

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n, int n2, int n3) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (graphics instanceof Graphics2D) {
            TinyUtils.drawString(jComponent, (Graphics2D)graphics, string, n2, n3);
        } else {
            graphics.drawString(string, n2, n3);
        }
        if (n >= 0 && n < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = n2 + fontMetrics.stringWidth(string.substring(0, n));
            int n5 = n3;
            int n6 = fontMetrics.charWidth(string.charAt(n));
            int n7 = 1;
            graphics.fillRect(n4, n5 + fontMetrics.getDescent() - 1, n6, n7);
        }
    }

    private static void drawString(JComponent jComponent, Graphics2D graphics2D, String string, int n, int n2) {
        if (jComponent != null && Boolean.TRUE.equals(jComponent.getClientProperty(AA_TEXT_PROPERTY_KEY))) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return;
        }
        if (osSettings != null) {
            RenderingHints renderingHints = TinyUtils.getRenderingHints(graphics2D, osSettings, SAVED_HINTS);
            graphics2D.addRenderingHints(osSettings);
            graphics2D.drawString(string, n, n2);
            graphics2D.addRenderingHints(renderingHints);
            return;
        }
        if (TinyUtils.is1dot5() && "true".equals(System.getProperty("swing.aatext"))) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return;
        }
        graphics2D.drawString(string, n, n2);
    }

    private static RenderingHints getRenderingHints(Graphics2D graphics2D, Map map, RenderingHints renderingHints) {
        if (renderingHints == null) {
            renderingHints = new RenderingHints(null);
        } else {
            renderingHints.clear();
        }
        if (map == null || map.size() == 0) {
            return renderingHints;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            RenderingHints.Key key = (RenderingHints.Key)iterator.next();
            Object object = graphics2D.getRenderingHint(key);
            renderingHints.put(key, object);
        }
        return renderingHints;
    }

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.out.println("Exception while trying to get " + string + " system property. " + securityException);
            return null;
        }
    }

    static {
        is1dot4 = false;
        is1dot5 = false;
        is1dot6 = false;
        AA_TEXT_PROPERTY_KEY = new StringBuffer("TinyAATextPropertyKey");
        javaVersion = TinyUtils.getSystemPropertyPrivileged("java.version");
        if (javaVersion != null) {
            is1dot4 = javaVersion.startsWith("1.0") || javaVersion.startsWith("1.1") || javaVersion.startsWith("1.2") || javaVersion.startsWith("1.3") || javaVersion.startsWith("1.4");
            is1dot5 = javaVersion.startsWith("1.5");
            is1dot6 = javaVersion.startsWith("1.6");
        }
        osSettings = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Toolkit.getDefaultToolkit().addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                osSettings = (Map)propertyChangeEvent.getNewValue();
            }
        });
    }
}

