/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.TinyMenuItemUI;
import de.muntjak.tinylookandfeel.TinyTitlePane;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class TinyRootPaneUI
extends BasicRootPaneUI
implements FocusListener {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener mouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    private JRootPane root;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private AWTEventListener mouseHandler = new MouseHandler();
    private KeyEventPostProcessor keyPostProcessor = new KeyPostProcessor();
    private boolean topMenuToClose = false;
    private Vector registeredKeyCodes;
    private static final boolean PARENT = false;
    private static final boolean CHILD = true;
    private static final boolean FORWARD = true;
    private static final boolean BACKWARD = false;
    private static final String CANCEL = "cancel";
    private static final String RETURN = "return";
    private static final String SELECT_PARENT = "selectParent";
    private static final String SELECT_CHILD = "selectChild";
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyRootPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.root = (JRootPane)jComponent;
        int n = this.root.getWindowDecorationStyle();
        if (n != 0) {
            this.installClientDecorations(this.root);
        }
    }

    private Vector getRegisteredKeyCodes(JRootPane jRootPane) {
        Vector<Integer> vector = new Vector<Integer>();
        InputMap inputMap = jRootPane.getInputMap(2);
        if (inputMap == null) {
            return vector;
        }
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        if (keyStrokeArray == null) {
            return vector;
        }
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            vector.add(new Integer(keyStrokeArray[i].getKeyCode()));
        }
        return vector;
    }

    private ActionMap getMapForKey(ActionMap actionMap, String string) {
        if (actionMap == null) {
            return null;
        }
        if (actionMap != null && actionMap.keys() != null) {
            Object[] objectArray = actionMap.keys();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!string.equals(objectArray[i])) continue;
                return actionMap;
            }
        }
        return this.getMapForKey(actionMap.getParent(), string);
    }

    boolean isTopMenuToClose() {
        return this.topMenuToClose;
    }

    private void addEscapeMenuHandlers() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit().addAWTEventListener(TinyRootPaneUI.this.mouseHandler, 131120L);
                return null;
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this.keyPostProcessor);
    }

    private void removeEscapeMenuHandlers() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Toolkit.getDefaultToolkit().removeAWTEventListener(TinyRootPaneUI.this.mouseHandler);
                return null;
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this.keyPostProcessor);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.mouseInputListener = null;
        this.root = null;
    }

    protected void installListeners(JRootPane jRootPane) {
        super.installListeners(jRootPane);
        jRootPane.addFocusListener(this);
    }

    protected void uninstallListeners(JRootPane jRootPane) {
        super.uninstallListeners(jRootPane);
        jRootPane.removeFocusListener(this);
    }

    void installBorder(JRootPane jRootPane) {
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            LookAndFeel.installBorder(jRootPane, borderKeys[n]);
        }
    }

    private void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.mouseInputListener == null) {
                this.mouseInputListener = this.createWindowMouseInputListener(jRootPane);
            }
            this.window.addMouseListener(this.mouseInputListener);
            this.window.addMouseMotionListener(this.mouseInputListener);
        }
    }

    private void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeMouseListener(this.mouseInputListener);
            this.window.removeMouseMotionListener(this.mouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        jRootPane.repaint();
        jRootPane.revalidate();
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    private JComponent createTitlePane(JRootPane jRootPane) {
        return new TinyTitlePane(jRootPane, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane jRootPane) {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            jComponent2.setVisible(false);
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = jComponent;
        jRootPane.validate();
        jRootPane.repaint();
    }

    private JComponent getTitlePane() {
        return this.titlePane;
    }

    private JRootPane getRootPane() {
        return this.root;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            int n = jRootPane.getWindowDecorationStyle();
            this.uninstallClientDecorations(jRootPane);
            if (n != 0) {
                this.installClientDecorations(jRootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.topMenuToClose) {
            this.topMenuToClose = false;
            this.removeEscapeMenuHandlers();
        } else {
            JRootPane jRootPane = (JRootPane)focusEvent.getSource();
            this.registeredKeyCodes = this.getRegisteredKeyCodes(jRootPane);
            ActionMap actionMap = this.getMapForKey(jRootPane.getActionMap(), CANCEL);
            if (actionMap != null) {
                actionMap.put(CANCEL, new MenuActions(CANCEL));
                actionMap.put(RETURN, new MenuActions(RETURN));
                actionMap.put(SELECT_PARENT, new MenuActions(SELECT_PARENT));
                actionMap.put(SELECT_CHILD, new MenuActions(SELECT_CHILD));
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private class MenuActions
    extends AbstractAction {
        private String name;

        MenuActions(String string) {
            super(string);
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (TinyRootPaneUI.CANCEL.equals(this.name)) {
                this.cancel();
            } else if (TinyRootPaneUI.SELECT_PARENT.equals(this.name)) {
                this.selectParentChild(false);
            } else if (TinyRootPaneUI.SELECT_CHILD.equals(this.name)) {
                this.selectParentChild(true);
            } else if (TinyRootPaneUI.RETURN.equals(this.name)) {
                this.doReturn();
            }
        }

        private void cancel() {
            MenuElement[] menuElementArray;
            JPopupMenu jPopupMenu = this.getLastPopup();
            if (jPopupMenu != null) {
                jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            if ((menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath()).length > 2) {
                int n = Math.max(2, menuElementArray.length - 2);
                MenuElement[] menuElementArray2 = new MenuElement[n];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                if (n == 2 && !TinyRootPaneUI.this.topMenuToClose) {
                    TinyRootPaneUI.this.topMenuToClose = true;
                    TinyRootPaneUI.this.addEscapeMenuHandlers();
                }
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                if (TinyRootPaneUI.this.topMenuToClose) {
                    TinyRootPaneUI.this.topMenuToClose = false;
                    TinyRootPaneUI.this.removeEscapeMenuHandlers();
                }
            }
        }

        private void doReturn() {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (component != null && !(component instanceof JRootPane)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    JPopupMenu jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    MenuElement menuElement2 = this.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                    if (menuElement2 != null) {
                        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                        menuElementArray2[menuElementArray.length] = jPopupMenu;
                        menuElementArray2[menuElementArray.length + 1] = menuElement2;
                        menuSelectionManager.setSelectedPath(menuElementArray2);
                    } else {
                        MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                        System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                        menuElementArray3[menuElementArray.length] = jPopupMenu;
                        menuSelectionManager.setSelectedPath(menuElementArray3);
                    }
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof TinyMenuItemUI) {
                        ((TinyMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }

        private void selectParentChild(boolean bl) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (!bl) {
                int n2 = n - 1;
                if (n > 2 && (menuElementArray[n2] instanceof JPopupMenu || menuElementArray[--n2] instanceof JPopupMenu) && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n2);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n > 0 && menuElementArray[n - 1] instanceof JMenu && !((JMenu)menuElementArray[n - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = this.findEnabledChild(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n + 1];
                } else {
                    menuElementArray3 = new MenuElement[n + 2];
                    menuElementArray3[n + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n);
                menuElementArray3[n] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = this.findEnabledChild(menuElementArray[0].getSubElements(), menuElement, bl);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    JPopupMenu jPopupMenu;
                    MenuElement menuElement3;
                    MenuElement[] menuElementArray5 = null;
                    menuElementArray5 = n == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : ((menuElement3 = this.findEnabledChild((jPopupMenu = ((JMenu)menuElement2).getPopupMenu()).getSubElements(), -1, true)) != null ? new MenuElement[]{menuElementArray[0], menuElement2, jPopupMenu, menuElement3} : new MenuElement[]{menuElementArray[0], menuElement2, jPopupMenu});
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }

        private void selectItem(boolean bl) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length < 2) {
                return;
            }
            int n = menuElementArray.length;
            if (menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu && n == 2) {
                MenuElement[] menuElementArray2;
                JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                MenuElement menuElement = this.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                if (menuElement != null) {
                    menuElementArray2 = new MenuElement[4];
                    menuElementArray2[3] = menuElement;
                } else {
                    menuElementArray2 = new MenuElement[3];
                }
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, 2);
                menuElementArray2[2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray2);
            } else if (menuElementArray[n - 1] instanceof JPopupMenu && menuElementArray[n - 2] instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray[n - 2];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement menuElement = this.findEnabledChild(jPopupMenu.getSubElements(), -1, bl);
                if (menuElement != null) {
                    MenuElement[] menuElementArray3 = new MenuElement[n + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n);
                    menuElementArray3[n] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                } else if (n > 2 && menuElementArray[n - 3] instanceof JPopupMenu && (menuElement = this.findEnabledChild((jPopupMenu = (JPopupMenu)menuElementArray[n - 3]).getSubElements(), jMenu, bl)) != null && menuElement != jMenu) {
                    MenuElement[] menuElementArray4 = new MenuElement[n - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n - 2);
                    menuElementArray4[n - 2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                }
            } else {
                MenuElement[] menuElementArray5 = menuElementArray[n - 2].getSubElements();
                MenuElement menuElement = this.findEnabledChild(menuElementArray5, menuElementArray[n - 1], bl);
                if (menuElement == null) {
                    menuElement = this.findEnabledChild(menuElementArray5, -1, bl);
                }
                if (menuElement != null) {
                    menuElementArray[n - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        private JPopupMenu getLastPopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = null;
            for (int i = menuElementArray.length - 1; jPopupMenu == null && i >= 0; --i) {
                if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
                jPopupMenu = (JPopupMenu)menuElementArray[i];
            }
            return jPopupMenu;
        }

        private MenuElement findEnabledChild(MenuElement[] menuElementArray, int n, boolean bl) {
            MenuElement menuElement = null;
            if (bl) {
                menuElement = this.nextEnabledChild(menuElementArray, n + 1, menuElementArray.length - 1);
                if (menuElement == null) {
                    menuElement = this.nextEnabledChild(menuElementArray, 0, n - 1);
                }
            } else {
                menuElement = this.previousEnabledChild(menuElementArray, n - 1, 0);
                if (menuElement == null) {
                    menuElement = this.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n + 1);
                }
            }
            return menuElement;
        }

        private MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                Component component;
                if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !component.isVisible()) continue;
                return menuElementArray[i];
            }
            return null;
        }

        private MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
            for (int i = n; i >= n2; --i) {
                Component component;
                if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !component.isVisible()) continue;
                return menuElementArray[i];
            }
            return null;
        }

        private MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl) {
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (menuElementArray[i] != menuElement) continue;
                return this.findEnabledChild(menuElementArray, i, bl);
            }
            return null;
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            JRootPane jRootPane = TinyRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Window window = (Window)mouseEvent.getSource();
            Point point2 = SwingUtilities.convertPoint(window, point, TinyRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n2 = n = frame != null ? frame.getExtendedState() : 0;
            if (TinyRootPaneUI.this.getTitlePane() != null && TinyRootPaneUI.this.getTitlePane().contains(point2)) {
                if (mouseEvent.getClickCount() == 2 && frame != null && frame.isResizable()) {
                    if ((n & 2) == 2 || (n & 4) == 4) {
                        frame.setExtendedState(n & 0xFFFFFFF9);
                    } else {
                        frame.setExtendedState(n | 6);
                    }
                    return;
                }
                if ((frame != null && (n & 2) != 2 && (n & 4) != 4 || dialog != null) && point.y >= 5 && point.x >= 5 && point.x < window.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                    return;
                }
            }
            if (frame != null && frame.isResizable() && (n & 2) != 2 && (n & 4) != 4 || dialog != null && dialog.isResizable()) {
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
                this.dragWidth = window.getWidth();
                this.dragHeight = window.getHeight();
                int n3 = this.calculateCorner(window, point.x, point.y);
                this.dragCursor = this.getCursor(n3);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragCursor != 0 && TinyRootPaneUI.this.window != null && !TinyRootPaneUI.this.window.isValid()) {
                TinyRootPaneUI.this.window.validate();
                TinyRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
            Window window = (Window)mouseEvent.getSource();
            if (window.getCursor() != TinyRootPaneUI.this.lastCursor) {
                window.setCursor(TinyRootPaneUI.this.lastCursor);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            JRootPane jRootPane = TinyRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n = this.getCursor(this.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
            if (n != 0 && (frame != null && frame.isResizable() && (frame.getExtendedState() & 4) != 4 && (frame.getExtendedState() & 2) != 2 || dialog != null && dialog.isResizable())) {
                window.setCursor(Cursor.getPredefinedCursor(n));
            } else {
                window.setCursor(TinyRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle rectangle, Dimension dimension, int n, int n2, int n3, int n4) {
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.width += n3;
            rectangle.height += n4;
            if (dimension != null) {
                int n5;
                if (rectangle.width < dimension.width) {
                    n5 = dimension.width - rectangle.width;
                    if (n != 0) {
                        rectangle.x -= n5;
                    }
                    rectangle.width = dimension.width;
                }
                if (rectangle.height < dimension.height) {
                    n5 = dimension.height - rectangle.height;
                    if (n2 != 0) {
                        rectangle.y -= n5;
                    }
                    rectangle.height = dimension.height;
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                Point point2 = window.getLocationOnScreen();
                point2.x += point.x - this.dragOffsetX;
                point2.y += point.y - this.dragOffsetY;
                window.setLocation(point2);
            } else if (this.dragCursor != 0) {
                Rectangle rectangle = window.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                Dimension dimension = window.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(rectangle, dimension, 0, 0, 0, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 8: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 6: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                }
                if (!rectangle.equals(rectangle2)) {
                    window.setBounds(rectangle);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        window.validate();
                        TinyRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            TinyRootPaneUI.this.lastCursor = window.getCursor();
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            window.setCursor(TinyRootPaneUI.this.lastCursor);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private int calculateCorner(Component component, int n, int n2) {
            int n3 = this.calculatePosition(n, component.getWidth());
            int n4 = this.calculatePosition(n2, component.getHeight());
            if (n3 == -1 || n4 == -1) {
                return -1;
            }
            return n4 * 5 + n3;
        }

        private int getCursor(int n) {
            if (n == -1) {
                return 0;
            }
            return cursorMapping[n];
        }

        private int calculatePosition(int n, int n2) {
            if (n < 5) {
                return 0;
            }
            if (n < 16) {
                return 1;
            }
            if (n >= n2 - 5) {
                return 4;
            }
            if (n >= n2 - 16) {
                return 3;
            }
            return 2;
        }
    }

    private class KeyPostProcessor
    implements KeyEventPostProcessor {
        private KeyPostProcessor() {
        }

        public boolean postProcessKeyEvent(KeyEvent keyEvent) {
            if (!TinyRootPaneUI.this.topMenuToClose) {
                return false;
            }
            if (keyEvent.getID() != 401) {
                return false;
            }
            if (keyEvent.getKeyCode() == 27) {
                return false;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            boolean bl = false;
            Iterator iterator = TinyRootPaneUI.this.registeredKeyCodes.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (n != keyEvent.getKeyCode()) continue;
                if (menuElementArray.length > 2) {
                    TinyRootPaneUI.this.topMenuToClose = false;
                    TinyRootPaneUI.this.removeEscapeMenuHandlers();
                }
                return false;
            }
            if (menuElementArray.length == 2) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            TinyRootPaneUI.this.topMenuToClose = false;
            TinyRootPaneUI.this.removeEscapeMenuHandlers();
            return false;
        }
    }

    private class MouseHandler
    implements AWTEventListener {
        private MouseHandler() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (!TinyRootPaneUI.this.topMenuToClose) {
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
            TinyRootPaneUI.this.topMenuToClose = false;
            TinyRootPaneUI.this.removeEscapeMenuHandlers();
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getPreferredSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof TinyRootPaneUI && (jComponent = ((TinyRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getPreferredSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMinimumSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof TinyRootPaneUI && (jComponent = ((TinyRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMinimumSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        public Dimension maximumLayoutSize(Container container) {
            int n;
            int n2;
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (jRootPane.getContentPane() != null && (dimension3 = jRootPane.getContentPane().getMaximumSize()) != null) {
                n3 = dimension3.width;
                n4 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMaximumSize()) != null) {
                n5 = dimension2.width;
                n6 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof TinyRootPaneUI && (jComponent = ((TinyRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMaximumSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            if ((n2 = Math.max(Math.max(n4, n6), n8)) != Integer.MAX_VALUE) {
                n2 = n4 + n6 + n8 + insets.top + insets.bottom;
            }
            if ((n = Math.max(Math.max(n3, n5), n7)) != Integer.MAX_VALUE) {
                n += insets.left + insets.right;
            }
            return new Dimension(n, n2);
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof TinyRootPaneUI && (serializable = ((TinyRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n4 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n2, n4);
                n += n4;
            }
            if (jRootPane.getJMenuBar() != null) {
                serializable = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, n, n2, ((Dimension)serializable).height);
                n += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                serializable = jRootPane.getContentPane().getPreferredSize();
                jRootPane.getContentPane().setBounds(0, n, n2, n3 < n ? 0 : n3 - n);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

