/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.TinyInternalFrameTitlePane;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class TinyInternalFrameUI
extends BasicInternalFrameUI {
    private TinyInternalFrameBorder frameBorder;
    private TinyInternalFrameTitlePane titlePane;

    public TinyInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TinyInternalFrameUI((JInternalFrame)jComponent);
    }

    JDesktopPane getDesktopPane(JComponent jComponent) {
        JDesktopPane jDesktopPane = null;
        Container container = jComponent.getParent();
        while (jDesktopPane == null) {
            if (container instanceof JDesktopPane) {
                jDesktopPane = (JDesktopPane)container;
                continue;
            }
            if (container == null) break;
            container = container.getParent();
        }
        return jDesktopPane;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.frameBorder = new TinyInternalFrameBorder();
        this.frame.setBorder(this.frameBorder);
        this.frame.setOpaque(false);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new TinyInternalFramePropertyChangeListener();
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        super.createNorthPane(jInternalFrame);
        this.titlePane = new TinyInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        super.activateFrame(jInternalFrame);
        this.frameBorder.setActive(true);
        this.titlePane.activate();
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        super.deactivateFrame(jInternalFrame);
        this.frameBorder.setActive(false);
        this.titlePane.deactivate();
    }

    public void setPalette(boolean bl) {
        this.titlePane.setPalette(bl);
        this.frame.setBorder(this.frameBorder);
        this.frame.putClientProperty("isPalette", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public class TinyInternalFramePropertyChangeListener
    extends BasicInternalFrameUI.InternalFramePropertyChangeListener {
        public TinyInternalFramePropertyChangeListener() {
            super(TinyInternalFrameUI.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
            TinyInternalFrameUI tinyInternalFrameUI = (TinyInternalFrameUI)jInternalFrame.getUI();
            if (string.equals("JInternalFrame.isPalette")) {
                if (propertyChangeEvent.getNewValue() != null) {
                    tinyInternalFrameUI.setPalette((Boolean)propertyChangeEvent.getNewValue());
                } else {
                    tinyInternalFrameUI.setPalette(false);
                }
            }
            super.propertyChange(propertyChangeEvent);
        }
    }
}

