/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.util.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.metal.MetalComboBoxEditor;

public class TinyComboBoxEditor
extends MetalComboBoxEditor {
    public TinyComboBoxEditor() {
        this.editor = new JTextField("", 9){

            public void setText(String string) {
                if (this.getText().equals(string)) {
                    return;
                }
                super.setText(string);
            }
        };
        this.editor.setBorder(new EditorBorder());
    }

    private void drawXpBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (component != null && component.getParent() != null && component.getParent().getParent() != null) {
            graphics.setColor(component.getParent().getParent().getBackground());
        }
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n4 - 1);
        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        if (!component.isEnabled()) {
            DrawRoutines.drawEditableComboBorder(graphics, Theme.comboBorderDisabledColor.getColor(), 0, 0, n3, n4);
        } else {
            DrawRoutines.drawEditableComboBorder(graphics, Theme.comboBorderColor.getColor(), 0, 0, n3, n4);
        }
    }

    public static class UIResource
    extends TinyComboBoxEditor
    implements javax.swing.plaf.UIResource {
    }

    class EditorBorder
    extends AbstractBorder {
        EditorBorder() {
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, Theme.comboInsets.left + 1, 1, 0);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JComponent jComponent = (JComponent)TinyComboBoxEditor.this.editor.getParent();
            if (jComponent != null && jComponent.getBorder() == null) {
                return;
            }
            TinyComboBoxEditor.this.drawXpBorder(component, graphics, n, n2, n3, n4);
        }
    }
}

