/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ThemeDescription {
    private URI uri;
    private URL url;
    private File file;
    private boolean fileHasBeenSet = false;
    private String name = null;

    public ThemeDescription(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("url may not be null");
        }
        try {
            this.uri = !"file".equals(uRL.getProtocol()) ? new URI(uRL.getPath()) : new URI(uRL.toExternalForm());
            this.url = uRL;
        }
        catch (URISyntaxException uRISyntaxException) {
            this.uri = null;
        }
    }

    public ThemeDescription(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("uri may not be null");
        }
        try {
            this.url = uRI.toURL();
            this.uri = uRI;
        }
        catch (MalformedURLException malformedURLException) {
            this.url = null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ThemeDescription)) {
            return false;
        }
        ThemeDescription themeDescription = (ThemeDescription)object;
        if (this.isValid() != themeDescription.isValid()) {
            return false;
        }
        if (this.isValid()) {
            return this.uri.equals(themeDescription.uri);
        }
        return true;
    }

    public boolean isValid() {
        return this.uri != null && this.url != null;
    }

    public String getName() {
        if (this.uri == null) {
            return "? URI == null ?";
        }
        if (this.name == null) {
            this.name = ThemeDescription.getName(this.uri.getPath());
        }
        return this.name;
    }

    private static String getName(String string) {
        if (string == null) {
            return "? uri.getPath() == null ?";
        }
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        int n = string2.indexOf(".");
        if (n == -1) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isFile() {
        if (!this.isValid()) {
            return false;
        }
        if (Theme.YQ_URL.equals(this.url)) {
            return false;
        }
        return "file".equals(this.url.getProtocol());
    }

    public File getFile() {
        if (this.fileHasBeenSet) {
            return this.file;
        }
        this.fileHasBeenSet = true;
        if (!this.isFile()) {
            return null;
        }
        try {
            this.file = new File(this.uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(this.getClass().getName() + ".getFile() " + illegalArgumentException.toString());
            System.err.println("URI=" + this.uri + "\nURL=" + this.url);
        }
        return this.file;
    }

    public String toString() {
        return this.getName();
    }
}

