/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class SmartBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return SmartBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getPaletteBorder() {
        if (paletteBorder == null) {
            paletteBorder = new PaletteBorder();
        }
        return paletteBorder;
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (JTattooUtilities.isFrameActive((JComponent)c)) {
                g.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
            }
            g.drawRect(x, y, w - 1, h - 1);
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(PaletteBorder.insets.top, PaletteBorder.insets.left, PaletteBorder.insets.bottom, PaletteBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = PaletteBorder.insets.left;
            borderInsets.top = PaletteBorder.insets.top;
            borderInsets.right = PaletteBorder.insets.right;
            borderInsets.bottom = PaletteBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource c2;
            ColorUIResource c1;
            Graphics2D g2D = (Graphics2D)g;
            boolean active = this.isActive(c);
            boolean resizable = this.isResizable(c);
            int th = this.getTitleHeight(c);
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
            if (active) {
                titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
                frameColor = AbstractLookAndFeel.getWindowBorderColor();
            }
            if (!resizable) {
                Insets bi = this.getBorderInsets(c);
                g.setColor(frameColor);
                g.drawRect(x, y, w - 1, h - 1);
                if (active) {
                    g.setColor(AbstractLookAndFeel.getWindowTitleColorDark());
                } else {
                    g.setColor(AbstractLookAndFeel.getWindowInactiveTitleColorDark());
                }
                for (int i = 1; i < bi.left; ++i) {
                    g.drawRect(i, i, w - 2 * i - 1, h - 2 * i - 1);
                }
                g.setColor(frameColor);
                g.drawLine(bi.left - 1, y + th + bi.top, bi.left - 1, y + h - bi.bottom);
                g.drawLine(w - bi.right, y + th + bi.top, w - bi.right, y + h - bi.bottom);
                g.drawLine(bi.left - 1, y + h - bi.bottom, w - bi.right, y + h - bi.bottom);
                return;
            }
            g.setColor(titleColor);
            g.fillRect(x, y + 1, w, 4);
            g.fillRect(x + 1, y + h - 5, w - 2, 4);
            Color color = ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorDark(), 30.0);
            if (active) {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
                c2 = AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h - th - 10, c2));
                g.fillRect(1, 5 + th + 1, 4, h - th - 10);
                g.fillRect(w - 5, 5 + th + 1, 4, h - th - 10);
                g2D.setPaint(null);
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, 5, 5, th + 1);
                c1 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
                c2 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
                g2D.setPaint(new GradientPaint(0.0f, 5 + th + 1, c1, 0.0f, h - th - 10, c2));
                g.fillRect(1, 5 + th + 1, 4, h - th - 10);
                g.fillRect(w - 5, 5 + th + 1, 4, h - th - 10);
                g2D.setPaint(null);
            }
            if (active && resizable) {
                int d = 17;
                color = AbstractLookAndFeel.getWindowTitleColorDark();
                Color cHi = ColorHelper.brighter(color, 30.0);
                Color cLo = ColorHelper.darker(color, 20.0);
                g.setColor(color);
                g.fillRect(x + 1, y + h - d, 4, d - 1);
                g.fillRect(x + 5, y + h - 5, d - 5 - 1, d - 5 - 1);
                g.setColor(cLo);
                g.drawLine(x + 1, y + h - d - 2, x + 5 - 2, y + h - d - 2);
                g.drawLine(x + 5 - 2, y + h - d - 2, x + 5 - 2, y + h - 5);
                g.drawLine(x + 5 - 2, y + h - 5, x + d - 1, y + h - 5);
                g.drawLine(x + d - 1, y + h - 5, x + d - 1, y + h - 1);
                g.setColor(cHi);
                g.drawLine(x + 1, y + h - d - 1, x + 5 - 3, y + h - d - 1);
                g.drawLine(x + 5 - 1, y + h - d - 1, x + 5 - 1, y + h - 5 - 1);
                g.drawLine(x + 5 - 1, y + h - 5 + 1, x + d - 2, y + h - 5 + 1);
                g.drawLine(x + d - 2, y + h - 5 + 1, x + d - 2, y + h - 1);
                g.setColor(color);
                g.fillRect(x + w - d - 1, y + h - 5, d, 4);
                g.fillRect(x + w - 5, y + h - d - 1, 4, d);
                g.setColor(cLo);
                g.drawLine(x + w - 5 - 1, y + h - d - 2, x + w - 1, y + h - d - 2);
                g.drawLine(x + w - 5, y + h - d - 2, x + w - 5, y + h - 5);
                g.drawLine(x + w - d - 1, y + h - 5, x + w - 5, y + h - 5);
                g.drawLine(x + w - d - 1, y + h - 5, x + w - d - 1, y + h - 1);
                g.setColor(cHi);
                g.drawLine(x + w - 5 + 1, y + h - d - 1, x + w - 1, y + h - d - 1);
                g.drawLine(x + w - 5 + 1, y + h - d - 1, x + w - 5 + 1, y + h - 5);
                g.drawLine(x + w - d, y + h - 5 + 1, x + w - 5 + 1, y + h - 5 + 1);
                g.drawLine(x + w - d, y + h - 5 + 1, x + w - d, y + h - 1);
            }
            g.setColor(frameColor);
            g.drawRect(x, y, w - 1, h - 1);
            g.drawLine(x + 5 - 1, y + 5 + th, x + 5 - 1, y + h - 5);
            g.drawLine(x + w - 5, y + 5 + th, x + w - 5, y + h - 5);
            g.drawLine(x + 5 - 1, y + h - 5, x + w - 5, y + h - 5);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Color frameColor = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 30.0);
                    g.setColor(frameColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.1f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color frameHiColor = ColorHelper.darker(frameColor, 5.0);
                    Color frameLoColor = ColorHelper.darker(frameColor, 20.0);
                    JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x, y, w, h);
                    frameHiColor = Color.white;
                    frameLoColor = ColorHelper.brighter(frameLoColor, 60.0);
                    JTattooUtilities.draw3DBorder(g, frameHiColor, frameLoColor, x + 1, y + 1, w - 2, h - 2);
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.white);
                    g.fillRect(x + 2, y + 2, w - 4, h - 4);
                    g2D.setComposite(composite);
                    g.setColor(AbstractLookAndFeel.getFocusColor());
                    g.drawLine(x + 1, y + 1, x + w - 1, y + 1);
                    g.drawLine(x + 1, y + 2, x + w - 2, y + 2);
                } else if (model.isSelected()) {
                    ColorUIResource frameColor = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color frameHiColor = Color.white;
                    Color frameLoColor = ColorHelper.darker(frameColor, 30.0);
                    JTattooUtilities.draw3DBorder(g, frameLoColor, frameHiColor, x, y, w, h);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorLo = new Color(212, 224, 243);
        private static final Insets insets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            Graphics2D g2D = (Graphics2D)g;
            Color frameColor = AbstractLookAndFeel.getTheme().getFrameColor();
            if (!JTattooUtilities.isFrameActive(button)) {
                frameColor = ColorHelper.brighter(frameColor, 40.0);
            }
            if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
                g2D.setColor(Color.white);
                g2D.drawRect(x, y, w - 1, h - 1);
                if (button.getRootPane() != null && button.equals(button.getRootPane().getDefaultButton()) && !button.hasFocus()) {
                    g2D.setColor(ColorHelper.darker(frameColor, 20.0));
                    g2D.drawRect(x, y, w - 1, h - 2);
                    if (!button.getModel().isRollover()) {
                        g2D.setColor(defaultColorHi);
                        g2D.drawRect(x + 1, y + 1, w - 3, h - 4);
                        g2D.setColor(defaultColorLo);
                        g2D.drawRect(x + 2, y + 2, w - 5, h - 6);
                    }
                } else {
                    g2D.setColor(frameColor);
                    g2D.drawRect(x, y, w - 2, h - 2);
                }
            } else {
                Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (button.getRootPane() != null && button.equals(button.getRootPane().getDefaultButton()) && !button.getModel().isRollover()) {
                    g2D.setColor(defaultColorHi);
                    g2D.drawRoundRect(x + 1, y + 1, w - 4, h - 2, 6, 6);
                    g2D.setColor(defaultColorLo);
                    g2D.drawRoundRect(x + 2, y + 2, w - 6, h - 6, 6, 6);
                }
                g2D.setColor(Color.white);
                g2D.drawRoundRect(x, y, w - 1, h - 1, 6, 6);
                g2D.setColor(frameColor);
                g2D.drawRoundRect(x, y, w - 2, h - 2, 6, 6);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            }
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

