/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.IBMJ9Helper;
import com.intel.bluetooth.UtilsJavaSE;
import com.intel.bluetooth.UtilsStringTokenizer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public abstract class NativeLibLoader {
    static final int OS_UNSUPPORTED = -1;
    static final int OS_LINUX = 1;
    static final int OS_WINDOWS = 2;
    static final int OS_WINDOWS_CE = 3;
    static final int OS_MAC_OS_X = 4;
    static final int OS_ANDROID = 5;
    private static int os = 0;
    private static Hashtable libsState = new Hashtable();
    private static Object bluecoveDllDir = null;
    static /* synthetic */ Class class$com$intel$bluetooth$NativeLibLoader;

    private NativeLibLoader() {
    }

    static int getOS() {
        if (os != 0) {
            return os;
        }
        String sysName = System.getProperty("os.name");
        if (sysName == null) {
            DebugLog.fatal("Native Library not available on unknown platform");
            os = -1;
        } else if ((sysName = sysName.toLowerCase()).indexOf("windows") != -1) {
            os = sysName.indexOf("ce") != -1 ? 3 : 2;
        } else if (sysName.indexOf("mac os x") != -1) {
            os = 4;
        } else if (sysName.indexOf("linux") != -1) {
            String javaRuntimeName = System.getProperty("java.runtime.name");
            os = javaRuntimeName != null && javaRuntimeName.toLowerCase().indexOf("android runtime") != -1 ? 5 : 1;
        } else {
            DebugLog.fatal("Native Library not available on platform " + sysName);
            os = -1;
        }
        return os;
    }

    static boolean isAvailable(String name) {
        return NativeLibLoader.isAvailable(name, null);
    }

    static String getLoadErrors(String name) {
        LibState state = (LibState)libsState.get(name);
        if (state == null || state.loadErrors == null) {
            return "";
        }
        return state.loadErrors.toString();
    }

    static boolean isAvailable(String name, Class stackClass) {
        return NativeLibLoader.isAvailable(name, stackClass, true);
    }

    static boolean isAvailable(String name, Class stackClass, boolean requiredLibrary) {
        String libName;
        LibState state = (LibState)libsState.get(name);
        if (state == null) {
            state = new LibState();
            libsState.put(name, state);
        }
        if (state.triedToLoadAlredy) {
            return state.libraryAvailable;
        }
        state.loadErrors = new StringBuffer();
        String libFileName = libName = name;
        String sysName = System.getProperty("os.name");
        String sysArch = System.getProperty("os.arch");
        sysArch = sysArch != null ? sysArch.toLowerCase() : "";
        switch (NativeLibLoader.getOS()) {
            case -1: {
                state.loadErrors.append("Native Library " + name + " not available on [" + sysName + "] platform");
                DebugLog.fatal("Native Library " + name + " not available on [" + sysName + "] platform");
                state.triedToLoadAlredy = true;
                state.libraryAvailable = false;
                return state.libraryAvailable;
            }
            case 3: {
                libFileName = libName = libName + "_ce";
                libFileName = libFileName + ".dll";
                break;
            }
            case 2: {
                if (sysArch.indexOf("amd64") != -1 || sysArch.indexOf("x86_64") != -1) {
                    libFileName = libName = libName + "_x64";
                }
                libFileName = libFileName + ".dll";
                break;
            }
            case 4: {
                libFileName = "lib" + libFileName + ".jnilib";
                break;
            }
            case 1: {
                if (sysArch.indexOf("i386") == -1 && sysArch.length() != 0) {
                    if (sysArch.indexOf("amd64") != -1 || sysArch.indexOf("x86_64") != -1) {
                        libName = libName + "_x64";
                    } else if (sysArch.indexOf("x86") == -1) {
                        libName = libName + "_" + sysArch;
                    }
                }
                libFileName = libName;
                libFileName = "lib" + libFileName + ".so";
                break;
            }
            case 5: {
                libFileName = "lib" + libFileName + ".so";
                break;
            }
            default: {
                state.loadErrors.append("Native Library " + name + " not available on [" + sysName + "] platform");
                DebugLog.fatal("Native Library " + name + " not available on platform " + sysName);
                state.triedToLoadAlredy = true;
                state.libraryAvailable = false;
                return state.libraryAvailable;
            }
        }
        String path = System.getProperty("bluecove.native.path");
        if (path != null && !UtilsJavaSE.ibmJ9midp) {
            state.libraryAvailable = NativeLibLoader.tryloadPath(path, libFileName, state.loadErrors);
        }
        boolean useResource = true;
        String d = System.getProperty("bluecove.native.resource");
        if (d != null && d.equalsIgnoreCase("false") || NativeLibLoader.getOS() == 5) {
            useResource = false;
        }
        if (!state.libraryAvailable && useResource && !UtilsJavaSE.ibmJ9midp) {
            state.libraryAvailable = NativeLibLoader.loadAsSystemResource(libFileName, stackClass, state.loadErrors);
        }
        if (!state.libraryAvailable && NativeLibLoader.getOS() == 1 && !UtilsJavaSE.ibmJ9midp) {
            state.libraryAvailable = NativeLibLoader.tryloadPath(NativeLibLoader.createLinuxPackagePath(sysArch), libFileName, state.loadErrors);
        }
        if (!state.libraryAvailable) {
            state.libraryAvailable = !UtilsJavaSE.ibmJ9midp ? NativeLibLoader.tryload(libName, state.loadErrors) : NativeLibLoader.tryloadIBMj9MIDP(libName);
        }
        if (!state.libraryAvailable) {
            if (requiredLibrary) {
                System.err.println("Native Library " + libName + " not available");
            }
            DebugLog.debug("java.library.path", System.getProperty("java.library.path"));
        }
        state.triedToLoadAlredy = true;
        return state.libraryAvailable;
    }

    private static String createLinuxPackagePath(String sysArch) {
        if (sysArch.indexOf("64") != -1) {
            return "/usr/lib64/bluecove/" + BlueCoveImpl.version;
        }
        return "/usr/lib/bluecove/" + BlueCoveImpl.version;
    }

    private static boolean tryload(String name, StringBuffer loadErrors) {
        try {
            System.loadLibrary(name);
            DebugLog.debug("Library loaded", name);
        }
        catch (Throwable e) {
            DebugLog.error("Library " + name + " not loaded ", e);
            loadErrors.append("\nload [").append(name).append("] ").append(e.getMessage());
            return false;
        }
        return true;
    }

    private static boolean tryloadIBMj9MIDP(String name) {
        try {
            IBMJ9Helper.loadLibrary(name);
            DebugLog.debug("Library loaded", name);
        }
        catch (Throwable e) {
            DebugLog.error("Library " + name + " not loaded ", e);
            return false;
        }
        return true;
    }

    private static boolean tryloadPath(String path, String name, StringBuffer loadErrors) {
        UtilsStringTokenizer tok = new UtilsStringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String dirPath = tok.nextToken();
            File dir = new File(dirPath);
            if (!dir.isDirectory() || !NativeLibLoader.tryloadFile(dir, name, loadErrors)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryloadFile(File path, String name, StringBuffer loadErrors) {
        File f = new File(path, name);
        if (!f.canRead()) {
            DebugLog.debug("Native Library " + f.getAbsolutePath() + " not found");
            return false;
        }
        try {
            System.load(f.getAbsolutePath());
            DebugLog.debug("Library loaded", f.getAbsolutePath());
            return true;
        }
        catch (Throwable e) {
            DebugLog.error("Can't load library from path " + path, e);
            loadErrors.append("\nload [").append(f.getAbsolutePath()).append("] ").append(e.getMessage());
            return false;
        }
    }

    private static boolean tryloadPathIBMj9MIDP(String path, String name) {
        try {
            IBMJ9Helper.loadLibrary(path + "\\" + name);
            DebugLog.debug("Library loaded", path + "\\" + name);
        }
        catch (Throwable e) {
            DebugLog.error("Can't load library from path " + path + "\\" + name, e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadAsSystemResource(String libFileName, Class stackClass, StringBuffer loadErrors) {
        InputStream is = null;
        try {
            ClassLoader clo = null;
            try {
                if (stackClass != null) {
                    clo = stackClass.getClassLoader();
                    DebugLog.debug("Use stack ClassLoader");
                } else {
                    clo = (class$com$intel$bluetooth$NativeLibLoader == null ? (class$com$intel$bluetooth$NativeLibLoader = NativeLibLoader.class$("com.intel.bluetooth.NativeLibLoader")) : class$com$intel$bluetooth$NativeLibLoader).getClassLoader();
                }
            }
            catch (Throwable j9) {
                // empty catch block
            }
            if (clo == null) {
                DebugLog.debug("Use System ClassLoader");
                is = ClassLoader.getSystemResourceAsStream(libFileName);
            } else {
                is = clo.getResourceAsStream(libFileName);
            }
        }
        catch (Throwable e) {
            DebugLog.error("Native Library " + libFileName + " is not a Resource !");
            loadErrors.append("\nresource not found ").append(libFileName);
            return false;
        }
        if (is == null) {
            DebugLog.error("Native Library " + libFileName + " is not a Resource !");
            loadErrors.append("\nresource not found ").append(libFileName);
            return false;
        }
        File fd = NativeLibLoader.makeTempName(libFileName);
        try {
            if (!NativeLibLoader.copy2File(is, fd)) {
                loadErrors.append("\ncan't create temp file");
                boolean j9 = false;
                return j9;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignore) {
                is = null;
            }
        }
        try {
            fd.deleteOnExit();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            System.load(fd.getAbsolutePath());
            DebugLog.debug("Library loaded from", fd);
        }
        catch (Throwable e) {
            DebugLog.fatal("Can't load library file ", e);
            loadErrors.append("\nload resource [").append(fd.getAbsolutePath()).append("] ").append(e.getMessage());
            File debugFileCreated = new File(fd.getAbsolutePath());
            if (!debugFileCreated.canRead()) {
                DebugLog.fatal("File " + fd.getAbsolutePath() + " magicaly disappeared");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy2File(InputStream is, File fd) {
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(fd);
            byte[] b = new byte[1000];
            while ((len = is.read(b)) >= 0) {
                fos.write(b, 0, len);
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            DebugLog.debug("Can't create temp file ", e);
            System.err.println("Can't create temp file " + fd.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {
                    fos = null;
                }
            }
        }
    }

    private static File makeTempName(String libFileName) {
        if (bluecoveDllDir != null) {
            File f = new File((File)bluecoveDllDir, libFileName);
            DebugLog.debug("tmp file", f.getAbsolutePath());
            return f;
        }
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null || tmpDir.length() == 0) {
            tmpDir = "temp";
        }
        String uname = System.getProperty("user.name");
        int count = 0;
        File fd = null;
        File dir = null;
        block7: while (true) {
            if (count > 10) {
                DebugLog.debug("Can't create temporary dir " + dir.getAbsolutePath());
                return new File(tmpDir, libFileName);
            }
            dir = new File(tmpDir, "bluecove_" + uname + "_" + count++);
            if (dir.exists()) {
                if (!dir.isDirectory()) continue;
                try {
                    File[] files = dir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].delete()) continue block7;
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (!dir.exists() && !dir.mkdirs()) {
                DebugLog.debug("Can't create temporary dir ", dir.getAbsolutePath());
                continue;
            }
            try {
                dir.deleteOnExit();
            }
            catch (Throwable e) {
                // empty catch block
            }
            fd = new File(dir, libFileName);
            if (fd.exists() && !fd.delete()) continue;
            try {
                if (fd.createNewFile()) break;
                DebugLog.debug("Can't create file in temporary dir ", fd.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                DebugLog.debug("Can't create file in temporary dir ", fd.getAbsolutePath());
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
            break;
        }
        bluecoveDllDir = dir;
        DebugLog.debug("set dll dir", dir.getAbsolutePath());
        return fd;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LibState {
        boolean triedToLoadAlredy = false;
        boolean libraryAvailable = false;
        StringBuffer loadErrors = new StringBuffer();

        private LibState() {
        }
    }
}

