/*
 * Decompiled with CFR 0.152.
 */
package com.efiAnalytics.apps.ts.dashboard.renderers;

import com.efiAnalytics.apps.ts.dashboard.Gauge;
import com.efiAnalytics.apps.ts.dashboard.renderers.AnalogGaugePainter;
import java.awt.BasicStroke;
import java.awt.Graphics2D;

public class RoundAnalogGaugePainter
extends AnalogGaugePainter {
    String name = "Circle Analog Gauge";

    @Override
    protected int getGaugeWidth(Gauge gauge) {
        return this.getGaugeSize(gauge);
    }

    @Override
    protected int getGaugeHeight(Gauge gauge) {
        return this.getGaugeSize(gauge);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected int getGaugeSize(Gauge gauge) {
        if (gauge.getHeight() > gauge.getWidth()) {
            return gauge.getWidth();
        }
        return gauge.getHeight();
    }

    @Override
    protected int getXOffset(Gauge gauge) {
        int n2 = this.getGaugeSize(gauge);
        if (gauge.getWidth() > n2) {
            return (gauge.getWidth() - n2) / 2;
        }
        return 0;
    }

    @Override
    protected int getYOffset(Gauge gauge) {
        int n2 = this.getGaugeSize(gauge);
        if (gauge.getHeight() > n2) {
            return (gauge.getHeight() - n2) / 2;
        }
        return 0;
    }

    @Override
    public boolean isShapeLockedToAspect() {
        return true;
    }

    @Override
    protected void drawWarningBars(Graphics2D graphics2D, Gauge gauge) {
        int n2 = (int)((double)this.getGaugeSize(gauge) * 0.033);
        int n3 = (int)Math.round(this.getAngleFromValue(gauge, gauge.highWarning()));
        int n4 = (int)Math.round(this.getAngleFromValue(gauge, gauge.highCritical()));
        int n5 = (int)Math.round(this.getAngleFromValue(gauge, gauge.max()));
        int n6 = (int)Math.round(this.getAngleFromValue(gauge, gauge.lowWarning()));
        int n7 = gauge.lowCritical() < gauge.min() ? (int)Math.round(this.getAngleFromValue(gauge, gauge.min())) : (int)Math.round(this.getAngleFromValue(gauge, gauge.lowCritical()));
        int n8 = (int)Math.round(this.getAngleFromValue(gauge, gauge.min()));
        int n9 = gauge.getBorderWidth() + n2 / 2 + n2 / 2;
        BasicStroke basicStroke = new BasicStroke(n2, 0, 0);
        graphics2D.setStroke(basicStroke);
        if (gauge.highWarning() < gauge.max()) {
            graphics2D.setColor(gauge.getWarnColor());
            graphics2D.drawArc(n9, n9, this.getGaugeWidth(gauge) - 2 * n9, this.getGaugeHeight(gauge) - 2 * n9, n3, n4 - n3);
        }
        if (gauge.highCritical() < gauge.max()) {
            graphics2D.setColor(gauge.getCriticalColor());
            graphics2D.drawArc(n9, n9, this.getGaugeWidth(gauge) - 2 * n9, this.getGaugeHeight(gauge) - 2 * n9, n4, n5 - n4);
        }
        if (gauge.lowWarning() > gauge.min()) {
            graphics2D.setColor(gauge.getWarnColor());
            graphics2D.drawArc(n9, n9, this.getGaugeWidth(gauge) - 2 * n9, this.getGaugeHeight(gauge) - 2 * n9, n7, n6 - n7);
        }
        if (gauge.lowCritical() > gauge.min()) {
            graphics2D.setColor(gauge.getCriticalColor());
            graphics2D.drawArc(n9, n9, this.getGaugeWidth(gauge) - 2 * n9, this.getGaugeHeight(gauge) - 2 * n9, n7, n8 - n7);
        }
    }
}

