/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.MenuItemIconFactory;
import de.muntjak.tinylookandfeel.SpecialUIButton;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyMenuUI;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class TinyInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements LayoutManager {
    protected boolean isPalette = false;
    private int buttonsWidth;
    static TinyWindowButtonUI iconButtonUI;
    static TinyWindowButtonUI maxButtonUI;
    static TinyWindowButtonUI closeButtonUI;

    protected PropertyChangeListener createPropertyChangeListener() {
        return new TinyPropertyChangeHandler();
    }

    public TinyInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    protected JMenu createSystemMenu() {
        JMenu jMenu = new JMenu("");
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                if (TinyInternalFrameTitlePane.this.frameHasMenuBar()) {
                    TinyMenuUI.systemMenuShowing = true;
                }
            }

            public void menuDeselected(MenuEvent menuEvent) {
                TinyMenuUI.systemMenuShowing = false;
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        jMenu.putClientProperty("isSystemMenu", Boolean.TRUE);
        return jMenu;
    }

    private boolean frameHasMenuBar() {
        if (this.frame != null) {
            return this.frame.getJMenuBar() != null;
        }
        return false;
    }

    protected void addSystemMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        jMenuItem.setIcon(MenuItemIconFactory.getSystemRestoreIcon());
        jMenuItem.setMnemonic('R');
        jMenuItem = jMenu.add(this.iconifyAction);
        jMenuItem.setIcon(MenuItemIconFactory.getSystemIconifyIcon());
        jMenuItem.setMnemonic('n');
        jMenuItem = jMenu.add(this.maximizeAction);
        jMenuItem.setIcon(MenuItemIconFactory.getSystemMaximizeIcon());
        jMenuItem.setMnemonic('x');
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setIcon(MenuItemIconFactory.getSystemCloseIcon());
        jMenuItem.setMnemonic('C');
    }

    protected void paintTitleBackground(Graphics graphics) {
    }

    public boolean isFrameSelected() {
        return this.frame.isSelected();
    }

    public boolean isFrameMaximized() {
        return this.frame.isMaximum();
    }

    public void paintComponent(Graphics graphics) {
        this.frame.setOpaque(false);
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        boolean bl2 = this.frame.isSelected();
        int n = this.getWidth();
        int n2 = this.getHeight();
        String string = this.frame.getTitle();
        if (string != null) {
            int n3 = bl ? 24 : n - 4 - 16 - 4;
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string);
            int n5 = (n2 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
            if (!bl) {
                n3 -= n4;
            }
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (bl2) {
                graphics.setColor(Theme.frameTitleShadowColor.getColor());
                graphics.drawString(string, n3 + 1, n5 + 1);
                graphics.setColor(Theme.frameTitleColor.getColor());
                graphics.drawString(string, n3, n5);
            } else {
                graphics.setColor(Theme.frameTitleDisabledColor.getColor());
                graphics.drawString(string, n3, n5);
            }
        }
    }

    protected LayoutManager createLayout() {
        return this;
    }

    protected void setButtonIcons() {
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconButton = new SpecialUIButton(iconButtonUI);
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setText(null);
        this.iconButton.setRolloverEnabled(true);
        this.iconButton.addMouseListener(new RolloverListener(this.iconButton));
        this.maxButton = new SpecialUIButton(maxButtonUI);
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setText(null);
        this.maxButton.setRolloverEnabled(true);
        this.maxButton.addMouseListener(new RolloverListener(this.maxButton));
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.addMouseListener(new RolloverListener(this.closeButton));
        this.iconButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.maxButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        if (this.frame.isSelected()) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public void paintPalette(Graphics graphics) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize(container);
    }

    public Dimension getPreferredSize(Container container) {
        int n;
        int n2;
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        int n3 = 22;
        if (this.frame.isClosable()) {
            n3 += 19;
        }
        if (this.frame.isMaximizable()) {
            n3 += 19;
        }
        if (this.frame.isIconifiable()) {
            n3 += 19;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = this.frame.getTitle();
        int n4 = string != null ? fontMetrics.stringWidth(string) : 0;
        int n5 = n2 = string != null ? string.length() : 0;
        n3 = n2 > 3 ? (n3 += n4 < (n = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n4 : n) : (n3 += n4);
        n = this.isPalette ? 21 : 25;
        Dimension dimension = new Dimension(n3, n);
        if (this.getBorder() != null) {
            Insets insets = this.getBorder().getBorderInsets(container);
            dimension.height += insets.top + insets.bottom;
            dimension.width += insets.left + insets.right;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        int n = this.isPalette ? 21 : 25;
        return new Dimension(32, n);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void setPalette(boolean bl) {
        this.isPalette = bl;
    }

    public boolean isPalette() {
        return this.isPalette;
    }

    public void layoutContainer(Container container) {
        int n;
        this.isPalette = this.frame.getClientProperty("isPalette") == Boolean.TRUE;
        boolean bl = this.frame.getComponentOrientation().isLeftToRight();
        int n2 = this.closeButton.getPreferredSize().height;
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        int n5 = bl ? n4 : 0;
        int n6 = (n3 - n2) / 2 + 1;
        int n7 = 0;
        n7 = this.isPalette ? TinyWindowButtonUI.framePaletteButtonSize.width : TinyWindowButtonUI.frameInternalButtonSize.width;
        Icon icon = this.frame.getFrameIcon();
        int n8 = 0;
        if (icon != null) {
            n8 = icon.getIconHeight();
        }
        n5 = bl ? 4 : n4 - 16 - 4;
        this.menuBar.setBounds(n5, (n3 - n8) / 2, 16, 16);
        int n9 = n5 = bl ? n4 : 0;
        if (this.frame.isClosable()) {
            n = 2;
            this.closeButton.setBounds(n5 += bl ? -n - n7 : n, n6, n7, n2);
            if (!bl) {
                n5 += n7;
            }
        }
        if (this.frame.isMaximizable()) {
            n = 2;
            this.maxButton.setBounds(n5 += bl ? -n - n7 : n, n6, n7, n2);
            if (!bl) {
                n5 += n7;
            }
        }
        if (this.frame.isIconifiable()) {
            n = 2;
            this.iconButton.setBounds(n5 += bl ? -n - n7 : n, n6, n7, n2);
            if (!bl) {
                n5 += n7;
            }
        }
        this.buttonsWidth = bl ? n4 - n5 : n5;
    }

    public void activate() {
        this.closeButton.setEnabled(true);
        this.iconButton.setEnabled(true);
        this.maxButton.setEnabled(true);
    }

    public void deactivate() {
        this.closeButton.setEnabled(false);
        this.iconButton.setEnabled(false);
        this.maxButton.setEnabled(false);
    }

    public Font getFont() {
        Font font = null;
        font = this.isPalette ? UIManager.getFont("InternalFrame.paletteTitleFont") : UIManager.getFont("InternalFrame.normalTitleFont");
        return font;
    }

    class TinyPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        TinyPropertyChangeHandler() {
            super(TinyInternalFrameTitlePane.this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("selected")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                TinyInternalFrameTitlePane.this.iconButton.putClientProperty("paintActive", bl);
                TinyInternalFrameTitlePane.this.closeButton.putClientProperty("paintActive", bl);
                TinyInternalFrameTitlePane.this.maxButton.putClientProperty("paintActive", bl);
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    class RolloverListener
    implements MouseListener {
        JButton button;

        public RolloverListener(JButton jButton) {
            this.button = jButton;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.button.getModel().setRollover(true);
            if (!this.button.isEnabled()) {
                this.button.setEnabled(true);
            }
            this.button.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.button.getModel().setRollover(false);
            if (!TinyInternalFrameTitlePane.this.frame.isSelected()) {
                this.button.setEnabled(false);
            }
            this.button.repaint();
        }
    }
}

