#!/bin/sh

ARCH=$( uname -m )
KERNEL=$( uname -s )
SCRIPT=$0

while [ -h "$SCRIPT" ]; do
	SCRIPT=$( readlink "$SCRIPT" )
done

BASE_PATH="${SCRIPT%/*}"
LAST_PATH="$PWD"

if [ ! -e "$BASE_PATH/BigCommGen4.properties" ]; then
	echo "This script must be located in the BigCommPro directory. To be able"
	echo "to launch without path create a symlink of this script to a directory in PATH."
	echo
	echo "Example: ln -s /home/john_doe/BigCommPro/BigCommGen4.sh /usr/local/bin"
	exit 1
fi

cd "$BASE_PATH" && java -Djava.library.path=${SERIAL_DRIVER}lib -cp ".:lib:plugins" -Dfile.encoding=UTF8 -jar BigCommGen4.jar
RESULT=$?

if [ -d "$LAST_PATH" ]; then
	cd "$LAST_PATH"
fi

exit $RESULT
