/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.EnumSet;
import java.util.Set;
import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point3D;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.TransferMode;

public final class DragEvent
extends InputEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<DragEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "DRAG");
    public static final EventType<DragEvent> DRAG_ENTERED_TARGET = new EventType<DragEvent>(ANY, "DRAG_ENTERED_TARGET");
    public static final EventType<DragEvent> DRAG_ENTERED = new EventType<DragEvent>(DRAG_ENTERED_TARGET, "DRAG_ENTERED");
    public static final EventType<DragEvent> DRAG_EXITED_TARGET = new EventType<DragEvent>(ANY, "DRAG_EXITED_TARGET");
    public static final EventType<DragEvent> DRAG_EXITED = new EventType<DragEvent>(DRAG_EXITED_TARGET, "DRAG_EXITED");
    public static final EventType<DragEvent> DRAG_OVER = new EventType<DragEvent>(ANY, "DRAG_OVER");
    public static final EventType<DragEvent> DRAG_DROPPED = new EventType<DragEvent>(ANY, "DRAG_DROPPED");
    public static final EventType<DragEvent> DRAG_DONE = new EventType<DragEvent>(ANY, "DRAG_DONE");
    private transient double x;
    private transient double y;
    private transient double z;
    private final double screenX;
    private final double screenY;
    private final double sceneX;
    private final double sceneY;
    private PickResult pickResult;
    private Object gestureSource;
    private Object gestureTarget;
    private TransferMode transferMode;
    private final State state = new State();
    private transient Dragboard dragboard;

    public DragEvent copyFor(Object source, EventTarget target, Object gestureSource, Object gestureTarget, EventType<DragEvent> eventType) {
        DragEvent copyEvent = this.copyFor(source, target, eventType);
        this.recomputeCoordinatesToSource(copyEvent, source);
        copyEvent.gestureSource = gestureSource;
        copyEvent.gestureTarget = gestureTarget;
        return copyEvent;
    }

    public DragEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<DragEvent> eventType, @NamedArg(value="dragboard") Dragboard dragboard, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="transferMode") TransferMode transferMode, @NamedArg(value="gestureSource") Object gestureSource, @NamedArg(value="gestureTarget") Object gestureTarget, @NamedArg(value="pickResult") PickResult pickResult) {
        super(source, target, (EventType<? extends InputEvent>)eventType);
        this.gestureSource = gestureSource;
        this.gestureTarget = gestureTarget;
        this.x = x;
        this.y = y;
        this.screenX = screenX;
        this.screenY = screenY;
        this.sceneX = x;
        this.sceneY = y;
        this.transferMode = transferMode;
        this.dragboard = dragboard;
        if (eventType == DRAG_DROPPED || eventType == DRAG_DONE) {
            this.state.accepted = transferMode != null;
            this.state.acceptedTrasferMode = transferMode;
        }
        this.pickResult = pickResult != null ? pickResult : new PickResult(eventType == DRAG_DONE ? null : target, x, y);
        Point3D p = InputEventUtils.recomputeCoordinates(this.pickResult, null);
        this.x = p.getX();
        this.y = p.getY();
        this.z = p.getZ();
    }

    public DragEvent(@NamedArg(value="eventType") EventType<DragEvent> eventType, @NamedArg(value="dragboard") Dragboard dragboard, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="transferMode") TransferMode transferMode, @NamedArg(value="gestureSource") Object gestureSource, @NamedArg(value="gestureTarget") Object gestureTarget, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, dragboard, x, y, screenX, screenY, transferMode, gestureSource, gestureTarget, pickResult);
    }

    private void recomputeCoordinatesToSource(DragEvent newEvent, Object newSource) {
        if (newEvent.getEventType() == DRAG_DONE) {
            return;
        }
        Point3D newCoordinates = InputEventUtils.recomputeCoordinates(this.pickResult, newSource);
        newEvent.x = newCoordinates.getX();
        newEvent.y = newCoordinates.getY();
        newEvent.z = newCoordinates.getZ();
    }

    @Override
    public DragEvent copyFor(Object newSource, EventTarget newTarget) {
        DragEvent e = (DragEvent)super.copyFor(newSource, newTarget);
        this.recomputeCoordinatesToSource(e, newSource);
        return e;
    }

    public DragEvent copyFor(Object source, EventTarget target, EventType<DragEvent> type) {
        DragEvent e = this.copyFor(source, target);
        e.eventType = type;
        return e;
    }

    public EventType<DragEvent> getEventType() {
        return super.getEventType();
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    public final Object getGestureSource() {
        return this.gestureSource;
    }

    public final Object getGestureTarget() {
        return this.gestureTarget;
    }

    public final TransferMode getTransferMode() {
        return this.transferMode;
    }

    public final boolean isAccepted() {
        return this.state.accepted;
    }

    public final TransferMode getAcceptedTransferMode() {
        return this.state.acceptedTrasferMode;
    }

    public final Object getAcceptingObject() {
        return this.state.acceptingObject;
    }

    public final Dragboard getDragboard() {
        return this.dragboard;
    }

    private static TransferMode chooseTransferMode(Set<TransferMode> supported, TransferMode[] accepted, TransferMode proposed) {
        TransferMode result = null;
        EnumSet<TransferMode> intersect = EnumSet.noneOf(TransferMode.class);
        for (TransferMode tm : InputEventUtils.safeTransferModes(accepted)) {
            if (!supported.contains((Object)tm)) continue;
            intersect.add(tm);
        }
        if (intersect.contains((Object)proposed)) {
            result = proposed;
        } else if (intersect.contains((Object)TransferMode.MOVE)) {
            result = TransferMode.MOVE;
        } else if (intersect.contains((Object)TransferMode.COPY)) {
            result = TransferMode.COPY;
        } else if (intersect.contains((Object)TransferMode.LINK)) {
            result = TransferMode.LINK;
        }
        return result;
    }

    public void acceptTransferModes(TransferMode ... transferModes) {
        if (this.dragboard == null || this.dragboard.getTransferModes() == null || this.transferMode == null) {
            this.state.accepted = false;
            return;
        }
        TransferMode tm = DragEvent.chooseTransferMode(this.dragboard.getTransferModes(), transferModes, this.transferMode);
        if (tm == null && this.getEventType() == DRAG_DROPPED) {
            throw new IllegalStateException("Accepting unsupported transfer modes inside DRAG_DROPPED handler");
        }
        this.state.accepted = tm != null;
        this.state.acceptedTrasferMode = tm;
        this.state.acceptingObject = this.state.accepted ? this.source : null;
    }

    public void setDropCompleted(boolean isTransferDone) {
        if (this.getEventType() != DRAG_DROPPED) {
            throw new IllegalStateException("setDropCompleted can be called only from DRAG_DROPPED handler");
        }
        this.state.dropCompleted = isTransferDone;
    }

    public boolean isDropCompleted() {
        return this.state.dropCompleted;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.x = this.sceneX;
        this.y = this.sceneY;
    }

    private static class State {
        boolean accepted = false;
        boolean dropCompleted = false;
        TransferMode acceptedTrasferMode = null;
        Object acceptingObject = null;

        private State() {
        }
    }
}

