/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.graphics;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

final class BufferData {
    private final AtomicInteger idCount = new AtomicInteger(0);
    private final HashMap<Integer, String> strMap = new HashMap();
    private final HashMap<Integer, int[]> intArrMap = new HashMap();
    private final HashMap<Integer, float[]> floatArrMap = new HashMap();
    private ByteBuffer buffer;

    BufferData() {
    }

    private int createID() {
        return this.idCount.incrementAndGet();
    }

    int addIntArray(int[] a) {
        int id = this.createID();
        this.intArrMap.put(id, a);
        return id;
    }

    int[] getIntArray(int id) {
        return this.intArrMap.get(id);
    }

    int addFloatArray(float[] a) {
        int id = this.createID();
        this.floatArrMap.put(id, a);
        return id;
    }

    float[] getFloatArray(int id) {
        return this.floatArrMap.get(id);
    }

    int addString(String s) {
        int id = this.createID();
        this.strMap.put(id, s);
        return id;
    }

    String getString(int id) {
        return this.strMap.get(id);
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

