/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.ResourceFactory;
import com.sun.prism.ResourceFactoryListener;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import com.sun.prism.ps.ShaderGraphics;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.FloatMap;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.LockableResource;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.hw.ShaderSource;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrImage;
import com.sun.scenario.effect.impl.prism.PrRenderer;
import com.sun.scenario.effect.impl.prism.PrTexture;
import com.sun.scenario.effect.impl.prism.ps.PPSDrawable;
import com.sun.scenario.effect.impl.prism.ps.PPStoPSWDisplacementMapPeer;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.FloatBuffer;
import java.util.Map;

public class PPSRenderer
extends PrRenderer {
    private ResourceFactory rf;
    private Screen screen;
    private final ShaderSource shaderSource;
    private Renderer.RendererState state;
    private boolean needsSWDispMap;
    private final ResourceFactoryListener listener = new ResourceFactoryListener(){

        @Override
        public void factoryReset() {
            PPSRenderer.this.dispose();
        }

        @Override
        public void factoryReleased() {
            PPSRenderer.this.dispose();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PPSRenderer(Screen screen, ShaderSource shaderSource) {
        this.shaderSource = shaderSource;
        this.screen = screen;
        PPSRenderer pPSRenderer = this;
        synchronized (pPSRenderer) {
            this.state = Renderer.RendererState.NOTREADY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validate() {
        Renderer.RendererState st = this.getRendererState();
        switch (st) {
            case NOTREADY: {
                if (this.rf == null) {
                    this.rf = GraphicsPipeline.getPipeline().getResourceFactory(this.screen);
                    if (this.rf == null) {
                        return false;
                    }
                }
                if (this.rf.isDisposed()) {
                    this.dispose();
                    return false;
                }
                this.rf.addFactoryListener(this.listener);
                this.needsSWDispMap = !this.rf.isFormatSupported(PixelFormat.FLOAT_XYZW);
                PPSRenderer pPSRenderer = this;
                synchronized (pPSRenderer) {
                    this.state = Renderer.RendererState.OK;
                }
                return true;
            }
            case OK: 
            case LOST: {
                return true;
            }
        }
        return false;
    }

    @Override
    public PrDrawable createDrawable(RTTexture rtt) {
        if (!this.validate()) {
            return null;
        }
        return PPSDrawable.create(rtt);
    }

    @Override
    public Effect.AccelType getAccelType() {
        return this.shaderSource.getAccelType();
    }

    @Override
    public synchronized Renderer.RendererState getRendererState() {
        return this.state;
    }

    @Override
    protected Renderer getBackupRenderer() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        for (EffectPeer peer : this.getPeers()) {
            peer.dispose();
        }
        PPSRenderer pPSRenderer = this;
        synchronized (pPSRenderer) {
            this.state = Renderer.RendererState.DISPOSED;
        }
        this.rf.removeFactoryListener(this.listener);
        this.rf = null;
        this.screen = null;
    }

    protected final synchronized void markLost() {
        if (this.state == Renderer.RendererState.NOTREADY || this.state == Renderer.RendererState.OK) {
            this.state = Renderer.RendererState.LOST;
        }
    }

    @Override
    public int getCompatibleWidth(int w) {
        if (!this.validate()) {
            return -1;
        }
        return PPSDrawable.getCompatibleWidth(this.rf, w);
    }

    @Override
    public int getCompatibleHeight(int h) {
        if (!this.validate()) {
            return -1;
        }
        return PPSDrawable.getCompatibleHeight(this.rf, h);
    }

    @Override
    public final PPSDrawable createCompatibleImage(int w, int h) {
        if (!this.validate()) {
            return null;
        }
        return PPSDrawable.create(this.rf, w, h);
    }

    @Override
    public PPSDrawable getCompatibleImage(int w, int h) {
        if (!this.validate()) {
            return null;
        }
        PPSDrawable im = (PPSDrawable)super.getCompatibleImage(w, h);
        if (im == null) {
            this.markLost();
        }
        return im;
    }

    @Override
    public LockableResource createFloatTexture(int w, int h) {
        if (!this.validate()) {
            return null;
        }
        Texture prismTex = this.rf.createFloatTexture(w, h);
        return new PrTexture<Texture>(prismTex);
    }

    @Override
    public void updateFloatTexture(LockableResource texture, FloatMap map) {
        if (!this.validate()) {
            return;
        }
        FloatBuffer buf = map.getBuffer();
        int w = map.getWidth();
        int h = map.getHeight();
        Image img = Image.fromFloatMapData(buf, w, h);
        Object prismTex = ((PrTexture)texture).getTextureObject();
        prismTex.update(img);
    }

    public Shader createShader(String name, Map<String, Integer> samplers, Map<String, Integer> params, boolean isPixcoordUsed) {
        if (!this.validate()) {
            return null;
        }
        if (PrismSettings.verbose) {
            System.out.println("PPSRenderer: scenario.effect - createShader: " + name);
        }
        InputStream pscode = this.shaderSource.loadSource(name);
        int maxTexCoordIndex = samplers.keySet().size() - 1;
        ShaderFactory factory = (ShaderFactory)this.rf;
        return factory.createShader(pscode, samplers, params, maxTexCoordIndex, isPixcoordUsed, false);
    }

    private EffectPeer createIntrinsicPeer(FilterContext fctx, String name) {
        EffectPeer peer;
        Class<?> klass = null;
        try {
            klass = Class.forName("com.sun.scenario.effect.impl.prism.Pr" + name + "Peer");
            Constructor<?> ctor = klass.getConstructor(FilterContext.class, Renderer.class, String.class);
            peer = (EffectPeer)ctor.newInstance(fctx, this, name);
        }
        catch (Exception e) {
            return null;
        }
        return peer;
    }

    private EffectPeer createPlatformPeer(FilterContext fctx, String name, int unrollCount) {
        EffectPeer peer;
        String shaderName = name;
        if (unrollCount > 0) {
            shaderName = shaderName + "_" + unrollCount;
        }
        try {
            Class<?> klass = Class.forName("com.sun.scenario.effect.impl.prism.ps.PPS" + name + "Peer");
            Constructor<?> ctor = klass.getConstructor(FilterContext.class, Renderer.class, String.class);
            peer = (EffectPeer)ctor.newInstance(fctx, this, shaderName);
        }
        catch (Exception e) {
            System.err.println("Error: Prism peer not found for: " + name + " due to error: " + e.getMessage());
            return null;
        }
        return peer;
    }

    @Override
    protected EffectPeer createPeer(FilterContext fctx, String name, int unrollCount) {
        if (PrRenderer.isIntrinsicPeer(name)) {
            return this.createIntrinsicPeer(fctx, name);
        }
        if (this.needsSWDispMap && name.equals("DisplacementMap")) {
            PrFilterContext swctx = ((PrFilterContext)fctx).getSoftwareInstance();
            return new PPStoPSWDisplacementMapPeer(swctx, this, name);
        }
        return this.createPlatformPeer(fctx, name, unrollCount);
    }

    @Override
    public boolean isImageDataCompatible(ImageData id) {
        if (this.getRendererState() == Renderer.RendererState.OK) {
            Filterable f = id.getUntransformedImage();
            return f instanceof PrDrawable && !f.isLost();
        }
        return false;
    }

    @Override
    public void clearImage(Filterable filterable) {
        PPSDrawable img = (PPSDrawable)filterable;
        img.clear();
    }

    @Override
    public ImageData createImageData(FilterContext fctx, Filterable src) {
        BaseTransform tx;
        int h;
        if (!this.validate()) {
            return null;
        }
        if (!(src instanceof PrImage)) {
            throw new IllegalArgumentException("Identity source must be PrImage");
        }
        Image img = ((PrImage)src).getImage();
        int w = img.getWidth();
        PPSDrawable dst = this.createCompatibleImage(w, h = img.getHeight());
        if (dst == null) {
            return null;
        }
        ShaderGraphics g = dst.createGraphics();
        ResourceFactory factory = g.getResourceFactory();
        Texture tex = factory.createTexture(img, Texture.Usage.DEFAULT, Texture.WrapMode.CLAMP_TO_EDGE);
        g.drawTexture(tex, 0.0f, 0.0f, w, h);
        g.sync();
        tex.dispose();
        float ps = img.getPixelScale();
        if (ps != 1.0f) {
            ps = 1.0f / ps;
            tx = BaseTransform.getScaleInstance(ps, ps);
        } else {
            tx = BaseTransform.IDENTITY_TRANSFORM;
        }
        ImageData id = new ImageData(fctx, dst, new Rectangle(w, h), tx);
        return id;
    }

    @Override
    public Filterable transform(FilterContext fctx, Filterable original, BaseTransform transform, Rectangle origBounds, Rectangle xformBounds) {
        if (!this.validate()) {
            return null;
        }
        PPSDrawable dst = this.getCompatibleImage(xformBounds.width, xformBounds.height);
        if (dst != null) {
            ShaderGraphics g = dst.createGraphics();
            g.translate(-xformBounds.x, -xformBounds.y);
            g.transform(transform);
            g.drawTexture((Texture)((PPSDrawable)original).getTextureObject(), origBounds.x, origBounds.y, origBounds.width, origBounds.height);
        }
        return dst;
    }

    @Override
    public ImageData transform(FilterContext fctx, ImageData original, BaseTransform transform, Rectangle origBounds, Rectangle xformBounds) {
        if (!this.validate()) {
            return null;
        }
        PPSDrawable dst = this.getCompatibleImage(xformBounds.width, xformBounds.height);
        if (dst != null) {
            PPSDrawable orig = (PPSDrawable)original.getUntransformedImage();
            ShaderGraphics g = dst.createGraphics();
            g.translate(-xformBounds.x, -xformBounds.y);
            g.transform(transform);
            g.drawTexture((Texture)orig.getTextureObject(), origBounds.x, origBounds.y, origBounds.width, origBounds.height);
        }
        original.unref();
        return new ImageData(fctx, dst, xformBounds);
    }

    private static ShaderSource createShaderSource(String name) {
        Class<?> klass = null;
        try {
            klass = Class.forName(name);
            return (ShaderSource)klass.newInstance();
        }
        catch (ClassNotFoundException e) {
            System.err.println(name + " class not found");
        }
        finally {
            return null;
        }
    }

    public static Renderer createRenderer(FilterContext fctx) {
        Object ref = fctx.getReferent();
        GraphicsPipeline pipe = GraphicsPipeline.getPipeline();
        if (pipe == null || !(ref instanceof Screen)) {
            return null;
        }
        Screen screen = (Screen)ref;
        ShaderSource shaderSource = null;
        if (pipe.supportsShader(GraphicsPipeline.ShaderType.HLSL, GraphicsPipeline.ShaderModel.SM3)) {
            shaderSource = PPSRenderer.createShaderSource("com.sun.scenario.effect.impl.hw.d3d.D3DShaderSource");
        } else if (pipe.supportsShader(GraphicsPipeline.ShaderType.GLSL, GraphicsPipeline.ShaderModel.SM3)) {
            shaderSource = PPSRenderer.createShaderSource("com.sun.scenario.effect.impl.es2.ES2ShaderSource");
        } else {
            throw new InternalError("Unknown GraphicsPipeline");
        }
        if (shaderSource == null) {
            return null;
        }
        return new PPSRenderer(screen, shaderSource);
    }
}

