/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWMaskTexture;
import com.sun.prism.sw.SWResourceFactory;

abstract class SWTexture
implements Texture {
    boolean allocated = false;
    int physicalWidth;
    int physicalHeight;
    int contentWidth;
    int contentHeight;
    private SWResourceFactory factory;
    private int lastImageSerial;
    private final Texture.WrapMode wrapMode;
    private boolean linearFiltering = true;
    private int lockcount;
    boolean permanent;
    int employcount;

    static Texture create(SWResourceFactory factory, PixelFormat formatHint, Texture.WrapMode wrapMode, int w, int h) {
        switch (formatHint) {
            case BYTE_ALPHA: {
                return new SWMaskTexture(factory, wrapMode, w, h);
            }
        }
        return new SWArgbPreTexture(factory, wrapMode, w, h);
    }

    SWTexture(SWResourceFactory factory, Texture.WrapMode wrapMode, int w, int h) {
        this.factory = factory;
        this.wrapMode = wrapMode;
        this.physicalWidth = w;
        this.physicalHeight = h;
        this.contentWidth = w;
        this.contentHeight = h;
        this.lock();
    }

    SWTexture(SWTexture sharedTex, Texture.WrapMode altMode) {
        this.allocated = sharedTex.allocated;
        this.physicalWidth = sharedTex.physicalWidth;
        this.physicalHeight = sharedTex.physicalHeight;
        this.contentWidth = sharedTex.contentWidth;
        this.contentHeight = sharedTex.contentHeight;
        this.factory = sharedTex.factory;
        this.lastImageSerial = sharedTex.lastImageSerial;
        this.linearFiltering = sharedTex.linearFiltering;
        this.wrapMode = altMode;
        this.lock();
    }

    SWResourceFactory getResourceFactory() {
        return this.factory;
    }

    int getOffset() {
        return 0;
    }

    @Override
    public void lock() {
        ++this.lockcount;
    }

    @Override
    public void unlock() {
        this.assertLocked();
        --this.lockcount;
    }

    @Override
    public boolean isLocked() {
        return this.lockcount > 0;
    }

    @Override
    public int getLockCount() {
        return this.lockcount;
    }

    @Override
    public void assertLocked() {
        if (this.lockcount <= 0) {
            throw new IllegalStateException("texture not locked");
        }
    }

    @Override
    public void makePermanent() {
        this.permanent = true;
    }

    @Override
    public void contentsUseful() {
        this.assertLocked();
        ++this.employcount;
    }

    @Override
    public void contentsNotUseful() {
        if (this.employcount <= 0) {
            throw new IllegalStateException("Resource obsoleted too many times");
        }
        --this.employcount;
    }

    @Override
    public boolean isSurfaceLost() {
        return false;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getPhysicalWidth() {
        return this.physicalWidth;
    }

    @Override
    public int getPhysicalHeight() {
        return this.physicalHeight;
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public int getContentWidth() {
        return this.contentWidth;
    }

    @Override
    public void setContentWidth(int contentWidth) {
        if (contentWidth > this.physicalWidth) {
            throw new IllegalArgumentException("contentWidth cannot exceed physicalWidth");
        }
        this.contentWidth = contentWidth;
    }

    @Override
    public int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    public void setContentHeight(int contentHeight) {
        if (contentHeight > this.physicalHeight) {
            throw new IllegalArgumentException("contentHeight cannot exceed physicalHeight");
        }
        this.contentHeight = contentHeight;
    }

    @Override
    public int getMaxContentWidth() {
        return this.getPhysicalWidth();
    }

    @Override
    public int getMaxContentHeight() {
        return this.getPhysicalHeight();
    }

    @Override
    public int getLastImageSerial() {
        return this.lastImageSerial;
    }

    @Override
    public void setLastImageSerial(int serial) {
        this.lastImageSerial = serial;
    }

    @Override
    public void update(Image img) {
        this.update(img, 0, 0);
    }

    @Override
    public void update(Image img, int dstx, int dsty) {
        this.update(img, dstx, dsty, img.getWidth(), img.getHeight());
    }

    @Override
    public void update(Image img, int dstx, int dsty, int srcw, int srch) {
        this.update(img, dstx, dsty, srcw, srch, false);
    }

    @Override
    public void update(Image img, int dstx, int dsty, int srcw, int srch, boolean skipFlush) {
        if (PrismSettings.debug) {
            System.out.println("IMG.Bytes per pixel: " + img.getBytesPerPixelUnit());
            System.out.println("IMG.scanline: " + img.getScanlineStride());
        }
        this.update(img.getPixelBuffer(), img.getPixelFormat(), dstx, dsty, 0, 0, srcw, srch, img.getScanlineStride(), skipFlush);
    }

    @Override
    public Texture.WrapMode getWrapMode() {
        return this.wrapMode;
    }

    @Override
    public boolean getUseMipmap() {
        return false;
    }

    @Override
    public Texture getSharedTexture(Texture.WrapMode altMode) {
        this.assertLocked();
        if (this.wrapMode == altMode) {
            this.lock();
            return this;
        }
        switch (altMode) {
            case REPEAT: {
                if (this.wrapMode == Texture.WrapMode.CLAMP_TO_EDGE) break;
                return null;
            }
            case CLAMP_TO_EDGE: {
                if (this.wrapMode == Texture.WrapMode.REPEAT) break;
                return null;
            }
            default: {
                return null;
            }
        }
        return this.createSharedLockedTexture(altMode);
    }

    @Override
    public boolean getLinearFiltering() {
        return this.linearFiltering;
    }

    @Override
    public void setLinearFiltering(boolean linear) {
        this.linearFiltering = linear;
    }

    void allocate() {
        if (this.allocated) {
            return;
        }
        if (PrismSettings.debug) {
            System.out.println("PCS Texture allocating buffer: " + this + ", " + this.physicalWidth + "x" + this.physicalHeight);
        }
        this.allocateBuffer();
        this.allocated = true;
    }

    abstract void allocateBuffer();

    abstract Texture createSharedLockedTexture(Texture.WrapMode var1);
}

