/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.Mesh;
import com.sun.prism.MeshView;
import com.sun.prism.MultiTexture;
import com.sun.prism.PhongMaterial;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DFrameStats;
import com.sun.prism.d3d.D3DMesh;
import com.sun.prism.d3d.D3DMeshView;
import com.sun.prism.d3d.D3DPhongMaterial;
import com.sun.prism.d3d.D3DPipeline;
import com.sun.prism.d3d.D3DRTTexture;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.d3d.D3DShader;
import com.sun.prism.d3d.D3DSwapChain;
import com.sun.prism.d3d.D3DTexture;
import com.sun.prism.d3d.D3DVramPool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;

class D3DResourceFactory
extends BaseShaderFactory {
    private static final Map<Image, Texture> clampTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> repeatTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> mipmapTexCache = new WeakHashMap<Image, Texture>();
    private final D3DContext context;
    private final int maxTextureSize;
    private final LinkedList<D3DResource.D3DRecord> records = new LinkedList();
    static final int STATS_FREQUENCY = PrismSettings.prismStatFrequency;
    private int nFrame = -1;
    private D3DFrameStats frameStats;

    D3DResourceFactory(long pContext, Screen screen) {
        super(clampTexCache, repeatTexCache, mipmapTexCache);
        this.context = new D3DContext(pContext, screen, this);
        this.context.initState();
        this.maxTextureSize = this.computeMaxTextureSize();
        if (PrismSettings.noClampToZero && PrismSettings.verbose) {
            System.out.println("prism.noclamptozero not supported by D3D");
        }
    }

    D3DContext getContext() {
        return this.context;
    }

    @Override
    public TextureResourcePool getTextureResourcePool() {
        return D3DVramPool.instance;
    }

    private void displayPrismStatistics() {
        if (STATS_FREQUENCY > 0 && ++this.nFrame == STATS_FREQUENCY) {
            this.nFrame = 0;
            this.frameStats = this.context.getFrameStats(true, this.frameStats);
            if (this.frameStats != null) {
                System.err.println(this.frameStats.toDebugString(STATS_FREQUENCY));
            }
        }
    }

    @Override
    public boolean isDeviceReady() {
        if (this.isDisposed()) {
            return false;
        }
        this.displayPrismStatistics();
        return this.context.testLostStateAndReset();
    }

    static int nextPowerOfTwo(int val, int max) {
        int i;
        if (val > max) {
            return 0;
        }
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    @Override
    public boolean isCompatibleTexture(Texture tex) {
        return tex instanceof D3DTexture;
    }

    @Override
    public D3DTexture createTexture(PixelFormat format, Texture.Usage usagehint, Texture.WrapMode wrapMode, int w, int h) {
        return this.createTexture(format, usagehint, wrapMode, w, h, false);
    }

    @Override
    public D3DTexture createTexture(PixelFormat format, Texture.Usage usagehint, Texture.WrapMode wrapMode, int w, int h, boolean useMipmap) {
        int alloch;
        int allocw;
        if (this.checkDisposed()) {
            return null;
        }
        if (!this.isFormatSupported(format)) {
            throw new UnsupportedOperationException("Pixel format " + (Object)((Object)format) + " not supported on this device");
        }
        if (format == PixelFormat.MULTI_YCbCr_420) {
            throw new UnsupportedOperationException("MULTI_YCbCr_420 textures require a MediaFrame");
        }
        if (PrismSettings.forcePow2) {
            allocw = D3DResourceFactory.nextPowerOfTwo(w, Integer.MAX_VALUE);
            alloch = D3DResourceFactory.nextPowerOfTwo(h, Integer.MAX_VALUE);
        } else {
            allocw = w;
            alloch = h;
        }
        if (allocw <= 0 || alloch <= 0) {
            throw new RuntimeException("Illegal texture dimensions (" + allocw + "x" + alloch + ")");
        }
        int bpp = format.getBytesPerPixelUnit();
        if (allocw >= Integer.MAX_VALUE / alloch / bpp) {
            throw new RuntimeException("Illegal texture dimensions (" + allocw + "x" + alloch + ")");
        }
        D3DVramPool pool = D3DVramPool.instance;
        long size = pool.estimateTextureSize(allocw, alloch, format);
        if (!pool.prepareForAllocation(size)) {
            return null;
        }
        long pResource = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), format.ordinal(), usagehint.ordinal(), false, allocw, alloch, 0, useMipmap);
        if (pResource == 0L) {
            return null;
        }
        int texw = D3DResourceFactory.nGetTextureWidth(pResource);
        int texh = D3DResourceFactory.nGetTextureHeight(pResource);
        if (wrapMode != Texture.WrapMode.CLAMP_NOT_NEEDED && (w < texw || h < texh)) {
            wrapMode = wrapMode.simulatedVersion();
        }
        return new D3DTexture(this.context, format, wrapMode, pResource, texw, texh, w, h, useMipmap);
    }

    @Override
    public Texture createTexture(MediaFrame frame) {
        if (this.checkDisposed()) {
            return null;
        }
        frame.holdFrame();
        int width = frame.getWidth();
        int height = frame.getHeight();
        int texWidth = frame.getEncodedWidth();
        int texHeight = frame.getEncodedHeight();
        PixelFormat texFormat = frame.getPixelFormat();
        if (texFormat == PixelFormat.MULTI_YCbCr_420) {
            MultiTexture tex = new MultiTexture(texFormat, Texture.WrapMode.CLAMP_TO_EDGE, width, height);
            for (int index = 0; index < frame.planeCount(); ++index) {
                D3DTexture subTex;
                int subWidth = texWidth;
                int subHeight = texHeight;
                if (index == 2 || index == 1) {
                    subWidth /= 2;
                    subHeight /= 2;
                }
                if ((subTex = this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_TO_EDGE, subWidth, subHeight)) == null) {
                    tex.dispose();
                    return null;
                }
                tex.setTexture(subTex, index);
            }
            frame.releaseFrame();
            return tex;
        }
        if (texWidth <= 0 || texHeight <= 0) {
            frame.releaseFrame();
            throw new RuntimeException("Illegal texture dimensions (" + texWidth + "x" + texHeight + ")");
        }
        int bpp = texFormat.getBytesPerPixelUnit();
        if (texWidth >= Integer.MAX_VALUE / texHeight / bpp) {
            frame.releaseFrame();
            throw new RuntimeException("Illegal texture dimensions (" + texWidth + "x" + texHeight + ")");
        }
        D3DVramPool pool = D3DVramPool.instance;
        long size = pool.estimateTextureSize(texWidth, texHeight, texFormat);
        if (!pool.prepareForAllocation(size)) {
            return null;
        }
        long pResource = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), texFormat.ordinal(), Texture.Usage.DYNAMIC.ordinal(), false, texWidth, texHeight, 0, false);
        if (0L == pResource) {
            return null;
        }
        int physWidth = D3DResourceFactory.nGetTextureWidth(pResource);
        int physHeight = D3DResourceFactory.nGetTextureHeight(pResource);
        Texture.WrapMode wrapMode = texWidth < physWidth || texHeight < physHeight ? Texture.WrapMode.CLAMP_TO_EDGE_SIMULATED : Texture.WrapMode.CLAMP_TO_EDGE;
        D3DTexture tex = new D3DTexture(this.context, texFormat, wrapMode, pResource, physWidth, physHeight, width, height, false);
        frame.releaseFrame();
        return tex;
    }

    @Override
    public int getRTTWidth(int w, Texture.WrapMode wrapMode) {
        return w;
    }

    @Override
    public int getRTTHeight(int h, Texture.WrapMode wrapMode) {
        return h;
    }

    @Override
    public D3DRTTexture createRTTexture(int width, int height, Texture.WrapMode wrapMode) {
        return this.createRTTexture(width, height, wrapMode, false);
    }

    @Override
    public D3DRTTexture createRTTexture(int width, int height, Texture.WrapMode wrapMode, boolean msaa) {
        int maxSamples;
        if (this.checkDisposed()) {
            return null;
        }
        if (PrismSettings.verbose && this.context.isLost()) {
            System.err.println("RT Texture allocation while the device is lost");
        }
        int createw = width;
        int createh = height;
        int cx = 0;
        int cy = 0;
        if (PrismSettings.forcePow2) {
            createw = D3DResourceFactory.nextPowerOfTwo(createw, Integer.MAX_VALUE);
            createh = D3DResourceFactory.nextPowerOfTwo(createh, Integer.MAX_VALUE);
        }
        if (createw <= 0 || createh <= 0) {
            throw new RuntimeException("Illegal texture dimensions (" + createw + "x" + createh + ")");
        }
        PixelFormat format = PixelFormat.INT_ARGB_PRE;
        int bpp = format.getBytesPerPixelUnit();
        if (createw >= Integer.MAX_VALUE / createh / bpp) {
            throw new RuntimeException("Illegal texture dimensions (" + createw + "x" + createh + ")");
        }
        D3DVramPool pool = D3DVramPool.instance;
        int aaSamples = msaa ? ((maxSamples = D3DPipeline.getInstance().getMaxSamples()) < 2 ? 0 : (maxSamples < 4 ? 2 : 4)) : 0;
        long size = pool.estimateRTTextureSize(width, height, false);
        if (!pool.prepareForAllocation(size)) {
            return null;
        }
        long pResource = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), format.ordinal(), Texture.Usage.DEFAULT.ordinal(), true, createw, createh, aaSamples, false);
        if (pResource == 0L) {
            return null;
        }
        int texw = D3DResourceFactory.nGetTextureWidth(pResource);
        int texh = D3DResourceFactory.nGetTextureHeight(pResource);
        D3DRTTexture rtt = new D3DRTTexture(this.context, wrapMode, pResource, texw, texh, cx, cy, width, height, aaSamples);
        rtt.createGraphics().clear();
        return rtt;
    }

    @Override
    public Presentable createPresentable(PresentableState pState) {
        long pResource;
        if (this.checkDisposed()) {
            return null;
        }
        if (PrismSettings.verbose && this.context.isLost()) {
            System.err.println("SwapChain allocation while the device is lost");
        }
        if ((pResource = D3DResourceFactory.nCreateSwapChain(this.context.getContextHandle(), pState.getNativeView(), PrismSettings.isVsyncEnabled)) != 0L) {
            int width = pState.getRenderWidth();
            int height = pState.getRenderHeight();
            D3DRTTexture rtt = this.createRTTexture(width, height, Texture.WrapMode.CLAMP_NOT_NEEDED, pState.isMSAA());
            if (PrismSettings.dirtyOptsEnabled) {
                rtt.contentsUseful();
            }
            if (rtt != null) {
                return new D3DSwapChain(this.context, pResource, rtt, pState.getRenderScale());
            }
            D3DResourceFactory.nReleaseResource(this.context.getContextHandle(), pResource);
        }
        return null;
    }

    private static ByteBuffer getBuffer(InputStream is) {
        if (is == null) {
            throw new RuntimeException("InputStream must be non-null");
        }
        try {
            int len = 4096;
            byte[] data = new byte[len];
            BufferedInputStream bis = new BufferedInputStream(is, len);
            int offset = 0;
            int readBytes = -1;
            while ((readBytes = bis.read(data, offset, len - offset)) != -1) {
                if (len - (offset += readBytes) != 0) continue;
                byte[] newdata = new byte[len *= 2];
                System.arraycopy(data, 0, newdata, 0, data.length);
                data = newdata;
            }
            bis.close();
            ByteBuffer buf = ByteBuffer.allocateDirect(offset);
            buf.put(data, 0, offset);
            return buf;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading D3D shader object", e);
        }
    }

    @Override
    public Shader createShader(InputStream pixelShaderCode, Map<String, Integer> samplers, Map<String, Integer> params, int maxTexCoordIndex, boolean isPixcoordUsed, boolean isPerVertexColorUsed) {
        if (this.checkDisposed()) {
            return null;
        }
        long shaderHandle = D3DShader.init(this.context.getContextHandle(), D3DResourceFactory.getBuffer(pixelShaderCode), maxTexCoordIndex, isPixcoordUsed, isPerVertexColorUsed);
        return new D3DShader(this.context, shaderHandle, params);
    }

    @Override
    public Shader createStockShader(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Shader name must be non-null");
        }
        try {
            InputStream stream = AccessController.doPrivileged(() -> D3DResourceFactory.class.getResourceAsStream("hlsl/" + name + ".obj"));
            Class<?> klass = Class.forName("com.sun.prism.shader." + name + "_Loader");
            Method m = klass.getMethod("loadShader", ShaderFactory.class, InputStream.class);
            return (Shader)m.invoke(null, this, stream);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalError("Error loading stock shader " + name);
        }
    }

    @Override
    public boolean isFormatSupported(PixelFormat format) {
        return true;
    }

    private int computeMaxTextureSize() {
        int size = D3DResourceFactory.nGetMaximumTextureSize(this.context.getContextHandle());
        if (PrismSettings.verbose) {
            System.err.println("Maximum supported texture size: " + size);
        }
        if (size > PrismSettings.maxTextureSize) {
            size = PrismSettings.maxTextureSize;
            if (PrismSettings.verbose) {
                System.err.println("Maximum texture size clamped to " + size);
            }
        }
        return size;
    }

    @Override
    public int getMaximumTextureSize() {
        return this.maxTextureSize;
    }

    @Override
    protected void notifyReset() {
        ListIterator it = this.records.listIterator();
        while (it.hasNext()) {
            D3DResource.D3DRecord r = (D3DResource.D3DRecord)it.next();
            if (!r.isDefaultPool()) continue;
            r.markDisposed();
            it.remove();
        }
        super.notifyReset();
    }

    @Override
    public void dispose() {
        this.context.dispose();
        ListIterator it = this.records.listIterator();
        while (it.hasNext()) {
            D3DResource.D3DRecord r = (D3DResource.D3DRecord)it.next();
            r.markDisposed();
        }
        this.records.clear();
        super.dispose();
    }

    void addRecord(D3DResource.D3DRecord record) {
        this.records.add(record);
    }

    void removeRecord(D3DResource.D3DRecord record) {
        this.records.remove(record);
    }

    @Override
    public PhongMaterial createPhongMaterial() {
        if (this.checkDisposed()) {
            return null;
        }
        return D3DPhongMaterial.create(this.context);
    }

    @Override
    public MeshView createMeshView(Mesh mesh) {
        if (this.checkDisposed()) {
            return null;
        }
        return D3DMeshView.create(this.context, (D3DMesh)mesh);
    }

    @Override
    public Mesh createMesh() {
        if (this.checkDisposed()) {
            return null;
        }
        return D3DMesh.create(this.context);
    }

    static native long nGetContext(int var0);

    static native boolean nIsDefaultPool(long var0);

    static native int nTestCooperativeLevel(long var0);

    static native int nResetDevice(long var0);

    static native long nCreateTexture(long var0, int var2, int var3, boolean var4, int var5, int var6, int var7, boolean var8);

    static native long nCreateSwapChain(long var0, long var2, boolean var4);

    static native int nReleaseResource(long var0, long var2);

    static native int nGetMaximumTextureSize(long var0);

    static native int nGetTextureWidth(long var0);

    static native int nGetTextureHeight(long var0);

    static native int nReadPixelsI(long var0, long var2, long var4, Buffer var6, int[] var7, int var8, int var9);

    static native int nReadPixelsB(long var0, long var2, long var4, Buffer var6, byte[] var7, int var8, int var9);

    static native int nUpdateTextureI(long var0, long var2, IntBuffer var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    static native int nUpdateTextureF(long var0, long var2, FloatBuffer var4, float[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    static native int nUpdateTextureB(long var0, long var2, ByteBuffer var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    static native long nGetDevice(long var0);

    static native long nGetNativeTextureObject(long var0);
}

