/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.SpinnerBehavior;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class SpinnerSkin<T>
extends BehaviorSkinBase<Spinner<T>, SpinnerBehavior<T>> {
    private TextField textField;
    private Region incrementArrow;
    private StackPane incrementArrowButton;
    private Region decrementArrow;
    private StackPane decrementArrowButton;
    private static final int ARROWS_ON_RIGHT_VERTICAL = 0;
    private static final int ARROWS_ON_LEFT_VERTICAL = 1;
    private static final int ARROWS_ON_RIGHT_HORIZONTAL = 2;
    private static final int ARROWS_ON_LEFT_HORIZONTAL = 3;
    private static final int SPLIT_ARROWS_VERTICAL = 4;
    private static final int SPLIT_ARROWS_HORIZONTAL = 5;
    private int layoutMode = 0;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");

    public SpinnerSkin(Spinner<T> spinner) {
        super(spinner, new SpinnerBehavior<T>(spinner));
        this.textField = spinner.getEditor();
        this.getChildren().add(this.textField);
        this.updateStyleClass();
        spinner.getStyleClass().addListener(c -> this.updateStyleClass());
        this.incrementArrow = new Region();
        this.incrementArrow.setFocusTraversable(false);
        this.incrementArrow.getStyleClass().setAll((String[])new String[]{"increment-arrow"});
        this.incrementArrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.incrementArrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.incrementArrow.setMouseTransparent(true);
        this.incrementArrowButton = new StackPane(){

            @Override
            public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
                switch (action) {
                    case FIRE: {
                        ((Spinner)SpinnerSkin.this.getSkinnable()).increment();
                    }
                }
                super.executeAccessibleAction(action, parameters);
            }
        };
        this.incrementArrowButton.setAccessibleRole(AccessibleRole.INCREMENT_BUTTON);
        this.incrementArrowButton.setFocusTraversable(false);
        this.incrementArrowButton.getStyleClass().setAll((String[])new String[]{"increment-arrow-button"});
        this.incrementArrowButton.getChildren().add(this.incrementArrow);
        this.incrementArrowButton.setOnMousePressed(e -> {
            ((Spinner)this.getSkinnable()).requestFocus();
            ((SpinnerBehavior)this.getBehavior()).startSpinning(true);
        });
        this.incrementArrowButton.setOnMouseReleased(e -> ((SpinnerBehavior)this.getBehavior()).stopSpinning());
        this.decrementArrow = new Region();
        this.decrementArrow.setFocusTraversable(false);
        this.decrementArrow.getStyleClass().setAll((String[])new String[]{"decrement-arrow"});
        this.decrementArrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.decrementArrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.decrementArrow.setMouseTransparent(true);
        this.decrementArrowButton = new StackPane(){

            @Override
            public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
                switch (action) {
                    case FIRE: {
                        ((Spinner)SpinnerSkin.this.getSkinnable()).decrement();
                    }
                }
                super.executeAccessibleAction(action, parameters);
            }
        };
        this.decrementArrowButton.setAccessibleRole(AccessibleRole.DECREMENT_BUTTON);
        this.decrementArrowButton.setFocusTraversable(false);
        this.decrementArrowButton.getStyleClass().setAll((String[])new String[]{"decrement-arrow-button"});
        this.decrementArrowButton.getChildren().add(this.decrementArrow);
        this.decrementArrowButton.setOnMousePressed(e -> {
            ((Spinner)this.getSkinnable()).requestFocus();
            ((SpinnerBehavior)this.getBehavior()).startSpinning(false);
        });
        this.decrementArrowButton.setOnMouseReleased(e -> ((SpinnerBehavior)this.getBehavior()).stopSpinning());
        this.getChildren().addAll((Node[])new Node[]{this.incrementArrowButton, this.decrementArrowButton});
        spinner.focusedProperty().addListener((ov, t, hasFocus) -> ((ComboBoxPopupControl.FakeFocusTextField)this.textField).setFakeFocus((boolean)hasFocus));
        spinner.addEventFilter(KeyEvent.ANY, ke -> {
            if (spinner.isEditable()) {
                if (ke.getTarget().equals(this.textField)) {
                    return;
                }
                if (ke.getCode() == KeyCode.ESCAPE) {
                    return;
                }
                if (ke.getCode() == KeyCode.F10) {
                    return;
                }
                this.textField.fireEvent(ke.copyFor(this.textField, this.textField));
                ke.consume();
            }
        });
        this.textField.addEventFilter(KeyEvent.ANY, ke -> {
            if (!spinner.isEditable()) {
                spinner.fireEvent(ke.copyFor(spinner, spinner));
                ke.consume();
            }
        });
        this.textField.focusedProperty().addListener((ov, t, hasFocus) -> {
            spinner.getProperties().put("FOCUSED", hasFocus);
            if (!hasFocus.booleanValue()) {
                this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
            } else {
                this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
            }
        });
        this.textField.focusTraversableProperty().bind(spinner.editableProperty());
        spinner.setImpl_traversalEngine(new ParentTraversalEngine(spinner, new Algorithm(){

            @Override
            public Node select(Node owner, Direction dir, TraversalContext context) {
                return null;
            }

            @Override
            public Node selectFirst(TraversalContext context) {
                return null;
            }

            @Override
            public Node selectLast(TraversalContext context) {
                return null;
            }
        }));
    }

    private void updateStyleClass() {
        ObservableList<String> styleClass = ((Spinner)this.getSkinnable()).getStyleClass();
        this.layoutMode = styleClass.contains("arrows-on-left-vertical") ? 1 : (styleClass.contains("arrows-on-left-horizontal") ? 3 : (styleClass.contains("arrows-on-right-horizontal") ? 2 : (styleClass.contains("split-arrows-vertical") ? 4 : (styleClass.contains("split-arrows-horizontal") ? 5 : 0))));
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        double incrementArrowButtonWidth = this.incrementArrowButton.snappedLeftInset() + this.snapSize(this.incrementArrow.prefWidth(-1.0)) + this.incrementArrowButton.snappedRightInset();
        double decrementArrowButtonWidth = this.decrementArrowButton.snappedLeftInset() + this.snapSize(this.decrementArrow.prefWidth(-1.0)) + this.decrementArrowButton.snappedRightInset();
        double widestArrowButton = Math.max(incrementArrowButtonWidth, decrementArrowButtonWidth);
        if (this.layoutMode == 0 || this.layoutMode == 1) {
            double textFieldStartX = this.layoutMode == 0 ? x : x + widestArrowButton;
            double buttonStartX = this.layoutMode == 0 ? x + w - widestArrowButton : x;
            double halfHeight = Math.floor(h / 2.0);
            this.textField.resizeRelocate(textFieldStartX, y, w - widestArrowButton, h);
            this.incrementArrowButton.resize(widestArrowButton, halfHeight);
            this.positionInArea(this.incrementArrowButton, buttonStartX, y, widestArrowButton, halfHeight, 0.0, HPos.CENTER, VPos.CENTER);
            this.decrementArrowButton.resize(widestArrowButton, halfHeight);
            this.positionInArea(this.decrementArrowButton, buttonStartX, y + halfHeight, widestArrowButton, h - halfHeight, 0.0, HPos.CENTER, VPos.BOTTOM);
        } else if (this.layoutMode == 2 || this.layoutMode == 3) {
            double totalButtonWidth = incrementArrowButtonWidth + decrementArrowButtonWidth;
            double textFieldStartX = this.layoutMode == 2 ? x : x + totalButtonWidth;
            double buttonStartX = this.layoutMode == 2 ? x + w - totalButtonWidth : x;
            this.textField.resizeRelocate(textFieldStartX, y, w - totalButtonWidth, h);
            this.decrementArrowButton.resize(decrementArrowButtonWidth, h);
            this.positionInArea(this.decrementArrowButton, buttonStartX, y, decrementArrowButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
            this.incrementArrowButton.resize(incrementArrowButtonWidth, h);
            this.positionInArea(this.incrementArrowButton, buttonStartX + decrementArrowButtonWidth, y, incrementArrowButtonWidth, h, 0.0, HPos.CENTER, VPos.CENTER);
        } else if (this.layoutMode == 4) {
            double incrementArrowButtonHeight = this.incrementArrowButton.snappedTopInset() + this.snapSize(this.incrementArrow.prefHeight(-1.0)) + this.incrementArrowButton.snappedBottomInset();
            double decrementArrowButtonHeight = this.decrementArrowButton.snappedTopInset() + this.snapSize(this.decrementArrow.prefHeight(-1.0)) + this.decrementArrowButton.snappedBottomInset();
            double tallestArrowButton = Math.max(incrementArrowButtonHeight, decrementArrowButtonHeight);
            this.incrementArrowButton.resize(w, tallestArrowButton);
            this.positionInArea(this.incrementArrowButton, x, y, w, tallestArrowButton, 0.0, HPos.CENTER, VPos.CENTER);
            this.textField.resizeRelocate(x, y + tallestArrowButton, w, h - 2.0 * tallestArrowButton);
            this.decrementArrowButton.resize(w, tallestArrowButton);
            this.positionInArea(this.decrementArrowButton, x, h - tallestArrowButton, w, tallestArrowButton, 0.0, HPos.CENTER, VPos.CENTER);
        } else if (this.layoutMode == 5) {
            this.decrementArrowButton.resize(widestArrowButton, h);
            this.positionInArea(this.decrementArrowButton, x, y, widestArrowButton, h, 0.0, HPos.CENTER, VPos.CENTER);
            this.textField.resizeRelocate(x + widestArrowButton, y, w - 2.0 * widestArrowButton, h);
            this.incrementArrowButton.resize(widestArrowButton, h);
            this.positionInArea(this.incrementArrowButton, w - widestArrowButton, y, widestArrowButton, h, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    @Override
    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double textfieldWidth = this.textField.prefWidth(height);
        return leftInset + textfieldWidth + rightInset;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double textFieldHeight = this.textField.prefHeight(width);
        double ph = this.layoutMode == 4 ? topInset + this.incrementArrowButton.prefHeight(width) + textFieldHeight + this.decrementArrowButton.prefHeight(width) + bottomInset : topInset + textFieldHeight + bottomInset;
        return ph;
    }

    @Override
    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((Spinner)this.getSkinnable()).prefWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((Spinner)this.getSkinnable()).prefHeight(width);
    }

    @Override
    protected double computeBaselineOffset(double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.textField.getLayoutBounds().getMinY() + this.textField.getLayoutY() + this.textField.getBaselineOffset();
    }
}

