/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TextInputControlBindings;
import com.sun.javafx.scene.control.skin.TextInputControlSkin;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.beans.InvalidationListener;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public abstract class TextInputControlBehavior<T extends TextInputControl>
extends BehaviorBase<T> {
    protected static final List<KeyBinding> TEXT_INPUT_BINDINGS = new ArrayList<KeyBinding>();
    T textInputControl;
    private KeyEvent lastEvent;
    private InvalidationListener textListener = observable -> this.invalidateBidi();
    private Bidi bidi = null;
    private Boolean mixed = null;
    private Boolean rtlText = null;
    private boolean editing = false;

    public TextInputControlBehavior(T textInputControl, List<KeyBinding> bindings) {
        super(textInputControl, bindings);
        this.textInputControl = textInputControl;
        ((TextInputControl)textInputControl).textProperty().addListener(this.textListener);
    }

    @Override
    public void dispose() {
        ((TextInputControl)this.textInputControl).textProperty().removeListener(this.textListener);
        super.dispose();
    }

    protected abstract void deleteChar(boolean var1);

    protected abstract void replaceText(int var1, int var2, String var3);

    protected abstract void setCaretAnimating(boolean var1);

    protected abstract void deleteFromLineStart();

    protected void scrollCharacterToVisible(int index) {
    }

    @Override
    protected void callActionForEvent(KeyEvent e) {
        this.lastEvent = e;
        super.callActionForEvent(e);
    }

    @Override
    public void callAction(String name) {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        boolean done = false;
        this.setCaretAnimating(false);
        if (textInputControl.isEditable()) {
            this.setEditing(true);
            done = true;
            if ("InputCharacter".equals(name)) {
                this.defaultKeyTyped(this.lastEvent);
            } else if ("Cut".equals(name)) {
                this.cut();
            } else if ("Paste".equals(name)) {
                this.paste();
            } else if ("DeleteFromLineStart".equals(name)) {
                this.deleteFromLineStart();
            } else if ("DeletePreviousChar".equals(name)) {
                this.deletePreviousChar();
            } else if ("DeleteNextChar".equals(name)) {
                this.deleteNextChar();
            } else if ("DeletePreviousWord".equals(name)) {
                this.deletePreviousWord();
            } else if ("DeleteNextWord".equals(name)) {
                this.deleteNextWord();
            } else if ("DeleteSelection".equals(name)) {
                this.deleteSelection();
            } else if ("Undo".equals(name)) {
                textInputControl.undo();
            } else if ("Redo".equals(name)) {
                textInputControl.redo();
            } else {
                done = false;
            }
            this.setEditing(false);
        }
        if (!done) {
            done = true;
            if ("Copy".equals(name)) {
                textInputControl.copy();
            } else if ("SelectBackward".equals(name)) {
                textInputControl.selectBackward();
            } else if ("SelectForward".equals(name)) {
                textInputControl.selectForward();
            } else if ("SelectLeft".equals(name)) {
                this.selectLeft();
            } else if ("SelectRight".equals(name)) {
                this.selectRight();
            } else if ("PreviousWord".equals(name)) {
                this.previousWord();
            } else if ("NextWord".equals(name)) {
                this.nextWord();
            } else if ("LeftWord".equals(name)) {
                this.leftWord();
            } else if ("RightWord".equals(name)) {
                this.rightWord();
            } else if ("SelectPreviousWord".equals(name)) {
                this.selectPreviousWord();
            } else if ("SelectNextWord".equals(name)) {
                this.selectNextWord();
            } else if ("SelectLeftWord".equals(name)) {
                this.selectLeftWord();
            } else if ("SelectRightWord".equals(name)) {
                this.selectRightWord();
            } else if ("SelectWord".equals(name)) {
                this.selectWord();
            } else if ("SelectAll".equals(name)) {
                textInputControl.selectAll();
            } else if ("Home".equals(name)) {
                textInputControl.home();
            } else if ("End".equals(name)) {
                textInputControl.end();
            } else if ("Forward".equals(name)) {
                textInputControl.forward();
            } else if ("Backward".equals(name)) {
                textInputControl.backward();
            } else if ("Right".equals(name)) {
                this.nextCharacterVisually(true);
            } else if ("Left".equals(name)) {
                this.nextCharacterVisually(false);
            } else if ("Fire".equals(name)) {
                this.fire(this.lastEvent);
            } else if ("Cancel".equals(name)) {
                this.cancelEdit(this.lastEvent);
            } else if ("Unselect".equals(name)) {
                textInputControl.deselect();
            } else if ("SelectHome".equals(name)) {
                this.selectHome();
            } else if ("SelectEnd".equals(name)) {
                this.selectEnd();
            } else if ("SelectHomeExtend".equals(name)) {
                this.selectHomeExtend();
            } else if ("SelectEndExtend".equals(name)) {
                this.selectEndExtend();
            } else if ("ToParent".equals(name)) {
                this.forwardToParent(this.lastEvent);
            } else if ("UseVK".equals(name) && PlatformImpl.isSupported(ConditionalFeature.VIRTUAL_KEYBOARD)) {
                ((TextInputControlSkin)textInputControl.getSkin()).toggleUseVK();
            } else {
                done = false;
            }
        }
        this.setCaretAnimating(true);
        if (!done) {
            if ("TraverseNext".equals(name)) {
                this.traverseNext();
            } else if ("TraversePrevious".equals(name)) {
                this.traversePrevious();
            } else {
                super.callAction(name);
            }
        }
    }

    private void defaultKeyTyped(KeyEvent event) {
        TextInputControl textInput = (TextInputControl)this.getControl();
        if (!textInput.isEditable() || textInput.isDisabled()) {
            return;
        }
        String character = event.getCharacter();
        if (character.length() == 0) {
            return;
        }
        if ((event.isControlDown() || event.isAltDown() || PlatformUtil.isMac() && event.isMetaDown()) && (!event.isControlDown() && !PlatformUtil.isMac() || !event.isAltDown())) {
            return;
        }
        if (character.charAt(0) > '\u001f' && character.charAt(0) != '\u007f' && !event.isMetaDown()) {
            IndexRange selection = textInput.getSelection();
            int start = selection.getStart();
            int end = selection.getEnd();
            this.replaceText(start, end, character);
            this.scrollCharacterToVisible(start);
        }
    }

    private void invalidateBidi() {
        this.bidi = null;
        this.mixed = null;
        this.rtlText = null;
    }

    private Bidi getBidi() {
        if (this.bidi == null) {
            this.bidi = new Bidi(((TextInputControl)this.textInputControl).textProperty().getValueSafe(), ((Node)this.textInputControl).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? 1 : 0);
        }
        return this.bidi;
    }

    protected boolean isMixed() {
        if (this.mixed == null) {
            this.mixed = this.getBidi().isMixed();
        }
        return this.mixed;
    }

    protected boolean isRTLText() {
        if (this.rtlText == null) {
            Bidi bidi = this.getBidi();
            this.rtlText = bidi.isRightToLeft() || this.isMixed() && ((Node)this.textInputControl).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        }
        return this.rtlText;
    }

    private void nextCharacterVisually(boolean moveRight) {
        if (this.isMixed()) {
            TextInputControlSkin skin = (TextInputControlSkin)((Control)this.textInputControl).getSkin();
            skin.nextCharacterVisually(moveRight);
        } else if (moveRight != this.isRTLText()) {
            ((TextInputControl)this.textInputControl).forward();
        } else {
            ((TextInputControl)this.textInputControl).backward();
        }
    }

    private void selectLeft() {
        if (this.isRTLText()) {
            ((TextInputControl)this.textInputControl).selectForward();
        } else {
            ((TextInputControl)this.textInputControl).selectBackward();
        }
    }

    private void selectRight() {
        if (this.isRTLText()) {
            ((TextInputControl)this.textInputControl).selectBackward();
        } else {
            ((TextInputControl)this.textInputControl).selectForward();
        }
    }

    private void deletePreviousChar() {
        this.deleteChar(true);
    }

    private void deleteNextChar() {
        this.deleteChar(false);
    }

    protected void deletePreviousWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        int end = textInputControl.getCaretPosition();
        if (end > 0) {
            textInputControl.previousWord();
            int start = textInputControl.getCaretPosition();
            this.replaceText(start, end, "");
        }
    }

    protected void deleteNextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        int start = textInputControl.getCaretPosition();
        if (start < textInputControl.getLength()) {
            this.nextWord();
            int end = textInputControl.getCaretPosition();
            this.replaceText(start, end, "");
        }
    }

    private void deleteSelection() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        IndexRange selection = textInputControl.getSelection();
        if (selection.getLength() > 0) {
            this.deleteChar(false);
        }
    }

    private void cut() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        textInputControl.cut();
    }

    private void paste() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        textInputControl.paste();
    }

    protected void selectPreviousWord() {
        ((TextInputControl)this.getControl()).selectPreviousWord();
    }

    protected void selectNextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            textInputControl.selectEndOfNextWord();
        } else {
            textInputControl.selectNextWord();
        }
    }

    private void selectLeftWord() {
        if (this.isRTLText()) {
            this.selectNextWord();
        } else {
            this.selectPreviousWord();
        }
    }

    private void selectRightWord() {
        if (this.isRTLText()) {
            this.selectPreviousWord();
        } else {
            this.selectNextWord();
        }
    }

    protected void selectWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        textInputControl.previousWord();
        if (PlatformUtil.isWindows()) {
            textInputControl.selectNextWord();
        } else {
            textInputControl.selectEndOfNextWord();
        }
    }

    protected void previousWord() {
        ((TextInputControl)this.getControl()).previousWord();
    }

    protected void nextWord() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        if (PlatformUtil.isMac() || PlatformUtil.isLinux()) {
            textInputControl.endOfNextWord();
        } else {
            textInputControl.nextWord();
        }
    }

    private void leftWord() {
        if (this.isRTLText()) {
            this.nextWord();
        } else {
            this.previousWord();
        }
    }

    private void rightWord() {
        if (this.isRTLText()) {
            this.previousWord();
        } else {
            this.nextWord();
        }
    }

    protected void fire(KeyEvent event) {
    }

    protected void cancelEdit(KeyEvent event) {
        this.forwardToParent(event);
    }

    protected void forwardToParent(KeyEvent event) {
        if (((TextInputControl)this.getControl()).getParent() != null) {
            ((TextInputControl)this.getControl()).getParent().fireEvent(event);
        }
    }

    private void selectHome() {
        ((TextInputControl)this.getControl()).selectHome();
    }

    private void selectEnd() {
        ((TextInputControl)this.getControl()).selectEnd();
    }

    private void selectHomeExtend() {
        ((TextInputControl)this.getControl()).extendSelection(0);
    }

    private void selectEndExtend() {
        TextInputControl textInputControl = (TextInputControl)this.getControl();
        textInputControl.extendSelection(textInputControl.getLength());
    }

    protected void setEditing(boolean b) {
        this.editing = b;
    }

    public boolean isEditing() {
        return this.editing;
    }

    static {
        TEXT_INPUT_BINDINGS.addAll(TextInputControlBindings.BINDINGS);
        for (KeyCode key : KeyCode.values()) {
            if (!key.isFunctionKey()) continue;
            TEXT_INPUT_BINDINGS.add(new KeyBinding(key, KeyEvent.KEY_PRESSED, null));
        }
        TEXT_INPUT_BINDINGS.add(new KeyBinding(null, KeyEvent.KEY_PRESSED, "Consume"));
    }
}

