/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Crossings {
    public static final boolean debug = false;
    int limit = 0;
    double[] yranges = new double[10];
    double xlo;
    double ylo;
    double xhi;
    double yhi;

    public Crossings(double xlo, double ylo, double xhi, double yhi) {
        this.xlo = xlo;
        this.ylo = ylo;
        this.xhi = xhi;
        this.yhi = yhi;
    }

    public final double getXLo() {
        return this.xlo;
    }

    public final double getYLo() {
        return this.ylo;
    }

    public final double getXHi() {
        return this.xhi;
    }

    public final double getYHi() {
        return this.yhi;
    }

    public abstract void record(double var1, double var3, int var5);

    public void print() {
        System.out.println("Crossings [");
        System.out.println("  bounds = [" + this.ylo + ", " + this.yhi + "]");
        for (int i = 0; i < this.limit; i += 2) {
            System.out.println("  [" + this.yranges[i] + ", " + this.yranges[i + 1] + "]");
        }
        System.out.println("]");
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(double var1, double var3);

    public static Crossings findCrossings(Vector curves, double xlo, double ylo, double xhi, double yhi) {
        EvenOdd cross = new EvenOdd(xlo, ylo, xhi, yhi);
        Enumeration enum_ = curves.elements();
        while (enum_.hasMoreElements()) {
            Curve c = (Curve)enum_.nextElement();
            if (!c.accumulateCrossings(cross)) continue;
            return null;
        }
        return cross;
    }

    public static final class EvenOdd
    extends Crossings {
        public EvenOdd(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
        }

        @Override
        public final boolean covers(double ystart, double yend) {
            return this.limit == 2 && this.yranges[0] <= ystart && this.yranges[1] >= yend;
        }

        @Override
        public void record(double ystart, double yend, int direction) {
            int from;
            if (ystart >= yend) {
                return;
            }
            for (from = 0; from < this.limit && ystart > this.yranges[from + 1]; from += 2) {
            }
            int to = from;
            while (from < this.limit) {
                double yhh;
                double yhl;
                double ylh;
                double yll;
                double yrlo = this.yranges[from++];
                double yrhi = this.yranges[from++];
                if (yend < yrlo) {
                    this.yranges[to++] = ystart;
                    this.yranges[to++] = yend;
                    ystart = yrlo;
                    yend = yrhi;
                    continue;
                }
                if (ystart < yrlo) {
                    yll = ystart;
                    ylh = yrlo;
                } else {
                    yll = yrlo;
                    ylh = ystart;
                }
                if (yend < yrhi) {
                    yhl = yend;
                    yhh = yrhi;
                } else {
                    yhl = yrhi;
                    yhh = yend;
                }
                if (ylh == yhl) {
                    ystart = yll;
                    yend = yhh;
                } else {
                    if (ylh > yhl) {
                        ystart = yhl;
                        yhl = ylh;
                        ylh = ystart;
                    }
                    if (yll != ylh) {
                        this.yranges[to++] = yll;
                        this.yranges[to++] = ylh;
                    }
                    ystart = yhl;
                    yend = yhh;
                }
                if (!(ystart >= yend)) continue;
                break;
            }
            if (to < from && from < this.limit) {
                System.arraycopy(this.yranges, from, this.yranges, to, this.limit - from);
            }
            to += this.limit - from;
            if (ystart < yend) {
                if (to >= this.yranges.length) {
                    double[] newranges = new double[to + 10];
                    System.arraycopy(this.yranges, 0, newranges, 0, to);
                    this.yranges = newranges;
                }
                this.yranges[to++] = ystart;
                this.yranges[to++] = yend;
            }
            this.limit = to;
        }
    }
}

