/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.nativelib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.scijava.nativelib.JniExtractor;
import org.scijava.nativelib.MxSysInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJniExtractor
implements JniExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger("org.scijava.nativelib.BaseJniExtractor");
    protected static final String JAVA_TMPDIR = "java.io.tmpdir";
    protected static final String ALTR_TMPDIR = "./tmplib";
    protected static final String TMP_PREFIX = "nativelib-loader_";
    private static final String LEFTOVER_MIN_AGE = "org.scijava.nativelib.leftoverMinAgeMs";
    private static final long LEFTOVER_MIN_AGE_DEFAULT = 300000L;
    private Class<?> libraryJarClass;
    private String[] nativeResourcePaths;

    public BaseJniExtractor() throws IOException {
        this.init(null);
    }

    public BaseJniExtractor(Class<?> libraryJarClass) throws IOException {
        this.init(libraryJarClass);
    }

    private void init(Class<?> libraryJarClass) {
        this.libraryJarClass = libraryJarClass;
        String mxSysInfo = MxSysInfo.getMxSysInfo();
        this.nativeResourcePaths = mxSysInfo != null ? new String[]{"natives/", "META-INF/lib/" + mxSysInfo + "/", "META-INF/lib/"} : new String[]{"natives/", "META-INF/lib/"};
        this.deleteLeftoverFiles();
    }

    private static boolean deleteRecursively(File directory) {
        if (directory == null) {
            return true;
        }
        File[] list = directory.listFiles();
        if (list == null) {
            return true;
        }
        for (File file : list) {
            if (!(file.isFile() ? !file.delete() : file.isDirectory() && !BaseJniExtractor.deleteRecursively(file))) continue;
            return false;
        }
        return directory.delete();
    }

    protected static File getTempDir() throws IOException {
        File tmpDir = new File(System.getProperty(JAVA_TMPDIR, ALTR_TMPDIR));
        if (!tmpDir.isDirectory()) {
            tmpDir.mkdirs();
            if (!tmpDir.isDirectory()) {
                throw new IOException("Unable to create temporary directory " + tmpDir);
            }
        }
        File tempFile = File.createTempFile(TMP_PREFIX, "");
        tempFile.delete();
        return tempFile;
    }

    public abstract File getNativeDir();

    public abstract File getJniDir();

    @Override
    public File extractJni(String libPath, String libname) throws IOException {
        String altLibName;
        String mappedlibName = System.mapLibraryName(libname);
        BaseJniExtractor.debug("mappedLib is " + mappedlibName);
        URL lib = null;
        if (null == this.libraryJarClass) {
            this.libraryJarClass = this.getClass();
        }
        String combinedPath = (libPath.equals("") || libPath.endsWith("/") ? libPath : libPath + "/") + mappedlibName;
        lib = this.libraryJarClass.getClassLoader().getResource(combinedPath);
        if (null == lib && (altLibName = mappedlibName.endsWith(".jnilib") ? mappedlibName.substring(0, mappedlibName.length() - 7) + ".dylib" : (mappedlibName.endsWith(".dylib") ? mappedlibName.substring(0, mappedlibName.length() - 6) + ".jnilib" : null)) != null && (lib = this.getClass().getClassLoader().getResource(libPath + altLibName)) != null) {
            mappedlibName = altLibName;
        }
        if (null != lib) {
            BaseJniExtractor.debug("URL is " + lib.toString());
            BaseJniExtractor.debug("URL path is " + lib.getPath());
            return this.extractResource(this.getJniDir(), lib, mappedlibName);
        }
        BaseJniExtractor.debug("Couldn't find resource " + combinedPath);
        return null;
    }

    @Override
    public void extractRegistered() throws IOException {
        BaseJniExtractor.debug("Extracting libraries registered in classloader " + this.getClass().getClassLoader());
        for (String nativeResourcePath : this.nativeResourcePaths) {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources(nativeResourcePath + "AUTOEXTRACT.LIST");
            while (resources.hasMoreElements()) {
                URL res = resources.nextElement();
                this.extractLibrariesFromResource(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractLibrariesFromResource(URL resource) throws IOException {
        BaseJniExtractor.debug("Extracting libraries listed in " + resource);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                URL lib = null;
                for (String nativeResourcePath : this.nativeResourcePaths) {
                    lib = this.getClass().getClassLoader().getResource(nativeResourcePath + line);
                    if (lib != null) break;
                }
                if (lib != null) {
                    this.extractResource(this.getNativeDir(), lib, line);
                    continue;
                }
                throw new IOException("Couldn't find native library " + line + "on the classpath");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File extractResource(File dir, URL resource, String outputName) throws IOException {
        InputStream in = null;
        try {
            in = resource.openStream();
            File outfile = new File(this.getJniDir(), outputName);
            BaseJniExtractor.debug("Extracting '" + resource + "' to '" + outfile.getAbsolutePath() + "'");
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outfile);
                BaseJniExtractor.copy(in, out);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            outfile.deleteOnExit();
            File file = outfile;
            return file;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    void deleteLeftoverFiles() {
        File tmpDirectory = new File(System.getProperty(JAVA_TMPDIR, ALTR_TMPDIR));
        File[] folders = tmpDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(BaseJniExtractor.TMP_PREFIX);
            }
        });
        if (folders == null) {
            return;
        }
        long leftoverMinAge = this.getLeftoverMinAge();
        for (File folder : folders) {
            long age = System.currentTimeMillis() - folder.lastModified();
            if (age < leftoverMinAge) {
                BaseJniExtractor.debug("Not deleting leftover folder " + folder + ": is " + age + "ms old");
                continue;
            }
            BaseJniExtractor.debug("Deleting leftover folder: " + folder);
            BaseJniExtractor.deleteRecursively(folder);
        }
    }

    long getLeftoverMinAge() {
        try {
            return Long.parseLong(System.getProperty(LEFTOVER_MIN_AGE, String.valueOf(300000L)));
        }
        catch (NumberFormatException e) {
            BaseJniExtractor.error("Cannot load leftover minimal age system property", e);
            return 300000L;
        }
    }

    static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] tmp = new byte[8192];
        int len = 0;
        while ((len = in.read(tmp)) > 0) {
            out.write(tmp, 0, len);
        }
    }

    private static void debug(String message) {
        LOGGER.debug(message);
    }

    private static void error(String message, Throwable t) {
        LOGGER.error(message, t);
    }
}

